/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server;

import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.cache.ICacheManager;
import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.authentication.ISessionActionListener;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.PropertyParametersUtil;
import ch.systemsx.cisd.common.servlet.IRequestContextProvider;
import ch.systemsx.cisd.common.spring.ExposablePropertyPlaceholderConfigurer;
import ch.systemsx.cisd.openbis.BuildAndEnvironmentInfo;
import ch.systemsx.cisd.openbis.generic.client.web.client.IClientService;
import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientService;
import ch.systemsx.cisd.openbis.generic.client.web.client.IOnlineHelpResourceLocatorService;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ApplicationInfo;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.IResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ResultSet;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ResultSetFetchConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ResultSetWithEntityTypes;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.SessionContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableExportCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.User;
import ch.systemsx.cisd.openbis.generic.client.web.client.exception.InvalidSessionException;
import ch.systemsx.cisd.openbis.generic.client.web.server.AbstractOriginalDataProviderWithoutHeaders;
import ch.systemsx.cisd.openbis.generic.client.web.server.UploadedFilesBean;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.CacheManager;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.CachedResultSetManager;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.DataProviderAdapter;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.ICustomColumnsProvider;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.IOriginalDataProvider;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.IResultSet;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.IResultSetManager;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.ITableModelProvider;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.TableDataCache;
import ch.systemsx.cisd.openbis.generic.client.web.server.translator.ResultSetTranslator;
import ch.systemsx.cisd.openbis.generic.client.web.server.translator.UserFailureExceptionTranslator;
import ch.systemsx.cisd.openbis.generic.client.web.server.util.TableModelUtils;
import ch.systemsx.cisd.openbis.generic.client.web.server.util.XMLPropertyTransformer;
import ch.systemsx.cisd.openbis.generic.shared.IOpenBisSessionManager;
import ch.systemsx.cisd.openbis.generic.shared.IServer;
import ch.systemsx.cisd.openbis.generic.shared.WebClientConfigurationProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.WebAppsProperties;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicEntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CustomImport;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DisplaySettings;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.GridCustomColumn;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityPropertiesHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ReportRowModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelColumnHeader;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.WebApp;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.WebClientConfiguration;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.displaysettings.IDisplaySettingsUpdate;
import ch.systemsx.cisd.openbis.generic.shared.dto.SessionContextDTO;
import ch.systemsx.cisd.openbis.generic.shared.util.ServerUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public abstract class AbstractClientService
implements IClientService,
IOnlineHelpResourceLocatorService,
ApplicationContextAware {
    protected static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, AbstractClientService.class);
    @Resource(name="request-context-provider")
    @Private
    public IRequestContextProvider requestContextProvider;
    protected ICommonClientService commonClientService;
    @Resource(name="propertyConfigurer")
    private ExposablePropertyPlaceholderConfigurer configurer;
    @Resource(name="session-manager")
    private IOpenBisSessionManager sessionManager;
    @Autowired
    private ICacheManager cacheManager;
    private final Map<String, HttpSession> httpSessionsBySessionToken = new HashMap<String, HttpSession>();
    private ISessionActionListener sessionActionListener = new ISessionActionListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sessionClosed(String sessionToken) {
            Map map = AbstractClientService.this.httpSessionsBySessionToken;
            synchronized (map) {
                AbstractClientService.this.cacheManager.clearCacheOfUser(sessionToken);
                HttpSession httpSession = (HttpSession)AbstractClientService.this.httpSessionsBySessionToken.remove(sessionToken);
                AbstractClientService.this.logout(null, true, httpSession, sessionToken);
                if (httpSession != null) {
                    operationLog.info((Object)("Session " + sessionToken + " closed. httpSessionsBySessionToken.size() = " + AbstractClientService.this.httpSessionsBySessionToken.size()));
                }
            }
        }
    };
    @Autowired
    private TableDataCache<String, Object> tableDataCache;
    private String cifexURL;
    private String cifexRecipient;
    private String onlineHelpGenericRootURL;
    private String onlineHelpGenericPageTemplate;
    private String onlineHelpSpecificRootURL;
    private String onlineHelpSpecificPageTemplate;
    @Resource(name="web-client-configuration-provider")
    @Private
    public WebClientConfigurationProvider webClientConfigurationProvider;
    private int getApplicationInfoInvocationCount = 0;
    private ApplicationContext applicationContext;

    @PostConstruct
    private void init() {
        this.commonClientService = (ICommonClientService)this.applicationContext.getBean("common-service", ICommonClientService.class);
    }

    protected AbstractClientService() {
    }

    protected AbstractClientService(IRequestContextProvider requestContextProvider) {
        this.requestContextProvider = requestContextProvider;
    }

    protected Properties getServiceProperties() {
        return this.configurer == null ? new Properties() : this.configurer.getResolvedProps();
    }

    protected void transformXML(IEntityPropertiesHolder propertiesHolder) {
        new XMLPropertyTransformer().transformXMLProperties(Arrays.asList(propertiesHolder));
    }

    protected final IResultSetManager<String> getResultSetManager() {
        HttpSession httpSession = this.getHttpSession();
        if (httpSession == null) {
            throw new ch.systemsx.cisd.openbis.generic.client.web.client.exception.UserFailureException("Your session has expired, please log in again.");
        }
        return (IResultSetManager)httpSession.getAttribute("openbis-result-set-manager");
    }

    protected final <T extends IEntityInformationHolder> ResultSetWithEntityTypes<T> listEntitiesWithTypes(IResultSetConfig<String, T> criteria, IOriginalDataProvider<T> dataProvider) {
        ResultSet<T> resultSet = this.listEntities(criteria, dataProvider);
        Set<BasicEntityType> entityTypes = this.fetchEntityTypes(dataProvider, resultSet.getResultSetKey());
        return new ResultSetWithEntityTypes<T>(resultSet, entityTypes);
    }

    protected final <T> IResultSet<String, T> getResultSet(IResultSetConfig<String, T> resultSetConfig, IOriginalDataProvider<T> dataProvider) {
        IResultSetManager<String> resultSetManager = this.getResultSetManager();
        IResultSet<String, T> result = resultSetManager.getResultSet(this.getSessionToken(), resultSetConfig, dataProvider);
        return result;
    }

    protected final <T extends IEntityInformationHolder> Set<BasicEntityType> fetchEntityTypes(IOriginalDataProvider<T> dataProvider, String resultSetKey) {
        DefaultResultSetConfig criteria = DefaultResultSetConfig.createFetchAll();
        criteria.setCacheConfig(ResultSetFetchConfig.createFetchFromCache(resultSetKey));
        IResultSet allData = this.getResultSet(criteria, dataProvider);
        HashSet<BasicEntityType> result = new HashSet<BasicEntityType>();
        for (IEntityInformationHolder row : allData.getList().extractOriginalObjects()) {
            result.add(row.getEntityType());
        }
        return result;
    }

    protected final <T> ResultSet<T> listEntities(IResultSetConfig<String, T> criteria, IOriginalDataProvider<T> dataProvider) throws ch.systemsx.cisd.openbis.generic.client.web.client.exception.UserFailureException {
        IResultSet<String, T> result = this.getResultSet(criteria, dataProvider);
        return ResultSetTranslator.translate(result, ResultSetTranslator.Escape.YES);
    }

    protected static <T> IOriginalDataProvider<T> createDummyDataProvider() {
        return new AbstractOriginalDataProviderWithoutHeaders<T>(){

            @Override
            public List<T> getFullOriginalData() throws UserFailureException {
                throw new IllegalStateException("Data not found in the cache");
            }
        };
    }

    public final void setCifexURL(String cifexURL) {
        this.cifexURL = cifexURL;
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)("Set CIFEX URL for client to '" + cifexURL + "'."));
        }
    }

    public final void setCifexRecipient(String cifexRecipient) {
        this.cifexRecipient = cifexRecipient;
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)("Set CIFEX recipient for client to '" + cifexRecipient + "'."));
        }
    }

    @Override
    public String getOnlineHelpGenericRootURL() {
        return this.onlineHelpGenericRootURL;
    }

    public void setOnlineHelpGenericRootURL(String onlineHelpGenericRootURL) {
        this.onlineHelpGenericRootURL = onlineHelpGenericRootURL;
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)("Set root ULR for generic online help to '" + onlineHelpGenericRootURL + "'."));
        }
    }

    @Override
    public String getOnlineHelpGenericPageTemplate() {
        return this.onlineHelpGenericPageTemplate;
    }

    public void setOnlineHelpGenericPageTemplate(String onlineHelpGenericPageTemplate) {
        this.onlineHelpGenericPageTemplate = onlineHelpGenericPageTemplate;
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)("Set template for generic online help to '" + onlineHelpGenericPageTemplate + "'."));
        }
    }

    @Override
    public String getOnlineHelpSpecificRootURL() {
        return this.onlineHelpSpecificRootURL;
    }

    public void setOnlineHelpSpecificRootURL(String onlineHelpSpecificRootURL) {
        this.onlineHelpSpecificRootURL = onlineHelpSpecificRootURL;
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)("Set root ULR for specific online help to '" + onlineHelpSpecificRootURL + "'."));
        }
    }

    @Override
    public String getOnlineHelpSpecificPageTemplate() {
        return this.onlineHelpSpecificPageTemplate;
    }

    public void setOnlineHelpSpecificPageTemplate(String onlineHelpSpecificPageTemplate) {
        this.onlineHelpSpecificPageTemplate = onlineHelpSpecificPageTemplate;
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)("Set template for specific online help to '" + onlineHelpSpecificPageTemplate + "'."));
        }
    }

    private final SessionContext createSessionContext(SessionContextDTO session) {
        SessionContext sessionContext = new SessionContext();
        sessionContext.setSessionID(session.getSessionToken());
        DisplaySettings displaySettings = session.getDisplaySettings();
        sessionContext.setDisplaySettings(displaySettings);
        User user = new User();
        user.setUserName(session.getUserName());
        user.setHomeGroupCode(session.tryGetHomeGroupCode());
        user.setUserEmail(session.getUserEmail());
        user.setUserPersonObject(session.getUserPersonObject());
        user.setUserPersonRoles(session.getUserPersonRoles());
        sessionContext.setUser(user);
        sessionContext.setAnonymous(session.isAnonymous());
        return sessionContext;
    }

    protected final String getSessionToken() {
        HttpSession httpSession = this.getHttpSession();
        String sessionToken = null;
        if (httpSession != null) {
            sessionToken = (String)httpSession.getAttribute("openbis-session-token");
        }
        if (sessionToken == null) {
            if (operationLog.isDebugEnabled()) {
                String sessionId = httpSession != null ? httpSession.getId() : null;
                String logMessage = String.format("Unable to find session token in session [%s], sessionId=[%s]", httpSession, sessionId);
                operationLog.debug((Object)logMessage);
            }
            throw new InvalidSessionException("Session expired. Please login again.");
        }
        return sessionToken;
    }

    protected final HttpSession getHttpSession() {
        return this.getOrCreateHttpSession(false);
    }

    private final HttpSession createHttpSession() {
        return this.getOrCreateHttpSession(true);
    }

    private final HttpSession getOrCreateHttpSession(boolean create) {
        return this.requestContextProvider.getHttpServletRequest().getSession(create);
    }

    protected final <T> CacheManager<String, T> getExportManager() {
        return (CacheManager)this.getHttpSession().getAttribute("openbis-export-manager");
    }

    protected final <T> String prepareExportEntities(TableExportCriteria<T> criteria) throws ch.systemsx.cisd.openbis.generic.client.web.client.exception.UserFailureException {
        this.getSessionToken();
        CacheManager<String, TableExportCriteria<T>> exportManager = this.getExportManager();
        return exportManager.saveData(criteria);
    }

    private CachedResultSetManager<String> createCachedResultSetManager() {
        return new CachedResultSetManager<String>(this.tableDataCache, new CacheManager.TokenBasedResultSetKeyGenerator(), new ICustomColumnsProvider(){

            @Override
            public List<GridCustomColumn> getGridCustomColumn(String sessionToken, String gridDisplayId) {
                return AbstractClientService.this.getServer().listGridCustomColumns(sessionToken, gridDisplayId);
            }
        });
    }

    protected String saveReportInCache(final TableModel reportTableModel) {
        DefaultResultSetConfig criteria = new DefaultResultSetConfig();
        criteria.setLimit(0);
        ResultSet<TableModelRowWithObject<ReportRowModel>> resultSet = this.listEntities(criteria, new IOriginalDataProvider<TableModelRowWithObject<ReportRowModel>>(){

            @Override
            public List<TableModelRowWithObject<ReportRowModel>> getOriginalData(int maxSize) throws UserFailureException {
                return TableModelUtils.asTableModelRowsWithReportRowModels(reportTableModel.getRows());
            }

            @Override
            public List<TableModelColumnHeader> getHeaders() {
                return reportTableModel.getHeader();
            }
        });
        return resultSet.getResultSetKey();
    }

    protected abstract IServer getServer();

    @Override
    public final ApplicationInfo getApplicationInfo() {
        ApplicationInfo applicationInfo = new ApplicationInfo();
        if (this.commonClientService == null || this.commonClientService == this || this.getApplicationInfoInvocationCount > 0) {
            applicationInfo.setCifexURL(this.cifexURL);
            applicationInfo.setCifexRecipient(this.cifexRecipient);
            applicationInfo.setWebClientConfiguration(this.getWebClientConfiguration());
        } else {
            ++this.getApplicationInfoInvocationCount;
            ApplicationInfo commonApplicationInfo = this.commonClientService.getApplicationInfo();
            --this.getApplicationInfoInvocationCount;
            applicationInfo.setCifexURL(commonApplicationInfo.getCifexURL());
            applicationInfo.setCifexRecipient(commonApplicationInfo.getCifexRecipient());
            applicationInfo.setMaxResults(commonApplicationInfo.getMaxResults());
            applicationInfo.setWebClientConfiguration(commonApplicationInfo.getWebClientConfiguration());
        }
        applicationInfo.setEnabledTechnologies(ServerUtils.extractSet(this.getServiceProperties().getProperty("enabled-modules")));
        applicationInfo.setCustomImports(this.extractCustomImportProperties());
        applicationInfo.setWebapps(this.extractWebAppsProperties());
        applicationInfo.setArchivingConfigured(this.isArchivingConfigured());
        applicationInfo.setProjectSamplesEnabled(this.isProjectSamplesEnabled());
        applicationInfo.setProjectLevelAuthorizationEnabled(this.isProjectLevelAuthorizationEnabled());
        applicationInfo.setProjectLevelAuthorizationUser(this.isProjectLevelAuthorizationUser());
        applicationInfo.setVersion(this.getVersion());
        return applicationInfo;
    }

    private List<CustomImport> extractCustomImportProperties() {
        PropertyParametersUtil.SectionProperties[] sectionProperties;
        ArrayList<CustomImport> results = new ArrayList<CustomImport>();
        for (PropertyParametersUtil.SectionProperties props : sectionProperties = PropertyParametersUtil.extractSectionProperties((Properties)this.getServiceProperties(), (String)CustomImport.PropertyNames.CUSTOM_IMPORTS.getName(), (boolean)false)) {
            HashMap<String, String> properties = new HashMap<String, String>();
            for (Map.Entry<Object, Object> entry : props.getProperties().entrySet()) {
                properties.put((String)entry.getKey(), (String)entry.getValue());
            }
            results.add(new CustomImport(props.getKey(), properties));
        }
        return results;
    }

    private List<WebApp> extractWebAppsProperties() {
        WebAppsProperties webAppsProperties = new WebAppsProperties(this.getServiceProperties());
        return webAppsProperties.getWebApps();
    }

    @Override
    public final List<CustomImport> getCustomImports() {
        return this.extractCustomImportProperties();
    }

    @Override
    public void deactivatePersons(List<String> personsCodes) throws UserFailureException {
        String sessionToken = this.getSessionToken();
        this.getServer().deactivatePersons(sessionToken, personsCodes);
    }

    @Override
    public int countActiveUsers() throws UserFailureException {
        String sessionToken = this.getSessionToken();
        return this.getServer().countActivePersons(sessionToken);
    }

    protected WebClientConfiguration getWebClientConfiguration() {
        return this.webClientConfigurationProvider.getWebClientConfiguration();
    }

    protected boolean isTrashEnabled() {
        return this.getWebClientConfiguration().getEnableTrash();
    }

    protected String getVersion() {
        return BuildAndEnvironmentInfo.INSTANCE.getFullVersion();
    }

    private boolean isArchivingConfigured() {
        try {
            return this.getServer().isArchivingConfigured(this.getSessionToken());
        }
        catch (InvalidSessionException invalidSessionException) {
            return false;
        }
    }

    private boolean isProjectSamplesEnabled() {
        try {
            return this.getServer().isProjectSamplesEnabled(this.getSessionToken());
        }
        catch (InvalidSessionException invalidSessionException) {
            return false;
        }
    }

    private boolean isProjectLevelAuthorizationEnabled() {
        try {
            return this.getServer().isProjectLevelAuthorizationEnabled(this.getSessionToken());
        }
        catch (InvalidSessionException invalidSessionException) {
            return false;
        }
    }

    private boolean isProjectLevelAuthorizationUser() {
        try {
            return this.getServer().isProjectLevelAuthorizationUser(this.getSessionToken());
        }
        catch (InvalidSessionException invalidSessionException) {
            return false;
        }
    }

    @Override
    public final SessionContext tryToGetCurrentSessionContext(boolean anonymous, String sessionIdOrNull) {
        boolean sessionIdSpecified = sessionIdOrNull != null;
        try {
            String sessionToken = sessionIdSpecified ? sessionIdOrNull : this.getSessionToken();
            SessionContextDTO session = this.getServer().tryGetSession(sessionToken);
            if (session == null) {
                return null;
            }
            if (!anonymous && session.isAnonymous()) {
                operationLog.debug((Object)("expected: " + anonymous + " found: " + session.isAnonymous()));
                this.getServer().logout(sessionToken);
                return null;
            }
            return sessionIdSpecified ? this.tryToLogin(session) : this.createSessionContext(session);
        }
        catch (InvalidSessionException e) {
            return null;
        }
    }

    @Override
    public final SessionContext tryToLoginAnonymously() {
        try {
            SessionContextDTO session = this.getServer().tryAuthenticateAnonymously();
            return this.tryToLogin(session);
        }
        catch (UserFailureException e) {
            throw UserFailureExceptionTranslator.translate(e);
        }
        catch (IllegalStateException e) {
            operationLog.error((Object)"Session already invalidated.", (Throwable)e);
            return null;
        }
    }

    @Override
    public final SessionContext tryToLogin(String userID, String password) {
        try {
            SessionContextDTO session = this.getServer().tryAuthenticate(userID, password);
            return this.tryToLogin(session);
        }
        catch (IllegalStateException e) {
            operationLog.error((Object)"Session already invalidated.", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SessionContext tryToLogin(SessionContextDTO session) {
        if (session == null) {
            return null;
        }
        HttpSession httpSession = this.createHttpSession();
        Map<String, HttpSession> map = this.httpSessionsBySessionToken;
        synchronized (map) {
            this.httpSessionsBySessionToken.put(session.getSessionToken(), httpSession);
            operationLog.info((Object)("httpSessionsBySessionToken.size() = " + this.httpSessionsBySessionToken.size()));
        }
        int sessionExpirationTimeInMillis = session.getSessionExpirationTime();
        int sessionExpirationTimeInSeconds = sessionExpirationTimeInMillis / 1000;
        if (sessionExpirationTimeInMillis < 0) {
            httpSession.setMaxInactiveInterval(-1);
        } else if (sessionExpirationTimeInSeconds < 10) {
            httpSession.setMaxInactiveInterval(0);
        } else {
            httpSession.setMaxInactiveInterval(sessionExpirationTimeInSeconds - 10);
        }
        httpSession.setAttribute("openbis-session-token", (Object)session.getSessionToken());
        httpSession.setAttribute("openbis-server", (Object)this.getServer());
        httpSession.setAttribute("openbis-result-set-manager", this.createCachedResultSetManager());
        httpSession.setAttribute("openbis-export-manager", CacheManager.createCacheManager());
        return this.createSessionContext(session);
    }

    @Override
    public void setBaseURL(String baseURL) {
        try {
            String sessionToken = this.getSessionToken();
            IServer server = this.getServer();
            server.setBaseIndexURL(sessionToken, baseURL);
            if (operationLog.isInfoEnabled()) {
                operationLog.info((Object)("Set openBIS base URL for client to '" + baseURL + "'."));
            }
        }
        catch (InvalidSessionException invalidSessionException) {
            // empty catch block
        }
    }

    @Override
    public void saveDisplaySettings(DisplaySettings displaySettings) {
        try {
            String sessionToken = this.getSessionToken();
            IServer server = this.getServer();
            int maxEntityVisits = this.getWebClientConfiguration().getMaxEntityVisits();
            server.saveDisplaySettings(sessionToken, displaySettings, maxEntityVisits);
        }
        catch (InvalidSessionException sessionToken) {
        }
        catch (UserFailureException e) {
            throw UserFailureExceptionTranslator.translate(e);
        }
    }

    @Override
    public void updateDisplaySettings(IDisplaySettingsUpdate displaySettingsUpdate) {
        try {
            String sessionToken = this.getSessionToken();
            IServer server = this.getServer();
            server.updateDisplaySettings(sessionToken, displaySettingsUpdate);
        }
        catch (InvalidSessionException sessionToken) {
        }
        catch (UserFailureException e) {
            throw UserFailureExceptionTranslator.translate(e);
        }
    }

    @Override
    public DisplaySettings resetDisplaySettings() {
        try {
            String sessionToken = this.getSessionToken();
            IServer server = this.getServer();
            DisplaySettings defaultSettings = server.getDefaultDisplaySettings(sessionToken);
            this.saveDisplaySettings(defaultSettings);
            return defaultSettings;
        }
        catch (InvalidSessionException sessionToken) {
        }
        catch (UserFailureException e) {
            throw UserFailureExceptionTranslator.translate(e);
        }
        return null;
    }

    @Override
    public void changeUserHomeSpace(TechId groupIdOrNull) {
        try {
            String sessionToken = this.getSessionToken();
            IServer server = this.getServer();
            server.changeUserHomeSpace(sessionToken, groupIdOrNull);
        }
        catch (InvalidSessionException sessionToken) {
        }
        catch (UserFailureException e) {
            throw UserFailureExceptionTranslator.translate(e);
        }
    }

    @Override
    public final void logout(DisplaySettings displaySettings, boolean simpleViewMode) {
        try {
            HttpSession httpSession = this.getHttpSession();
            String sessionToken = this.getSessionToken();
            this.logout(displaySettings, simpleViewMode, httpSession, sessionToken);
        }
        catch (Exception e) {
            operationLog.info((Object)("logout exception: " + e));
        }
    }

    private void logout(DisplaySettings displaySettings, boolean simpleViewMode, HttpSession httpSession, String sessionToken) {
        if (httpSession != null) {
            httpSession.removeAttribute("openbis-session-token");
            httpSession.removeAttribute("openbis-server");
            httpSession.removeAttribute("openbis-result-set-manager");
            httpSession.removeAttribute("openbis-export-manager");
            httpSession.invalidate();
            IServer server = this.getServer();
            if (!simpleViewMode) {
                int maxEntityVisits = this.getWebClientConfiguration().getMaxEntityVisits();
                server.saveDisplaySettings(sessionToken, displaySettings, maxEntityVisits);
            }
            server.logout(sessionToken);
        }
    }

    protected <T extends Serializable> TypedTableResultSet<T> listEntities(ITableModelProvider<T> provider, IResultSetConfig<String, TableModelRowWithObject<T>> criteria) {
        DataProviderAdapter<T> dataProvider = new DataProviderAdapter<T>(provider);
        ResultSet<TableModelRowWithObject<T>> resultSet = this.listEntities(criteria, dataProvider);
        return new TypedTableResultSet<T>(resultSet);
    }

    protected static void cleanUploadedFiles(String sessionKey, HttpSession session, UploadedFilesBean uploadedFiles) {
        if (uploadedFiles != null) {
            uploadedFiles.deleteTransferredFiles();
        }
        if (session != null) {
            session.removeAttribute(sessionKey);
        }
    }

    protected static UploadedFilesBean getUploadedFiles(String sessionKey, HttpSession session) {
        if (session.getAttribute(sessionKey) == null || !(session.getAttribute(sessionKey) instanceof UploadedFilesBean)) {
            throw new IllegalStateException(String.format("No UploadedFilesBean object as session attribute '%s' found.", sessionKey));
        }
        return (UploadedFilesBean)session.getAttribute(sessionKey);
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.sessionManager.addListener(this.sessionActionListener);
    }
}

