/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientService;
import ch.systemsx.cisd.openbis.generic.client.web.server.AbstractFileDownloadServlet;
import ch.systemsx.cisd.openbis.generic.client.web.server.util.HttpUtils;
import ch.systemsx.cisd.openbis.generic.client.web.server.util.OSKind;
import java.io.IOException;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class FileExportServiceServlet
extends AbstractFileDownloadServlet {
    @Resource(name="common-service")
    private ICommonClientService service;

    @Override
    @RequestMapping(value={"/export-file-downloader", "/openbis/export-file-downloader"})
    protected void respondToRequest(HttpServletRequest request, HttpServletResponse response) throws Exception, IOException {
        super.respondToRequest(request, response);
    }

    @Override
    protected AbstractFileDownloadServlet.FileContent getFileContent(HttpServletRequest request) throws Exception {
        String exportDataKey = request.getParameter("exportDataKey");
        if (StringUtils.isNotBlank((CharSequence)exportDataKey)) {
            OSKind osKind = HttpUtils.figureOperatingSystemKind(request);
            String lineSeparator = osKind.getLineSeparator();
            String fileContent = this.service.getExportTable(exportDataKey, lineSeparator);
            byte[] value = fileContent.getBytes("UTF-8");
            String fileName = request.getParameter("fileName");
            return new AbstractFileDownloadServlet.FileContent(value, fileName == null ? "exportedData.txt" : fileName);
        }
        return null;
    }
}

