/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientService;
import ch.systemsx.cisd.openbis.generic.client.web.server.AbstractFileDownloadServlet;
import ch.systemsx.cisd.openbis.generic.shared.IOpenBisSessionManager;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BatchOperationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import java.io.IOException;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.HttpSessionRequiredException;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class FileTemplateServiceServlet
extends AbstractFileDownloadServlet {
    @Resource(name="common-service")
    private ICommonClientService service;
    @Resource(name="session-manager")
    protected IOpenBisSessionManager sessionManager;

    protected FileTemplateServiceServlet() {
        this.setSynchronizeOnSession(true);
        this.setRequireSession(false);
    }

    @Override
    @RequestMapping(value={"/template-download", "/openbis/template-download"})
    protected void respondToRequest(HttpServletRequest request, HttpServletResponse response) throws Exception, IOException {
        super.respondToRequest(request, response);
    }

    protected Session getSession(String sessionToken) {
        assert (sessionToken != null) : "Unspecified session token";
        return (Session)this.sessionManager.getSession(sessionToken);
    }

    protected HttpSession getSession(HttpServletRequest request) {
        Session sessionFromToken;
        String tokenBeingUsed;
        Session sessionFromToken2;
        HttpSession session = request.getSession(false);
        String sessionToken = request.getParameter("sessionID");
        if (session == null && sessionToken != null && !sessionToken.isEmpty() && (sessionFromToken2 = this.getSession(sessionToken)) != null) {
            session = request.getSession();
            session.setAttribute("openbis-session-token", (Object)sessionFromToken2.getSessionToken());
        }
        if (session != null && sessionToken != null && !sessionToken.isEmpty() && !sessionToken.equals(tokenBeingUsed = (String)session.getAttribute("openbis-session-token")) && (sessionFromToken = this.getSession(sessionToken)) != null) {
            session.setAttribute("openbis-session-token", (Object)sessionFromToken.getSessionToken());
        }
        return session;
    }

    @Override
    protected AbstractFileDownloadServlet.FileContent getFileContent(HttpServletRequest request) throws Exception {
        if (this.getSession(request) == null) {
            throw new HttpSessionRequiredException("Pre-existing session required but none found");
        }
        String kind = request.getParameter("entityKind");
        String type = request.getParameter("entityType");
        String format = request.getParameter("fileFormat");
        if (format == null) {
            format = "tsv";
        }
        String autoGenerate = request.getParameter("autoGenerate");
        String withExperimentsParameter = request.getParameter("with_experiments");
        boolean withExperiments = withExperimentsParameter != null && Boolean.parseBoolean(withExperimentsParameter);
        String withSpaceParameter = request.getParameter("with_space");
        boolean withSpace = withSpaceParameter == null || Boolean.parseBoolean(withSpaceParameter);
        String operationKindParameter = request.getParameter("batch_operation_kind");
        BatchOperationKind operationKind = BatchOperationKind.valueOf(operationKindParameter);
        if (StringUtils.isNotBlank((CharSequence)kind) && StringUtils.isNotBlank((CharSequence)type)) {
            String fileContent = this.service.getTemplate(EntityKind.valueOf((String)kind), type, format != null ? format : "tsv", Boolean.parseBoolean(autoGenerate), withExperiments, withSpace, operationKind);
            byte[] value = fileContent.getBytes();
            String fileName = kind + "-" + type + "-template." + format;
            return new AbstractFileDownloadServlet.FileContent(value, fileName);
        }
        return null;
    }
}

