/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server;

import ch.systemsx.cisd.common.string.Template;
import ch.systemsx.cisd.openbis.generic.client.web.client.IOnlineHelpResourceLocatorService;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

@Controller
public class HelpRedirectServlet
extends AbstractController {
    @Resource(name="common-service")
    private IOnlineHelpResourceLocatorService service;

    public HelpRedirectServlet() {
    }

    HelpRedirectServlet(IOnlineHelpResourceLocatorService service) {
        this.service = service;
    }

    @RequestMapping(value={"/help", "/openbis/help"})
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.sendRedirect(this.getHelpPageAbsoluteURLForRequest(request));
        return null;
    }

    private boolean getIsSpecificForRequest(HttpServletRequest request) {
        String isSpecificString = request.getParameter("specific");
        boolean isSpecific = new Boolean(isSpecificString);
        return isSpecific;
    }

    private String getRootURL(boolean isSpecific) {
        if (!isSpecific) {
            return this.service.getOnlineHelpGenericRootURL();
        }
        String specificURL = this.service.getOnlineHelpSpecificRootURL();
        if ("".equals(specificURL)) {
            return this.service.getOnlineHelpGenericRootURL();
        }
        return specificURL;
    }

    private Template getPageTemplate(boolean isSpecific) {
        String templateString = isSpecific ? this.service.getOnlineHelpSpecificPageTemplate() : this.service.getOnlineHelpGenericPageTemplate();
        return new Template(templateString);
    }

    private String getHelpPageAbsoluteURLForRequest(HttpServletRequest request) {
        String pageTitle = this.tryGetHelpPageTitleForRequest(request);
        boolean isSpecific = this.getIsSpecificForRequest(request);
        if (null == pageTitle) {
            return this.getRootURL(isSpecific);
        }
        try {
            Template urlTemplate = this.getPageTemplate(isSpecific);
            urlTemplate.bind("title", pageTitle);
            return urlTemplate.createText();
        }
        catch (Exception e) {
            return this.getRootURL(isSpecific);
        }
    }

    String tryGetHelpPageTitleForRequest(HttpServletRequest request) {
        String helpPageTitle = request.getParameter("pageTitle");
        return helpPageTitle;
    }
}

