/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server;

import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ListSampleDisplayCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.server.AbstractOriginalDataProvider;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.id.metaproject.MetaprojectTechIdId;
import java.util.List;

final class ListSamplesOriginalDataProvider
extends AbstractOriginalDataProvider<Sample> {
    private final ListSampleDisplayCriteria criteria;

    ListSamplesOriginalDataProvider(ICommonServer commonServer, String sessionToken, ListSampleDisplayCriteria criteria) {
        super(commonServer, sessionToken);
        this.criteria = criteria;
    }

    @Override
    public final List<Sample> getFullOriginalData() {
        switch (this.criteria.getCriteriaKind()) {
            case BROWSE: {
                return this.commonServer.listSamples(this.sessionToken, this.criteria.getBrowseCriteria());
            }
            case SEARCH: {
                return this.commonServer.searchForSamples(this.sessionToken, this.criteria.getSearchCriteria());
            }
            case METAPROJECT: {
                this.commonServer.listMetaprojectSamples(this.sessionToken, new MetaprojectTechIdId(this.criteria.getMetaprojectCriteria().getMetaprojectId()));
            }
        }
        return null;
    }
}

