/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server.queue;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.common.mail.MailClient;
import ch.systemsx.cisd.common.mail.MailClientParameters;
import ch.systemsx.cisd.openbis.generic.client.web.server.queue.ConsumerTask;
import java.io.StringWriter;
import java.util.Date;
import java.util.Deque;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public final class ConsumerQueue {
    private final Deque<ConsumerTask> consumerQueue = new LinkedList<ConsumerTask>();
    private final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, ConsumerQueue.class);
    private final MailClientParameters mailClientParameters;

    public ConsumerQueue(MailClientParameters mailClientParameters) {
        Thread consumerThread = new Thread(){

            @Override
            public void run() {
                while (true) {
                    final ConsumerTask consumerTask = ConsumerQueue.this.getNextTask();
                    try {
                        if (consumerTask != null) {
                            Thread thread = new Thread(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 * Loose catch block
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                @Override
                                public void run() {
                                    boolean success = true;
                                    StringWriter writer = new StringWriter();
                                    Date startDate = new Date();
                                    consumerTask.doAction(writer);
                                    if (consumerTask == null) return;
                                    try {
                                        MailClient mailClient = new MailClient(ConsumerQueue.this.mailClientParameters);
                                        ConsumerQueue.this.sendEmail((IMailClient)mailClient, writer.toString(), ConsumerQueue.this.getSubject(consumerTask.getName(), startDate, success), new String[]{consumerTask.getUserEmail()});
                                        return;
                                    }
                                    catch (Throwable anyErrorOnMail) {
                                        ConsumerQueue.this.operationLog.error((Object)("Could not send email about asynchronous action '" + consumerTask.getName() + "' result. "), anyErrorOnMail);
                                    }
                                    return;
                                    catch (Throwable anyError) {
                                        try {
                                            ConsumerQueue.this.operationLog.error((Object)("Asynchronous action '" + consumerTask.getName() + "' failed. "), anyError);
                                            success = false;
                                            if (consumerTask == null) return;
                                        }
                                        catch (Throwable throwable) {
                                            if (consumerTask == null) throw throwable;
                                            try {
                                                MailClient mailClient = new MailClient(ConsumerQueue.this.mailClientParameters);
                                                ConsumerQueue.this.sendEmail((IMailClient)mailClient, writer.toString(), ConsumerQueue.this.getSubject(consumerTask.getName(), startDate, success), new String[]{consumerTask.getUserEmail()});
                                                throw throwable;
                                            }
                                            catch (Throwable anyErrorOnMail) {
                                                ConsumerQueue.this.operationLog.error((Object)("Could not send email about asynchronous action '" + consumerTask.getName() + "' result. "), anyErrorOnMail);
                                            }
                                            throw throwable;
                                        }
                                        try {
                                            MailClient mailClient = new MailClient(ConsumerQueue.this.mailClientParameters);
                                            ConsumerQueue.this.sendEmail((IMailClient)mailClient, writer.toString(), ConsumerQueue.this.getSubject(consumerTask.getName(), startDate, success), new String[]{consumerTask.getUserEmail()});
                                            return;
                                        }
                                        catch (Throwable anyErrorOnMail) {
                                            ConsumerQueue.this.operationLog.error((Object)("Could not send email about asynchronous action '" + consumerTask.getName() + "' result. "), anyErrorOnMail);
                                        }
                                        return;
                                    }
                                }
                            };
                            thread.start();
                            continue;
                        }
                        Thread.sleep(5000L);
                        continue;
                    }
                    catch (Throwable anyError) {
                        ConsumerQueue.this.operationLog.error((Object)("Asynchronous action '" + consumerTask.getName() + "' failed. "), anyError);
                        continue;
                    }
                    break;
                }
            }
        };
        consumerThread.start();
        this.mailClientParameters = mailClientParameters;
    }

    public final synchronized void addTaskAsLast(ConsumerTask task) {
        this.consumerQueue.addLast(task);
    }

    private final synchronized ConsumerTask getNextTask() {
        return this.consumerQueue.pollFirst();
    }

    private void sendEmail(IMailClient mailClient, String content, String subject, String ... recipient) {
        mailClient.sendMessage(subject, content, null, null, recipient);
    }

    private String getSubject(String actionName, Date startDate, boolean success) {
        return this.addDate(actionName + " " + (success ? "successfully performed" : "failed"), startDate);
    }

    private String addDate(String subject, Date startDate) {
        return subject + " (initiated at " + startDate + ")";
    }
}

