/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server.queue;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.client.web.server.UploadedFilesBean;
import java.io.IOException;
import java.io.Writer;

public abstract class ConsumerTask {
    private UploadedFilesBean filesForTask;

    public abstract String getName();

    public abstract String getUserEmail();

    public abstract void doActionOrThrowException(Writer var1);

    public ConsumerTask(UploadedFilesBean filesForTask) throws UserFailureException {
        this.filesForTask = filesForTask;
    }

    protected UploadedFilesBean getFilesForTask() {
        return this.filesForTask;
    }

    public boolean doAction(Writer messageWriter) {
        try {
            this.doActionOrThrowException(messageWriter);
        }
        catch (RuntimeException ex) {
            try {
                messageWriter.write(this.getName() + " has failed with a following exception: ");
                messageWriter.write(ex.getMessage());
                messageWriter.write("\n\nPlease correct the error or contact your administrator.");
            }
            catch (IOException writingEx) {
                throw new UserFailureException(writingEx.getMessage() + " when trying to throw exception: " + ex.getMessage(), (Throwable)ex);
            }
            throw ex;
        }
        finally {
            this.filesForTask.deleteTransferredFiles();
        }
        return true;
    }
}

