/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server.resultset;

import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.AbstractTableModelProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TypedTableModel;
import ch.systemsx.cisd.openbis.generic.shared.util.IColumnGroup;
import ch.systemsx.cisd.openbis.generic.shared.util.TypedTableModelBuilder;
import java.util.List;

public abstract class AbstractMaterialProvider
extends AbstractTableModelProvider<Material> {
    @Override
    protected TypedTableModel<Material> createTableModel() {
        List<Material> materials = this.getMaterials();
        TypedTableModelBuilder<Material> builder = new TypedTableModelBuilder<Material>();
        builder.addColumn("CODE");
        builder.addColumn("MATERIAL_TYPE").hideByDefault();
        builder.addColumn("REGISTRATOR");
        builder.addColumn("REGISTRATION_DATE").withDefaultWidth(200);
        builder.addColumn("MODIFICATION_DATE").withDefaultWidth(200).hideByDefault();
        builder.addColumn("METAPROJECTS");
        for (Material material : materials) {
            builder.addRow(material);
            builder.column("CODE").addEntityLink(material, material.getCode());
            MaterialType materialType = material.getMaterialType();
            builder.column("MATERIAL_TYPE").addString(materialType.getCode());
            builder.column("REGISTRATOR").addPerson(material.getRegistrator());
            builder.column("REGISTRATION_DATE").addDate(material.getRegistrationDate());
            builder.column("MODIFICATION_DATE").addDate(material.getModificationDate());
            builder.column("METAPROJECTS").addString(this.metaProjectsToString(material.getMetaprojects()));
            IColumnGroup columnGroup = builder.columnGroup("property-");
            columnGroup.addColumnsForAssignedProperties(materialType);
            columnGroup.addProperties(material.getProperties());
        }
        return builder.getModel();
    }

    protected abstract List<Material> getMaterials();
}

