/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server.resultset;

import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.ITableModelProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Metaproject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelColumnHeader;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TypedTableModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class AbstractTableModelProvider<T extends Serializable>
implements ITableModelProvider<T> {
    private TypedTableModel<T> tableModel = null;

    @Override
    public TypedTableModel<T> getTableModel(int maxSize) {
        if (this.tableModel == null) {
            this.tableModel = this.createTableModel();
        }
        List<TableModelColumnHeader> headers = this.tableModel.getHeader();
        List<TableModelRowWithObject<T>> rows = this.tableModel.getRows();
        ArrayList limitedRows = new ArrayList();
        for (TableModelRowWithObject<T> row : rows) {
            if (limitedRows.size() == maxSize) break;
            limitedRows.add(row);
        }
        return new TypedTableModel(headers, limitedRows);
    }

    protected abstract TypedTableModel<T> createTableModel();

    protected String metaProjectsToString(Collection<Metaproject> metaProjects) {
        String text = "";
        if (metaProjects != null) {
            ArrayList<String> names = new ArrayList<String>();
            for (Metaproject metaProject : metaProjects) {
                names.add(metaProject.getName());
            }
            Collections.sort(names, new Comparator<String>(){

                @Override
                public int compare(String arg0, String arg1) {
                    return arg0.toLowerCase().compareTo(arg1.toLowerCase());
                }
            });
            for (String name : names) {
                text = text + ", " + name;
            }
        }
        if (text.length() > 1) {
            text = text.substring(2);
        }
        return text;
    }
}

