/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server.resultset;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.security.TokenGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.IResultSetKeyGenerator;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CacheManager<K, T> {
    private final IResultSetKeyGenerator<K> keyProvider;
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, CacheManager.class);
    private final Map<K, T> results = new HashMap<K, T>();

    public CacheManager(IResultSetKeyGenerator<K> resultSetKeyProvider) {
        this.keyProvider = resultSetKeyProvider;
    }

    public static <T> CacheManager<String, T> createCacheManager() {
        return new CacheManager<String, T>(new TokenBasedResultSetKeyGenerator());
    }

    public final synchronized T tryGetData(K dataKey) {
        assert (dataKey != null) : "data key unsipecified";
        return this.results.get(dataKey);
    }

    public final synchronized K saveData(T data) {
        K dataKey = this.keyProvider.createKey();
        this.results.put(dataKey, data);
        return dataKey;
    }

    public final synchronized void removeData(K dataKey) {
        assert (dataKey != null) : "Unspecified data key holder.";
        if (this.results.remove(dataKey) != null) {
            operationLog.debug((Object)String.format("Result set for key '%s' has been removed.", dataKey));
        } else {
            operationLog.debug((Object)String.format("No result set for key '%s' could be found.", dataKey));
        }
    }

    public static final class TokenBasedResultSetKeyGenerator
    implements IResultSetKeyGenerator<String> {
        private static final long serialVersionUID = 1L;
        private final TokenGenerator tokenGenerator = new TokenGenerator();

        @Override
        public final String createKey() {
            return this.tokenGenerator.getNewToken(System.currentTimeMillis());
        }
    }
}

