/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server.resultset;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.collection.IKeyExtractor;
import ch.systemsx.cisd.common.collection.TableMap;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.shared.basic.string.AlternativesStringFilter;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.CustomFilterInfo;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.GridColumnFilterInfo;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.GridCustomColumnInfo;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.GridFilters;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.GridRowModels;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.IResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ResultSetFetchConfig;
import ch.systemsx.cisd.openbis.generic.client.web.server.calculator.GridExpressionUtils;
import ch.systemsx.cisd.openbis.generic.client.web.server.calculator.ITableDataProvider;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.ColumnSortUtils;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.DefaultResultSet;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.IColumnCalculator;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.ICustomColumnsProvider;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.IOriginalDataProvider;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.IResultSet;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.IResultSetKeyGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.IResultSetManager;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.TableData;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.TableDataCache;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.TableDataProviderFactory;
import ch.systemsx.cisd.openbis.generic.client.web.server.util.XMLPropertyTransformer;
import ch.systemsx.cisd.openbis.generic.shared.basic.GridRowModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.IColumnDefinition;
import ch.systemsx.cisd.openbis.generic.shared.basic.PrimitiveValue;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DateTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.GridCustomColumn;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SortInfo;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelColumnHeader;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TypedTableGridColumnDefinition;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public final class CachedResultSetManager<K>
implements IResultSetManager<K>,
Serializable {
    private static final long serialVersionUID = 1L;
    @Private
    static final int MAX_DISTINCT_COLUMN_VALUES_SIZE = 50;
    static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, CachedResultSetManager.class);
    private final IResultSetKeyGenerator<K> resultSetKeyProvider;
    private final ICustomColumnsProvider customColumnsProvider;
    private TableDataCache<K, Object> tableDataCache;
    private final Set<K> lockedResultSets = Collections.synchronizedSet(new HashSet());
    private final Set<K> resultSets = Collections.synchronizedSet(new HashSet());
    private final Map<K, IOriginalDataProvider<?>> cachedDataProviders = Collections.synchronizedMap(new HashMap());
    private final Map<K, Future<?>> unfinishedLoadings = Collections.synchronizedMap(new HashMap());
    private final XMLPropertyTransformer xmlPropertyTransformer = new XMLPropertyTransformer();
    private final IColumnCalculator columnCalculator;

    static final GridCustomColumnInfo translate(GridCustomColumn columnDefinition) {
        return new GridCustomColumnInfo(columnDefinition.getCode(), columnDefinition.getName(), columnDefinition.getDescription(), columnDefinition.getDataType());
    }

    static <T> String getOriginalValue(IColumnDefinition<T> definition, GridRowModel<T> row) {
        Comparable<?> value = definition.tryGetComparableValue(row);
        if (value != null && value instanceof DateTableCell) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date d = ((DateTableCell)value).getDateTime();
            return df.format(d);
        }
        return value == null ? "" : value.toString();
    }

    public CachedResultSetManager(TableDataCache<K, Object> tableDataCache, IResultSetKeyGenerator<K> resultSetKeyProvider, ICustomColumnsProvider customColumnsProvider) {
        this(tableDataCache, resultSetKeyProvider, customColumnsProvider, new IColumnCalculator(){

            @Override
            public <T> List<PrimitiveValue> evalCustomColumn(List<T> data, GridCustomColumn customColumn, Set<IColumnDefinition<T>> availableColumns, boolean errorMessagesAreLong) {
                return GridExpressionUtils.evalCustomColumn(TableDataProviderFactory.createDataProvider(data, new ArrayList<IColumnDefinition<T>>(availableColumns)), customColumn, errorMessagesAreLong);
            }
        });
    }

    CachedResultSetManager(TableDataCache<K, Object> tableDataCache, IResultSetKeyGenerator<K> resultSetKeyProvider, ICustomColumnsProvider customColumnsProvider, IColumnCalculator columnCalculator) {
        this.tableDataCache = tableDataCache;
        this.resultSetKeyProvider = resultSetKeyProvider;
        this.customColumnsProvider = customColumnsProvider;
        this.columnCalculator = columnCalculator;
    }

    private static final <T> T cast(Object object) {
        return (T)object;
    }

    private static final <T> GridRowModels<T> filterData(GridRowModels<T> rows, Set<IColumnDefinition<T>> availableColumns, GridFilters<T> filters) {
        List<GridColumnFilterInfo<T>> filterInfos;
        List<GridRowModel<Object>> filteredRows = rows;
        CustomFilterInfo<T> customFilterInfo = filters.tryGetCustomFilterInfo();
        if (customFilterInfo != null) {
            long time = System.currentTimeMillis();
            ITableDataProvider dataProvider = TableDataProviderFactory.createDataProvider(rows, new ArrayList<IColumnDefinition<T>>(availableColumns));
            List<Integer> indices = GridExpressionUtils.applyCustomFilter(dataProvider, customFilterInfo);
            filteredRows = new ArrayList();
            for (Integer index : indices) {
                filteredRows.add((GridRowModel)rows.get(index));
            }
            operationLog.info((Object)(System.currentTimeMillis() - time + "ms for filtering " + rows.size() + " rows with custom filter '" + customFilterInfo.getName() + "'."));
        }
        if ((filterInfos = filters.tryGetFilterInfos()) != null) {
            filteredRows = CachedResultSetManager.applyStandardColumnFilter(rows, filterInfos);
        }
        return rows.cloneWithData(filteredRows);
    }

    private static <T> List<GridRowModel<T>> applyStandardColumnFilter(GridRowModels<T> rows, List<GridColumnFilterInfo<T>> filterInfos) {
        ArrayList<GridRowModel<T>> filtered = new ArrayList<GridRowModel<T>>();
        List<FilterInfo<T>> appliedFilterInfos = CachedResultSetManager.processAppliedFilters(filterInfos);
        for (GridRowModel gridRowModel : rows) {
            if (!CachedResultSetManager.isMatching(gridRowModel, appliedFilterInfos)) continue;
            filtered.add(gridRowModel);
        }
        return filtered;
    }

    private static <T> List<FilterInfo<T>> processAppliedFilters(List<GridColumnFilterInfo<T>> filterInfos) {
        ArrayList<FilterInfo<T>> serverFilterInfos = new ArrayList<FilterInfo<T>>(filterInfos.size());
        for (GridColumnFilterInfo<T> filterInfo : filterInfos) {
            FilterInfo<T> info = FilterInfo.tryCreate(filterInfo);
            if (info == null) continue;
            serverFilterInfos.add(info);
        }
        return serverFilterInfos;
    }

    private static final <T> boolean isMatching(GridRowModel<T> row, List<FilterInfo<T>> serverFilterInfos) {
        for (FilterInfo<T> filter : serverFilterInfos) {
            if (filter.isMatching(row)) continue;
            return false;
        }
        return true;
    }

    private static <T> void sortData(GridRowModels<T> data, SortInfo sortInfo, Set<IColumnDefinition<T>> availableColumns) {
        assert (data != null) : "Unspecified data.";
        assert (sortInfo != null) : "Unspecified sort information.";
        if (data.size() == 0) {
            return;
        }
        SortInfo.SortDir sortDir = sortInfo.getSortDir();
        String sortField = sortInfo.getSortField();
        if (sortDir == SortInfo.SortDir.NONE || sortField == null) {
            return;
        }
        IColumnDefinition<T> sortFieldDefinition = null;
        for (IColumnDefinition<T> column : availableColumns) {
            if (!sortField.equals(column.getIdentifier())) continue;
            sortFieldDefinition = column;
            Comparator<GridRowModel<T>> comparator = ColumnSortUtils.createComparator(sortDir, sortFieldDefinition);
            Collections.sort(data, comparator);
            break;
        }
    }

    private static int getLimit(int size, int limit, int offset) {
        assert (size > -1) : "Size can not be negative";
        if (limit < 0) {
            return size - offset;
        }
        return Math.min(size - offset, limit);
    }

    private static int getOffset(int size, int offset) {
        assert (size > -1) : "Size can not be negative";
        if (size == 0) {
            return 0;
        }
        return Math.min(size - 1, Math.max(offset, 0));
    }

    private static final <T> GridRowModels<T> subList(GridRowModels<T> data, int offset, int limit) {
        int toIndex = offset + limit;
        return data.cloneWithData(data.subList(offset, toIndex));
    }

    @Override
    public final <T> IResultSet<K, T> getResultSet(String sessionToken, IResultSetConfig<K, T> resultConfig, IOriginalDataProvider<T> dataProvider) {
        IResultSet<K, T> cachedResultSet = this.getRawResultSet(sessionToken, resultConfig, dataProvider);
        return cachedResultSet;
    }

    private final <T> IResultSet<K, T> getRawResultSet(String sessionToken, IResultSetConfig<K, T> resultConfig, IOriginalDataProvider<T> dataProvider) {
        assert (resultConfig != null) : "Unspecified result configuration";
        assert (dataProvider != null) : "Unspecified data retriever";
        ResultSetFetchConfig<K> cacheConfig = resultConfig.getCacheConfig();
        ResultSetFetchConfig.ResultSetFetchMode mode = cacheConfig.getMode();
        operationLog.info((Object)("getResultSet(cache config = " + cacheConfig + ")"));
        K dataKey = cacheConfig.tryGetResultSetKey();
        switch (mode) {
            case RECOMPUTE_AND_CACHE: {
                return this.fetchAndCacheResultForSpecifiedKey(sessionToken, resultConfig, dataProvider, dataKey);
            }
            case CLEAR_COMPUTE_AND_CACHE: {
                this.removeResultSet(dataKey);
            }
            case COMPUTE_AND_CACHE: {
                return this.fetchAndCacheResultForSpecifiedKey(sessionToken, resultConfig, dataProvider, this.resultSetKeyProvider.createKey());
            }
        }
        TableData<K, T> tableData = this.tryGetCachedTableData(dataKey);
        if (tableData == null) {
            operationLog.warn((Object)("Reference to the stale cache key " + dataKey));
            tableData = CachedResultSetManager.loadAndAddToCache(dataKey, this.resolveDataProvider(dataKey, dataProvider), this.customColumnsProvider, this.columnCalculator, this.xmlPropertyTransformer, this);
        }
        return CachedResultSetManager.calculateSortAndFilterResult(sessionToken, tableData, resultConfig, dataKey, false);
    }

    private <T> IOriginalDataProvider<T> resolveDataProvider(K dataKey, IOriginalDataProvider<T> defaultDataProvider) {
        IOriginalDataProvider<?> cachedDataProvider = this.cachedDataProviders.get(dataKey);
        return cachedDataProvider == null ? defaultDataProvider : cachedDataProvider;
    }

    private <T> IResultSet<K, T> fetchAndCacheResultForSpecifiedKey(String sessionToken, IResultSetConfig<K, T> resultConfig, IOriginalDataProvider<T> dataProvider, K dataKey) {
        int limit = Integer.MAX_VALUE;
        operationLog.info((Object)("Retrieving " + limit + " record for a new key " + dataKey));
        List<T> rows = dataProvider.getOriginalData(limit);
        List<TableModelColumnHeader> headers = dataProvider.getHeaders();
        TableData<K, T> tableData = new TableData<K, T>(dataKey, rows, headers, this.customColumnsProvider, this.columnCalculator);
        this.xmlPropertyTransformer.transformXMLProperties(rows);
        this.cachedDataProviders.put(dataKey, dataProvider);
        this.addToCache(dataKey, tableData);
        boolean partial = rows.size() >= limit;
        return CachedResultSetManager.calculateSortAndFilterResult(sessionToken, tableData, this.createMatchingConfig(resultConfig, headers), dataKey, partial);
    }

    private <T> IResultSetConfig<K, T> createMatchingConfig(IResultSetConfig<K, T> resultSetConfig, List<TableModelColumnHeader> headers) {
        if (headers.isEmpty()) {
            return resultSetConfig;
        }
        if (this.hasNoStaleAvailableColumn(resultSetConfig, headers)) {
            return resultSetConfig;
        }
        HashSet newAvailableColumns = new HashSet();
        Set<String> idsOfPresentedColumns = resultSetConfig.getIDsOfPresentedColumns();
        HashSet<String> newIdsOfPresentedColumns = new HashSet<String>();
        SortInfo sortInfo = resultSetConfig.getSortInfo();
        TableMap<String, GridColumnFilterInfo<T>> columnFilterInfos = this.getColumFilters(resultSetConfig);
        ArrayList newColumnFilterInfos = new ArrayList();
        for (TableModelColumnHeader header : headers) {
            GridColumnFilterInfo filterInfo;
            String sortField;
            TypedTableGridColumnDefinition definition = new TypedTableGridColumnDefinition(header, null, "", null);
            newAvailableColumns.add(definition);
            String id = header.getId();
            if (!header.isHidden() || idsOfPresentedColumns.contains(id)) {
                newIdsOfPresentedColumns.add(id);
            }
            if (sortInfo != null && (sortField = sortInfo.getSortField()) != null && sortField.equals(id)) {
                sortInfo.setSortField(id);
            }
            if ((filterInfo = (GridColumnFilterInfo)columnFilterInfos.tryGet((Object)id)) == null) continue;
            String pattern = filterInfo.tryGetFilterPattern();
            newColumnFilterInfos.add(new GridColumnFilterInfo(definition, pattern));
        }
        for (String id : idsOfPresentedColumns) {
            if (!id.startsWith("$")) continue;
            newIdsOfPresentedColumns.add(id);
        }
        DefaultResultSetConfig newConfig = new DefaultResultSetConfig();
        newConfig.setAvailableColumns(newAvailableColumns);
        newConfig.setCacheConfig(resultSetConfig.getCacheConfig());
        newConfig.setCustomColumnErrorMessageLong(resultSetConfig.isCustomColumnErrorMessageLong());
        GridFilters newFilters = newColumnFilterInfos.isEmpty() ? GridFilters.createEmptyFilter() : GridFilters.createColumnFilter(newColumnFilterInfos);
        newConfig.setFilters(newFilters);
        newConfig.setGridDisplayId(resultSetConfig.tryGetGridDisplayId());
        newConfig.setIDsOfPresentedColumns(newIdsOfPresentedColumns);
        newConfig.setLimit(resultSetConfig.getLimit());
        newConfig.setOffset(resultSetConfig.getOffset());
        newConfig.setSortInfo(sortInfo);
        return newConfig;
    }

    private <T> TableMap<String, GridColumnFilterInfo<T>> getColumFilters(IResultSetConfig<K, T> resultSetConfig) {
        GridFilters<T> filters = resultSetConfig.getFilters();
        List<GridColumnFilterInfo<T>> filterInfosOrNull = filters.tryGetFilterInfos();
        if (filterInfosOrNull == null) {
            filterInfosOrNull = Collections.emptyList();
        }
        TableMap columnFilterInfos = new TableMap(filterInfosOrNull, new IKeyExtractor<String, GridColumnFilterInfo<T>>(){

            public String getKey(GridColumnFilterInfo<T> e) {
                return e.getFilteredField().getIdentifier();
            }
        });
        return columnFilterInfos;
    }

    private <T> boolean hasNoStaleAvailableColumn(IResultSetConfig<K, T> resultSetConfig, List<TableModelColumnHeader> headers) {
        HashSet<String> headerIds = new HashSet<String>();
        for (TableModelColumnHeader header : headers) {
            headerIds.add(header.getId());
        }
        Set<IColumnDefinition<T>> availableColumns = resultSetConfig.getAvailableColumns();
        if (availableColumns != null) {
            if (availableColumns.size() != headers.size()) {
                return false;
            }
            for (IColumnDefinition<T> definition : availableColumns) {
                if (headerIds.contains(definition.getIdentifier())) continue;
                return false;
            }
        }
        return true;
    }

    private <T> void addToCache(K dataKey, TableData<K, T> tableData) {
        this.unlockResultSet(dataKey);
        this.tableDataCache.putTableData(dataKey, tableData);
        this.resultSets.add(dataKey);
    }

    private static <K, T> IResultSet<K, T> calculateSortAndFilterResult(String sessionToken, TableData<K, T> tableData, IResultSetConfig<K, T> resultConfig, K dataKey, boolean partial) {
        GridRowModels<T> data = tableData.getRows(sessionToken, resultConfig);
        return CachedResultSetManager.filterLimitAndSort(resultConfig, data, dataKey, partial);
    }

    private <T> TableData<K, T> tryGetCachedTableData(K dataKey) {
        this.waitUntilAvailable(dataKey);
        TableData tableData = (TableData)CachedResultSetManager.cast(this.tableDataCache.getTableData(dataKey));
        if (tableData == null) {
            return null;
        }
        return tableData;
    }

    private void waitUntilAvailable(K dataKey) {
        this.waitUntilUnlocked(dataKey);
        Future<?> future = this.unfinishedLoadings.remove(dataKey);
        if (future != null) {
            try {
                operationLog.info((Object)("Wait for unfinished loading for key " + dataKey));
                future.get();
            }
            catch (InterruptedException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
            }
            catch (ExecutionException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary((Throwable)ex.getCause());
            }
        }
    }

    private static <K, T> IResultSet<K, T> filterLimitAndSort(IResultSetConfig<K, T> resultConfig, GridRowModels<T> data, K dataKey, boolean partial) {
        GridRowModels<T> filteredData = CachedResultSetManager.filterData(data, resultConfig.getAvailableColumns(), resultConfig.getFilters());
        int size = filteredData.size();
        int offset = CachedResultSetManager.getOffset(size, resultConfig.getOffset());
        int limit = CachedResultSetManager.getLimit(size, resultConfig.getLimit(), offset);
        SortInfo sortInfo = resultConfig.getSortInfo();
        CachedResultSetManager.sortData(filteredData, sortInfo, resultConfig.getAvailableColumns());
        GridRowModels<T> list = CachedResultSetManager.subList(filteredData, offset, limit);
        return new DefaultResultSet<K, T>(dataKey, list, size, partial);
    }

    private static <K, T> TableData<K, T> loadAndAddToCache(K dataKey, IOriginalDataProvider<T> dataProvider, ICustomColumnsProvider customColumnsProvider, IColumnCalculator columnCalculator, XMLPropertyTransformer xmlPropertyTransformer, CachedResultSetManager<K> cachedResultSetManager) {
        List<T> rows = dataProvider.getOriginalData(Integer.MAX_VALUE);
        List<TableModelColumnHeader> headers = dataProvider.getHeaders();
        operationLog.info((Object)(rows.size() + " records loaded for key " + dataKey));
        TableData<K, T> tableData = new TableData<K, T>(dataKey, rows, headers, customColumnsProvider, columnCalculator);
        xmlPropertyTransformer.transformXMLProperties(rows);
        super.addToCache(dataKey, tableData);
        return tableData;
    }

    protected void finalize() throws Throwable {
        this.removeAllResultSets();
    }

    public void removeAllResultSets() {
        for (K key : this.resultSets) {
            this.removeResultSet(key);
        }
    }

    @Override
    public final void removeResultSet(K resultSetKey) {
        this.unlockResultSet(resultSetKey);
        assert (resultSetKey != null) : "Unspecified data key holder.";
        this.resultSets.remove(resultSetKey);
        this.cachedDataProviders.remove(resultSetKey);
        if (this.tableDataCache.removeTableData(resultSetKey)) {
            operationLog.info((Object)String.format("Result set for key '%s' has been removed.", resultSetKey));
        }
    }

    @Override
    public void lockResultSet(K resultSetKey) {
        this.lockedResultSets.add(resultSetKey);
    }

    private void unlockResultSet(K resultSetKey) {
        this.lockedResultSets.remove(resultSetKey);
    }

    private void waitUntilUnlocked(K resultSetKey) {
        while (this.lockedResultSets.contains(resultSetKey)) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception ex) {
                operationLog.error((Object)("Interrupted while waiting on unlocking " + resultSetKey), (Throwable)ex);
            }
        }
    }

    private static class FilterInfo<T> {
        private final IColumnDefinition<T> filteredField;
        private final AlternativesStringFilter filter;

        private FilterInfo(GridColumnFilterInfo<T> gridFilterInfo) {
            this.filteredField = gridFilterInfo.getFilteredField();
            this.filter = this.createAlternativesFilter(gridFilterInfo);
        }

        private AlternativesStringFilter createAlternativesFilter(GridColumnFilterInfo<T> gridFilterInfo) {
            AlternativesStringFilter result = new AlternativesStringFilter();
            String pattern = gridFilterInfo.tryGetFilterPattern().toLowerCase();
            DataTypeCode dataType = gridFilterInfo.getFilteredField().tryToGetDataType();
            if (DataTypeCode.TIMESTAMP.equals((Object)dataType) || DataTypeCode.DATE.equals((Object)dataType)) {
                result.setDateFilterValue(pattern);
            } else {
                result.setFilterValue(pattern);
            }
            return result;
        }

        static <T> FilterInfo<T> tryCreate(GridColumnFilterInfo<T> filterInfo) {
            if (filterInfo.tryGetFilterPattern() == null) {
                return null;
            }
            return new FilterInfo<T>(filterInfo);
        }

        public boolean isMatching(GridRowModel<T> row) {
            IColumnDefinition<T> definition = this.filteredField;
            String value = CachedResultSetManager.getOriginalValue(definition, row).toLowerCase();
            return this.filter.passes(value);
        }
    }
}

