/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server.resultset;

import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.EntityTypeProvider;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.SimpleYesNoRenderer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.util.TypedTableModelBuilder;
import java.util.List;

public class DataSetTypeProvider
extends EntityTypeProvider<DataSetType> {
    public DataSetTypeProvider(ICommonServer commonServer, String sessionToken) {
        super(commonServer, sessionToken);
    }

    @Override
    protected List<DataSetType> listTypes() {
        return this.commonServer.listDataSetTypes(this.sessionToken);
    }

    @Override
    protected void addMoreColumns(TypedTableModelBuilder<DataSetType> builder) {
        builder.addColumn("DELETION_DISALLOW").hideByDefault();
        builder.addColumn("MAIN_DATA_SET_PATH").hideByDefault();
        builder.addColumn("MAIN_DATA_SET_PATTERN").hideByDefault();
    }

    @Override
    protected void addMoreCells(TypedTableModelBuilder<DataSetType> builder, DataSetType type) {
        builder.column("DELETION_DISALLOW").addString(SimpleYesNoRenderer.render(type.isDeletionDisallow()));
        builder.column("MAIN_DATA_SET_PATH").addString(type.getMainDataSetPath());
        builder.column("MAIN_DATA_SET_PATTERN").addString(type.getMainDataSetPattern());
    }
}

