/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server.resultset;

import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.AbstractCommonTableModelProvider;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.DeletionUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Deletion;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TypedTableModel;
import ch.systemsx.cisd.openbis.generic.shared.util.TypedTableModelBuilder;
import java.util.List;

public class DeletionsProvider
extends AbstractCommonTableModelProvider<Deletion> {
    public DeletionsProvider(ICommonServer commonServer, String sessionToken) {
        super(commonServer, sessionToken);
    }

    @Override
    protected TypedTableModel<Deletion> createTableModel() {
        List<Deletion> deletions = this.commonServer.listOriginalDeletions(this.sessionToken);
        TypedTableModelBuilder<Deletion> builder = new TypedTableModelBuilder<Deletion>();
        builder.addColumn("DELETION_DATE").withDefaultWidth(300);
        builder.addColumn("DELETER").withDefaultWidth(200);
        builder.addColumn("ENTITIES").withDefaultWidth(300);
        builder.addColumn("REASON").withDefaultWidth(500);
        for (Deletion deletion : deletions) {
            builder.addRow(deletion);
            builder.column("DELETION_DATE").addDate(deletion.getRegistrationDate());
            builder.column("DELETER").addPerson(deletion.getRegistrator());
            builder.column("REASON").addString(deletion.getReason());
            if (deletion.getDeletedEntities().isEmpty()) continue;
            builder.column("ENTITIES").addString(DeletionUtils.createDescriptionOfDeletedEntities(deletion));
        }
        return builder.getModel();
    }
}

