/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server.resultset;

import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ListEntityHistoryCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.AbstractCommonTableModelProvider;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityHistory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TypedTableModel;
import ch.systemsx.cisd.openbis.generic.shared.util.TypedTableModelBuilder;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class EntityHistoryProvider
extends AbstractCommonTableModelProvider<EntityHistory> {
    private final ListEntityHistoryCriteria criteria;

    public EntityHistoryProvider(ICommonServer commonServer, String sessionToken, ListEntityHistoryCriteria criteria) {
        super(commonServer, sessionToken);
        this.criteria = criteria;
    }

    @Override
    protected TypedTableModel<EntityHistory> createTableModel() {
        List<EntityHistory> history = this.commonServer.listEntityHistory(this.sessionToken, this.criteria.getEntityKind(), this.criteria.getEntityID());
        Collections.sort(history, new Comparator<EntityHistory>(){

            @Override
            public int compare(EntityHistory e1, EntityHistory e2) {
                long d2;
                long d1 = e1.getValidUntilDate().getTime();
                return d1 < (d2 = e2.getValidUntilDate().getTime()) ? 1 : (d1 > d2 ? -1 : 0);
            }
        });
        TypedTableModelBuilder<EntityHistory> builder = new TypedTableModelBuilder<EntityHistory>();
        builder.addColumn("PROPERTY_TYPE_CODE").hideByDefault();
        builder.addColumn("PROPERTY_TYPE_LABEL");
        builder.addColumn("RELATION_TYPE");
        builder.addColumn("VALUE").linkEntitiesOnly();
        builder.addColumn("AUTHOR");
        builder.addColumn("VALID_FROM_DATE");
        builder.addColumn("VALID_UNTIL_DATE");
        for (EntityHistory entry : history) {
            builder.addRow(entry);
            if (entry.getPropertyType() != null) {
                builder.column("PROPERTY_TYPE_CODE").addString(entry.getPropertyType().getCode());
                builder.column("PROPERTY_TYPE_LABEL").addString(entry.getPropertyType().getLabel());
            }
            builder.column("RELATION_TYPE").addString(entry.tryGetRelationType());
            String value = entry.getValue();
            if (value == null && (value = entry.getMaterial()) == null) {
                value = entry.getVocabularyTerm();
            }
            if (value == null && entry.tryGetRelatedProject() != null) {
                value = entry.tryGetRelatedProject().getIdentifier();
            }
            if (value == null && entry.tryGetRelatedEntity() != null) {
                builder.column("VALUE").addEntityLink(Collections.singleton(entry.tryGetRelatedEntity()));
            } else if (value == null) {
                builder.column("VALUE").addString(entry.tryGetRelatedEntityPermId());
            } else {
                builder.column("VALUE").addString(value);
            }
            builder.column("AUTHOR").addPerson(entry.getAuthor());
            builder.column("VALID_FROM_DATE").addDate(entry.getValidFromDate());
            builder.column("VALID_UNTIL_DATE").addDate(entry.getValidUntilDate());
        }
        return builder.getModel();
    }
}

