/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server.resultset;

import ch.ethz.sis.openbis.generic.asapi.v3.IApplicationServerApi;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.PropertyAssignment;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.EntityTypePropertyTypeProvider;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.PropertyTypeProvider;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.SemanticAnnotationProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.SimpleYesNoRenderer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewETNewPTAssigments;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewPTNewAssigment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Script;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TypedTableModel;
import ch.systemsx.cisd.openbis.generic.shared.util.TypedTableModelBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class EntityTypePropertyTypeBrowserProvider
extends EntityTypePropertyTypeProvider {
    private final List<NewPTNewAssigment> propertyTypesAsgs;

    public EntityTypePropertyTypeBrowserProvider(IApplicationServerApi applicationServerApi, String sessionToken, EntityType entity, List<NewPTNewAssigment> propertyTypesAsgs) {
        super(null, applicationServerApi, sessionToken, entity);
        this.propertyTypesAsgs = propertyTypesAsgs;
    }

    @Override
    protected TypedTableModel<EntityTypePropertyType<?>> createTableModel() {
        SemanticAnnotationProvider annotationProvider = new SemanticAnnotationProvider();
        TypedTableModelBuilder<EntityTypePropertyType> builder = new TypedTableModelBuilder<EntityTypePropertyType>();
        builder.addColumn("ORDINAL").withDefaultWidth(100);
        builder.addColumn("SECTION");
        builder.addColumn("PROPERTY_TYPE_CODE").withDefaultWidth(200);
        builder.addColumn("LABEL").hideByDefault();
        builder.addColumn("DESCRIPTION").hideByDefault();
        builder.addColumn("MODIFICATION_DATE").withDefaultWidth(300).hideByDefault();
        builder.addColumn("IS_MANDATORY");
        builder.addColumn("DATA_TYPE").withDefaultWidth(200);
        builder.addColumn("IS_DYNAMIC");
        builder.addColumn("IS_MANAGED");
        builder.addColumn("IS_SHOWN_IN_EDITOR_VIEW");
        builder.addColumn("SHOW_RAW_VALUE");
        builder.addColumn("SCRIPT");
        annotationProvider.addMoreColumns(builder, true);
        ArrayList etpts = new ArrayList();
        for (NewPTNewAssigment propertyTypeAsg : this.propertyTypesAsgs) {
            EntityTypePropertyType<?> entityTypePropertyType = NewETNewPTAssigments.getEntityTypePropertyType(this.entity, propertyTypeAsg);
            etpts.add(entityTypePropertyType);
        }
        Map<EntityTypePropertyType<?>, PropertyAssignment> assignmentsMap = this.createAssignmentsMap(etpts);
        for (EntityTypePropertyType entityTypePropertyType : etpts) {
            PropertyAssignment assignment;
            builder.addRow(entityTypePropertyType);
            PropertyType propertyType = entityTypePropertyType.getPropertyType();
            builder.column("ORDINAL").addInteger(entityTypePropertyType.getOrdinal());
            builder.column("SECTION").addString(entityTypePropertyType.getSection());
            builder.column("PROPERTY_TYPE_CODE").addString(propertyType.getCode());
            builder.column("LABEL").addString(propertyType.getLabel());
            builder.column("DESCRIPTION").addString(propertyType.getDescription());
            builder.column("MODIFICATION_DATE").addDate(propertyType.getModificationDate());
            builder.column("IS_MANDATORY").addString(SimpleYesNoRenderer.render(entityTypePropertyType.isMandatory()));
            builder.column("DATA_TYPE").addString(PropertyTypeProvider.renderDataType(propertyType));
            builder.column("IS_DYNAMIC").addString(SimpleYesNoRenderer.render(entityTypePropertyType.isDynamic()));
            builder.column("IS_MANAGED").addString(SimpleYesNoRenderer.render(entityTypePropertyType.isManaged()));
            builder.column("IS_SHOWN_IN_EDITOR_VIEW").addString(SimpleYesNoRenderer.render(entityTypePropertyType.isShownInEditView()));
            builder.column("SHOW_RAW_VALUE").addString(SimpleYesNoRenderer.render(entityTypePropertyType.getShowRawValue()));
            Script script = entityTypePropertyType.getScript();
            if (script != null) {
                builder.column("SCRIPT").addString(script.getName());
            }
            if ((assignment = assignmentsMap.get(entityTypePropertyType)) == null) continue;
            annotationProvider.addMoreCells(builder, assignment.getSemanticAnnotations(), assignment.isSemanticAnnotationsInherited());
        }
        return builder.getModel();
    }
}

