/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server.resultset;

import ch.ethz.sis.openbis.generic.asapi.v3.IApplicationServerApi;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.SearchResult;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.id.EntityTypePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.id.IEntityTypeId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.PropertyAssignment;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.fetchoptions.PropertyAssignmentFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.id.IPropertyTypeId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.id.PropertyAssignmentPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.id.PropertyTypePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.search.PropertyAssignmentSearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.entity.EntityKindConverter;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.AbstractCommonTableModelProvider;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.PropertyTypeProvider;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.SemanticAnnotationProvider;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.SimpleYesNoRenderer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Script;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TypedTableModel;
import ch.systemsx.cisd.openbis.generic.shared.util.TypedTableModelBuilder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.ReferenceIdentityMap;

public class EntityTypePropertyTypeProvider
extends AbstractCommonTableModelProvider<EntityTypePropertyType<?>> {
    private IApplicationServerApi applicationServerApi;
    protected final EntityType entity;

    public EntityTypePropertyTypeProvider(ICommonServer commonServer, IApplicationServerApi applicationServerApi, String sessionToken, EntityType entity) {
        super(commonServer, sessionToken);
        this.applicationServerApi = applicationServerApi;
        this.entity = entity;
    }

    @Override
    protected TypedTableModel<EntityTypePropertyType<?>> createTableModel() {
        List<EntityTypePropertyType<?>> etpts = this.commonServer.listEntityTypePropertyTypes(this.sessionToken);
        Map<EntityTypePropertyType<?>, PropertyAssignment> assignmentsMap = this.createAssignmentsMap(etpts);
        SemanticAnnotationProvider annotationProvider = new SemanticAnnotationProvider();
        TypedTableModelBuilder builder = new TypedTableModelBuilder();
        builder.addColumn("ORDINAL").withDefaultWidth(100);
        builder.addColumn("SECTION");
        builder.addColumn("PROPERTY_TYPE_CODE").withDefaultWidth(200);
        builder.addColumn("LABEL").hideByDefault();
        builder.addColumn("DESCRIPTION").hideByDefault();
        builder.addColumn("MODIFICATION_DATE").withDefaultWidth(300).hideByDefault();
        if (this.entity == null) {
            builder.addColumn("ASSIGNED_TO").withDefaultWidth(200);
            builder.addColumn("TYPE_OF");
        }
        builder.addColumn("IS_MANDATORY");
        builder.addColumn("DATA_TYPE").withDefaultWidth(200);
        builder.addColumn("IS_DYNAMIC");
        builder.addColumn("IS_MANAGED");
        builder.addColumn("IS_SHOWN_IN_EDITOR_VIEW");
        builder.addColumn("SHOW_RAW_VALUE");
        builder.addColumn("SCRIPT");
        annotationProvider.addMoreColumns(builder, true);
        for (EntityTypePropertyType<?> etpt : etpts) {
            PropertyAssignment assignment;
            if (this.entity != null && !this.entity.equals(etpt.getEntityType())) continue;
            builder.addRow(etpt);
            PropertyType propertyType = etpt.getPropertyType();
            builder.column("ORDINAL").addInteger(etpt.getOrdinal());
            builder.column("SECTION").addString(etpt.getSection());
            builder.column("PROPERTY_TYPE_CODE").addString(propertyType.getCode());
            builder.column("LABEL").addString(propertyType.getLabel());
            builder.column("DESCRIPTION").addString(propertyType.getDescription());
            builder.column("MODIFICATION_DATE").addDate(propertyType.getModificationDate());
            if (this.entity == null) {
                builder.column("ASSIGNED_TO").addString(etpt.getEntityType().getCode());
                builder.column("TYPE_OF").addString(etpt.getEntityKind().getDescription());
            }
            builder.column("IS_MANDATORY").addString(SimpleYesNoRenderer.render(etpt.isMandatory()));
            builder.column("DATA_TYPE").addString(PropertyTypeProvider.renderDataType(propertyType));
            builder.column("IS_DYNAMIC").addString(SimpleYesNoRenderer.render(etpt.isDynamic()));
            builder.column("IS_MANAGED").addString(SimpleYesNoRenderer.render(etpt.isManaged()));
            builder.column("IS_SHOWN_IN_EDITOR_VIEW").addString(SimpleYesNoRenderer.render(etpt.isShownInEditView()));
            builder.column("SHOW_RAW_VALUE").addString(SimpleYesNoRenderer.render(etpt.getShowRawValue()));
            Script script = etpt.getScript();
            if (script != null) {
                builder.column("SCRIPT").addString(script.getName());
            }
            if ((assignment = assignmentsMap.get(etpt)) == null) continue;
            annotationProvider.addMoreCells(builder, assignment.getSemanticAnnotations(), assignment.isSemanticAnnotationsInherited());
        }
        return builder.getModel();
    }

    protected Map<EntityTypePropertyType<?>, PropertyAssignment> createAssignmentsMap(Collection<EntityTypePropertyType<?>> etpts) {
        HashMap idToEtptMap = new HashMap();
        for (EntityTypePropertyType<?> etpt : etpts) {
            EntityTypePermId entityTypeId = new EntityTypePermId(etpt.getEntityType().getCode(), EntityKindConverter.convert(etpt.getEntityKind()));
            PropertyTypePermId propertyTypeId = new PropertyTypePermId(etpt.getPropertyType().getCode());
            idToEtptMap.put(new PropertyAssignmentPermId((IEntityTypeId)entityTypeId, (IPropertyTypeId)propertyTypeId), etpt);
        }
        PropertyAssignmentSearchCriteria criteria = new PropertyAssignmentSearchCriteria();
        criteria.withIds().thatIn(idToEtptMap.keySet());
        PropertyAssignmentFetchOptions fo = new PropertyAssignmentFetchOptions();
        fo.withSemanticAnnotations();
        SearchResult result = this.applicationServerApi.searchPropertyAssignments(this.sessionToken, criteria, fo);
        ReferenceIdentityMap map = new ReferenceIdentityMap();
        for (PropertyAssignment assignment : result.getObjects()) {
            EntityTypePropertyType etpt = (EntityTypePropertyType)idToEtptMap.get(assignment.getPermId());
            map.put(etpt, assignment);
        }
        return map;
    }
}

