/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server.resultset;

import ch.systemsx.cisd.common.collection.SimpleComparator;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.ITableModelProvider;
import ch.systemsx.cisd.openbis.generic.client.web.server.translator.SearchableEntityTranslator;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.WebClientConfigurationProvider;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchDomain;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchDomainSearchOption;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MatchingEntity;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyMatch;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SearchDomainSearchResultWithFullEntity;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Span;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TypedTableModel;
import ch.systemsx.cisd.openbis.generic.shared.dto.SearchableEntity;
import ch.systemsx.cisd.openbis.generic.shared.util.TypedTableModelBuilder;
import ch.systemsx.cisd.openbis.generic.shared.util.WebClientConfigUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class MatchingEntitiesProvider
implements ITableModelProvider<MatchingEntity> {
    private final ICommonServer commonServer;
    private final String sessionToken;
    private final SearchableEntity[] matchingEntities;
    private final SearchDomain[] matchingSearchDomains;
    private String queryText;
    private final boolean useWildcardSearchMode;
    private final WebClientConfigurationProvider webClientConfigurationProvider;

    public MatchingEntitiesProvider(ICommonServer commonServer, String sessionToken, SearchableEntity[] matchingEntities, SearchDomain[] matchingSearchDomains, String queryText, boolean useWildcardSearchMode, WebClientConfigurationProvider webClientConfigurationProvider) {
        this.commonServer = commonServer;
        this.sessionToken = sessionToken;
        this.matchingEntities = matchingEntities;
        this.matchingSearchDomains = matchingSearchDomains;
        this.queryText = queryText;
        this.useWildcardSearchMode = useWildcardSearchMode;
        this.webClientConfigurationProvider = webClientConfigurationProvider;
    }

    @Override
    public TypedTableModel<MatchingEntity> getTableModel(int maxSize) {
        List<MatchingEntity> entities = this.commonServer.listMatchingEntities(this.sessionToken, this.matchingEntities, this.queryText, this.useWildcardSearchMode, Integer.MAX_VALUE);
        for (SearchDomain searchDomain : this.matchingSearchDomains) {
            String preferredSearchDomainOrNull = searchDomain.getName();
            HashMap<String, String> parameters = this.createParameters(searchDomain);
            List<SearchDomainSearchResultWithFullEntity> searchDomainSearchResults = this.commonServer.searchOnSearchDomain(this.sessionToken, preferredSearchDomainOrNull, this.queryText, parameters);
            List<MatchingEntity> matchingSearchDomainsTranslatedToEntities = SearchableEntityTranslator.translateSearchDomains(searchDomainSearchResults, this.queryText);
            entities.addAll(matchingSearchDomainsTranslatedToEntities);
        }
        TypedTableModelBuilder<MatchingEntity> builder = new TypedTableModelBuilder<MatchingEntity>();
        builder.addColumn("ENTITY_KIND");
        builder.addColumn("ENTITY_TYPE");
        builder.addColumn("SEARCH_DOMAIN_TYPE");
        builder.addColumn("IDENTIFIER").withDefaultWidth(140);
        builder.addColumn("REGISTRATOR");
        builder.addColumn("MATCH").withDefaultWidth(200).withDataType(DataTypeCode.MULTILINE_VARCHAR);
        builder.addColumn("RANK");
        long rank = 1L;
        for (MatchingEntity matchingEntity : entities) {
            builder.addRow(matchingEntity);
            builder.column("ENTITY_KIND").addString(WebClientConfigUtils.getTranslatedDescription(this.webClientConfigurationProvider, matchingEntity.getEntityKind()));
            builder.column("ENTITY_TYPE").addString(matchingEntity.getEntityType().getCode());
            builder.column("SEARCH_DOMAIN_TYPE").addString(matchingEntity.getSearchDomain());
            builder.column("IDENTIFIER").addString(matchingEntity.getIdentifier());
            builder.column("REGISTRATOR").addPerson(matchingEntity.getRegistrator());
            builder.column("MATCH").addMatch(this.addHighLights(matchingEntity));
            builder.column("RANK").addInteger(rank);
            ++rank;
        }
        return builder.getModel();
    }

    private HashMap<String, String> createParameters(SearchDomain searchDomain) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        String key = searchDomain.getPossibleSearchOptionsKey();
        List options = searchDomain.getPossibleSearchOptions();
        if (key != null && options.size() > 1) {
            parameters.put(key, ((SearchDomainSearchOption)options.get(this.useWildcardSearchMode ? 1 : 0)).getCode());
        }
        return parameters;
    }

    private MatchingEntity addHighLights(MatchingEntity entity) {
        List<PropertyMatch> matches = entity.getMatches();
        Collections.sort(matches, new SimpleComparator<PropertyMatch, String>(){

            public String evaluate(PropertyMatch item) {
                return item.getCode() + ": " + item.getValue();
            }
        });
        for (PropertyMatch match : matches) {
            String rawValue = match.getValue();
            String highlighted = "";
            for (Block block : this.getBlocks(match.getSpans())) {
                if (rawValue.length() == 0) break;
                if (block.isHighlighted()) {
                    highlighted = highlighted + "|||startHighlight|||";
                }
                highlighted = highlighted + rawValue.substring(0, Math.min(block.getLength(), rawValue.length()));
                if (block.isHighlighted()) {
                    highlighted = highlighted + "|||endHighlight|||";
                }
                rawValue = rawValue.substring(Math.min(block.getLength(), rawValue.length()));
            }
            match.setValue(highlighted);
        }
        return entity;
    }

    private List<Block> getBlocks(List<Span> input) {
        ArrayList spans = input == null ? new ArrayList() : new ArrayList<Span>(input);
        Collections.sort(spans, new Comparator<Span>(){

            @Override
            public int compare(Span s1, Span s2) {
                return new Integer(s1.getStart()).compareTo(new Integer(s2.getStart()));
            }
        });
        ArrayList<Span> result = new ArrayList<Span>();
        for (Span span : spans) {
            if (result.isEmpty()) {
                result.add(span);
                continue;
            }
            Span last = (Span)result.get(result.size() - 1);
            if (this.overlap(last, span)) {
                if (span.getEnd() <= last.getEnd()) continue;
                last.setEnd(span.getEnd());
                continue;
            }
            result.add(span);
        }
        ArrayList<Block> blocks = new ArrayList<Block>();
        int lastEnd = 0;
        for (Span span : result) {
            if (span.getStart() - lastEnd > 0) {
                blocks.add(new Block(false, span.getStart() - lastEnd));
            }
            blocks.add(new Block(true, span.getEnd() - span.getStart()));
            lastEnd = span.getEnd();
        }
        blocks.add(new Block(false, Integer.MAX_VALUE));
        return blocks;
    }

    private boolean overlap(Span s1, Span s2) {
        return s1.getEnd() >= s2.getStart();
    }

    private class Block {
        private boolean highlighted;
        private int length;

        public Block(boolean highlighted, int length) {
            this.highlighted = highlighted;
            this.length = length;
        }

        public boolean isHighlighted() {
            return this.highlighted;
        }

        public int getLength() {
            return this.length;
        }
    }
}

