/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server.resultset;

import ch.ethz.sis.openbis.generic.asapi.v3.IApplicationServerApi;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.SearchResult;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.PropertyType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.fetchoptions.PropertyTypeFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.search.PropertyTypeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.semanticannotation.SemanticAnnotation;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.AbstractCommonTableModelProvider;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.SemanticAnnotationProvider;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TypedTableModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary;
import ch.systemsx.cisd.openbis.generic.shared.util.TypedTableModelBuilder;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class PropertyTypeProvider
extends AbstractCommonTableModelProvider<ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType> {
    private IApplicationServerApi applicationServerApi;

    public PropertyTypeProvider(ICommonServer commonServer, IApplicationServerApi applicationServerApi, String sessionToken) {
        super(commonServer, sessionToken);
        this.applicationServerApi = applicationServerApi;
    }

    @Override
    protected TypedTableModel<ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType> createTableModel() {
        List<ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType> propertyTypes = this.commonServer.listPropertyTypes(this.sessionToken, true);
        Map<String, List<SemanticAnnotation>> annotationsMap = this.createAnnotationsMap(propertyTypes);
        SemanticAnnotationProvider annotationProvider = new SemanticAnnotationProvider();
        TypedTableModelBuilder<ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType> builder = new TypedTableModelBuilder<ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType>();
        builder.addColumn("LABEL");
        builder.addColumn("CODE");
        builder.addColumn("DATA_TYPE").withDefaultWidth(200);
        builder.addColumn("DATA_TYPE_CODE").hideByDefault();
        builder.addColumn("VOCABULARY").hideByDefault();
        builder.addColumn("MATERIAL_TYPE").hideByDefault();
        builder.addColumn("XML_SCHEMA").hideByDefault();
        builder.addColumn("XSLT").hideByDefault();
        builder.addColumn("DESCRIPTION");
        builder.addColumn("MODIFICATION_DATE").withDefaultWidth(300).hideByDefault();
        builder.addColumn("SAMPLE_TYPES");
        builder.addColumn("EXPERIMENT_TYPES");
        builder.addColumn("MATERIAL_TYPES");
        builder.addColumn("DATA_SET_TYPES");
        annotationProvider.addMoreColumns(builder, false);
        for (ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType propertyType : propertyTypes) {
            builder.addRow(propertyType);
            builder.column("LABEL").addString(propertyType.getLabel());
            builder.column("CODE").addString(propertyType.getCode());
            builder.column("DATA_TYPE").addString(PropertyTypeProvider.renderDataType(propertyType));
            builder.column("DATA_TYPE_CODE").addString(propertyType.getDataType().getCode().name());
            Vocabulary vocabulary = propertyType.getVocabulary();
            builder.column("VOCABULARY").addString(vocabulary != null ? vocabulary.getCode() : null);
            MaterialType materialType = propertyType.getMaterialType();
            builder.column("MATERIAL_TYPE").addString(materialType != null ? materialType.getCode() : null);
            builder.column("XML_SCHEMA").addString(propertyType.getSchema());
            builder.column("XSLT").addString(propertyType.getTransformation());
            builder.column("DESCRIPTION").addString(propertyType.getDescription());
            builder.column("MODIFICATION_DATE").addDate(propertyType.getModificationDate());
            builder.column("SAMPLE_TYPES").addString(PropertyTypeProvider.render(propertyType.getSampleTypePropertyTypes()));
            builder.column("EXPERIMENT_TYPES").addString(PropertyTypeProvider.render(propertyType.getExperimentTypePropertyTypes()));
            builder.column("MATERIAL_TYPES").addString(PropertyTypeProvider.render(propertyType.getMaterialTypePropertyTypes()));
            builder.column("DATA_SET_TYPES").addString(PropertyTypeProvider.render(propertyType.getDataSetTypePropertyTypes()));
            List<SemanticAnnotation> annotations = annotationsMap.get(propertyType.getCode());
            annotationProvider.addMoreCells(builder, annotations, null);
        }
        return builder.getModel();
    }

    private static String render(List<? extends EntityTypePropertyType<?>> list) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (EntityTypePropertyType<?> etpt : list) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(PropertyTypeProvider.render(etpt));
        }
        return sb.toString();
    }

    private static String render(EntityTypePropertyType<?> etpt) {
        StringBuilder sb = new StringBuilder();
        sb.append(etpt.getEntityType().getCode());
        if (etpt.isMandatory()) {
            sb.append(" *");
        }
        return sb.toString();
    }

    static String renderDataType(ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType entity) {
        DataTypeCode dataType = entity.getDataType().getCode();
        switch (dataType) {
            case BOOLEAN: {
                return "True / False";
            }
            case CONTROLLEDVOCABULARY: {
                return "Vocabulary: " + PropertyTypeProvider.tryGetVocabularyCode(entity);
            }
            case INTEGER: {
                return "Integer Number";
            }
            case MATERIAL: {
                String materialTypeCode = PropertyTypeProvider.tryGetMaterialTypeCode(entity);
                if (materialTypeCode == null) {
                    return "Material of Any Type";
                }
                return "Material of Type: " + materialTypeCode;
            }
            case SAMPLE: {
                String sampleTypeCode = PropertyTypeProvider.tryGetSampleTypeCode(entity);
                return sampleTypeCode == null ? "Sample of Any Type" : "Sample of Type: " + sampleTypeCode;
            }
            case REAL: {
                return "Float Number";
            }
            case DATE: {
                return "Date";
            }
            case TIMESTAMP: {
                return "Date and Time";
            }
            case VARCHAR: {
                return "Text";
            }
        }
        return dataType.name();
    }

    private static String tryGetVocabularyCode(ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType entity) {
        Vocabulary vocabulary = entity.getVocabulary();
        return vocabulary != null ? vocabulary.getCode() : null;
    }

    private static String tryGetMaterialTypeCode(ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType entity) {
        MaterialType materialType = entity.getMaterialType();
        return materialType != null ? materialType.getCode() : null;
    }

    private static String tryGetSampleTypeCode(ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType entity) {
        SampleType sampleType = entity.getSampleType();
        return sampleType != null ? sampleType.getCode() : null;
    }

    private Map<String, List<SemanticAnnotation>> createAnnotationsMap(Collection<ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType> propertyTypes) {
        HashSet<String> codes = new HashSet<String>();
        for (ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType propertyType : propertyTypes) {
            codes.add(propertyType.getCode());
        }
        PropertyTypeSearchCriteria criteria = new PropertyTypeSearchCriteria();
        criteria.withCodes().thatIn(codes);
        PropertyTypeFetchOptions fo = new PropertyTypeFetchOptions();
        fo.withSemanticAnnotations();
        SearchResult result = this.applicationServerApi.searchPropertyTypes(this.sessionToken, criteria, fo);
        HashMap<String, List<SemanticAnnotation>> map = new HashMap<String, List<SemanticAnnotation>>();
        for (PropertyType propertyType : result.getObjects()) {
            map.put(propertyType.getCode(), propertyType.getSemanticAnnotations());
        }
        return map;
    }
}

