/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server.resultset;

import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.AbstractCommonTableModelProvider;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.authorization.IAuthorizationConfig;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AuthorizationGroup;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Person;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleAssignment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TypedTableModel;
import ch.systemsx.cisd.openbis.generic.shared.util.TypedTableModelBuilder;
import java.util.List;

public class RoleAssignmentProvider
extends AbstractCommonTableModelProvider<RoleAssignment> {
    private IAuthorizationConfig authorizationConfig;

    public RoleAssignmentProvider(ICommonServer commonServer, IAuthorizationConfig authorizationConfig, String sessionToken) {
        super(commonServer, sessionToken);
        this.authorizationConfig = authorizationConfig;
    }

    @Override
    protected TypedTableModel<RoleAssignment> createTableModel() {
        List<RoleAssignment> roles = this.commonServer.listRoleAssignments(this.sessionToken);
        TypedTableModelBuilder<RoleAssignment> builder = new TypedTableModelBuilder<RoleAssignment>();
        builder.addColumn("PERSON");
        builder.addColumn("AUTHORIZATION_GROUP");
        builder.addColumn("SPACE");
        if (this.authorizationConfig.isProjectLevelEnabled()) {
            builder.addColumn("PROJECT");
        }
        builder.addColumn("ROLE");
        for (RoleAssignment roleAssignment : roles) {
            if (roleAssignment.getProject() != null && !this.authorizationConfig.isProjectLevelEnabled()) continue;
            builder.addRow(roleAssignment);
            Person person = roleAssignment.getPerson();
            AuthorizationGroup group = roleAssignment.getAuthorizationGroup();
            Space space = roleAssignment.getSpace();
            Project project = roleAssignment.getProject();
            builder.column("PERSON").addString(person == null ? "" : person.getUserId());
            builder.column("AUTHORIZATION_GROUP").addString(group == null ? "" : group.getCode());
            builder.column("SPACE").addString(space == null ? "" : space.getCode());
            if (this.authorizationConfig.isProjectLevelEnabled()) {
                builder.column("PROJECT").addString(project == null ? "" : project.getIdentifier());
            }
            builder.column("ROLE").addString(roleAssignment.getCode());
        }
        return builder.getModel();
    }
}

