/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server.resultset;

import ch.systemsx.cisd.common.collection.IKeyExtractor;
import ch.systemsx.cisd.common.collection.TableMap;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ListSampleDisplayCriteria2;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.AbstractCommonTableModelProvider;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.DeletionUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.SimpleYesNoRenderer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TypedTableModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.id.metaproject.MetaprojectTechIdId;
import ch.systemsx.cisd.openbis.generic.shared.util.IColumnGroup;
import ch.systemsx.cisd.openbis.generic.shared.util.TypedTableModelBuilder;
import java.util.List;

public class SampleProvider
extends AbstractCommonTableModelProvider<Sample> {
    private final ListSampleDisplayCriteria2 criteria;

    public SampleProvider(ICommonServer commonServer, String sessionToken, ListSampleDisplayCriteria2 criteria) {
        super(commonServer, sessionToken);
        this.criteria = criteria;
    }

    @Override
    protected TypedTableModel<Sample> createTableModel() {
        List<Sample> samples = this.getSamples();
        TypedTableModelBuilder<Sample> builder = new TypedTableModelBuilder<Sample>();
        builder.addColumn("CODE");
        builder.addColumn("SUBCODE").hideByDefault();
        builder.addColumn("SPACE").hideByDefault();
        builder.addColumn("SAMPLE_IDENTIFIER").withDefaultWidth(150).hideByDefault();
        builder.addColumn("SAMPLE_TYPE").withDefaultWidth(150).hideByDefault();
        builder.addColumn("IS_INSTANCE_SAMPLE").hideByDefault();
        builder.addColumn("IS_DELETED").hideByDefault();
        builder.addColumn("REGISTRATOR").withDefaultWidth(200);
        builder.addColumn("MODIFIER").withDefaultWidth(200);
        builder.addColumn("REGISTRATION_DATE").withDefaultWidth(300).hideByDefault();
        builder.addColumn("MODIFICATION_DATE").withDefaultWidth(300).hideByDefault();
        builder.addColumn("EXPERIMENT");
        builder.addColumn("EXPERIMENT_IDENTIFIER").withDefaultWidth(200).hideByDefault();
        builder.addColumn("PROJECT");
        builder.addColumn("PROJECT_IDENTIFIER");
        builder.addColumn("PERM_ID").hideByDefault();
        builder.addColumn("SHOW_DETAILS_LINK").hideByDefault();
        builder.addColumn("generatedFromParent");
        builder.addColumn("containerParent");
        builder.addColumn("METAPROJECTS");
        TableMap<String, SampleType> sampleTypes = this.getSampleTypes();
        for (Sample sample : samples) {
            builder.addRow(sample);
            if (sample.isStub()) {
                builder.column("PERM_ID").addString(sample.getPermId());
                builder.column("METAPROJECTS").addString(this.metaProjectsToString(sample.getMetaprojects()));
                continue;
            }
            builder.column("CODE").addEntityLink(sample, sample.getCode());
            builder.column("SUBCODE").addEntityLink(sample, sample.getSubCode());
            builder.column("SPACE").addString(sample.getSpace() == null ? "" : sample.getSpace().getCode());
            builder.column("SAMPLE_IDENTIFIER").addEntityLink(sample, sample.getIdentifier());
            builder.column("SAMPLE_TYPE").addString(sample.getSampleType().getCode());
            builder.column("IS_INSTANCE_SAMPLE").addString(SimpleYesNoRenderer.render(sample.getSpace() == null));
            builder.column("IS_DELETED").addString(SimpleYesNoRenderer.render(DeletionUtils.isDeleted(sample)));
            builder.column("REGISTRATOR").addPerson(sample.getRegistrator());
            builder.column("MODIFIER").addPerson(sample.getModifier());
            builder.column("REGISTRATION_DATE").addDate(sample.getRegistrationDate());
            builder.column("MODIFICATION_DATE").addDate(sample.getModificationDate());
            builder.column("METAPROJECTS").addString(this.metaProjectsToString(sample.getMetaprojects()));
            Experiment experimentOrNull = sample.getExperiment();
            if (experimentOrNull != null) {
                Experiment experiment = experimentOrNull;
                builder.column("EXPERIMENT").addEntityLink(experiment, experiment.getCode());
                builder.column("EXPERIMENT_IDENTIFIER").addEntityLink(experiment, experiment.getIdentifier());
            }
            this.addProject(builder, sample);
            builder.column("PERM_ID").addString(sample.getPermId());
            builder.column("SHOW_DETAILS_LINK").addString(sample.getPermlink());
            builder.column("generatedFromParent").addEntityLink(sample.getParents());
            Sample containerOrNull = sample.getContainer();
            if (containerOrNull != null) {
                Sample container = containerOrNull;
                builder.column("containerParent").addEntityLink(container, container.getIdentifier());
            }
            SampleType sampleType = (SampleType)sampleTypes.tryGet((Object)sample.getSampleType().getCode());
            IColumnGroup columnGroup = builder.columnGroup("property-");
            if (sampleType != null) {
                columnGroup.addColumnsForAssignedProperties(sampleType);
            }
            columnGroup.addProperties(sample.getProperties());
        }
        return builder.getModel();
    }

    protected TableMap<String, SampleType> getSampleTypes() {
        List<SampleType> sampleTypes = this.commonServer.listSampleTypes(this.sessionToken);
        TableMap sampleTypMap = new TableMap(sampleTypes, (IKeyExtractor)new IKeyExtractor<String, SampleType>(){

            public String getKey(SampleType e) {
                return e.getCode();
            }
        });
        return sampleTypMap;
    }

    private void addProject(TypedTableModelBuilder<Sample> builder, Sample sample) {
        Experiment experiment;
        Project project = sample.getProject();
        if (project == null && (experiment = sample.getExperiment()) != null) {
            project = experiment.getProject();
        }
        if (project != null) {
            builder.column("PROJECT").addString(project.getCode());
            builder.column("PROJECT_IDENTIFIER").addString(project.getIdentifier());
        }
    }

    private final List<Sample> getSamples() {
        switch (this.criteria.getCriteriaKind()) {
            case BROWSE: {
                return this.commonServer.listSamples(this.sessionToken, this.criteria.getBrowseCriteria());
            }
            case SEARCH: {
                return this.commonServer.searchForSamples(this.sessionToken, this.criteria.getSearchCriteria());
            }
            case METAPROJECT: {
                return this.commonServer.listMetaprojectSamples(this.sessionToken, new MetaprojectTechIdId(this.criteria.getMetaprojectCriteria().getMetaprojectId()));
            }
        }
        return null;
    }
}

