/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server.resultset;

import ch.ethz.sis.openbis.generic.asapi.v3.IApplicationServerApi;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.SearchResult;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.SampleType;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.fetchoptions.SampleTypeFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.search.SampleTypeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.semanticannotation.SemanticAnnotation;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.EntityTypeProvider;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.SemanticAnnotationProvider;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.SimpleYesNoRenderer;
import ch.systemsx.cisd.openbis.generic.shared.util.TypedTableModelBuilder;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class SampleTypeProvider
extends EntityTypeProvider<ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType> {
    private IApplicationServerApi applicationServerApi;
    private Map<String, List<SemanticAnnotation>> annotationsMap;

    public SampleTypeProvider(ICommonServer commonServer, IApplicationServerApi applicationServerApi, String sessionToken) {
        super(commonServer, sessionToken);
        this.applicationServerApi = applicationServerApi;
    }

    @Override
    protected List<ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType> listTypes() {
        List<ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType> sampleTypes = this.commonServer.listSampleTypes(this.sessionToken);
        this.annotationsMap = this.createAnnotationsMap(sampleTypes);
        return sampleTypes;
    }

    @Override
    protected void addMoreColumns(TypedTableModelBuilder<ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType> builder) {
        builder.addColumn("IS_LISTABLE").hideByDefault();
        builder.addColumn("IS_SHOW_CONTAINER").withDefaultWidth(200).hideByDefault();
        builder.addColumn("IS_SHOW_PARENTS").withDefaultWidth(200).hideByDefault();
        builder.addColumn("SUBCODE_UNIQUE_LABEL").hideByDefault();
        builder.addColumn("AUTO_GENERATE_CODES_LABEL").hideByDefault();
        builder.addColumn("IS_SHOW_PARENT_METADATA").hideByDefault();
        builder.addColumn("GENERATED_CODE_PREFIX").hideByDefault();
        new SemanticAnnotationProvider().addMoreColumns(builder, false);
    }

    @Override
    protected void addMoreCells(TypedTableModelBuilder<ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType> builder, ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType type) {
        builder.column("IS_LISTABLE").addString(SimpleYesNoRenderer.render(type.isListable()));
        builder.column("IS_SHOW_CONTAINER").addString(SimpleYesNoRenderer.render(type.isShowContainer()));
        builder.column("IS_SHOW_PARENTS").addString(SimpleYesNoRenderer.render(type.isShowParents()));
        builder.column("SUBCODE_UNIQUE_LABEL").addString(SimpleYesNoRenderer.render(type.isSubcodeUnique()));
        builder.column("AUTO_GENERATE_CODES_LABEL").addString(SimpleYesNoRenderer.render(type.isAutoGeneratedCode()));
        builder.column("IS_SHOW_PARENT_METADATA").addString(SimpleYesNoRenderer.render(type.isShowParentMetadata()));
        builder.column("GENERATED_CODE_PREFIX").addString(type.getGeneratedCodePrefix());
        List<SemanticAnnotation> annotations = this.annotationsMap.get(type.getCode());
        new SemanticAnnotationProvider().addMoreCells(builder, annotations, null);
    }

    private Map<String, List<SemanticAnnotation>> createAnnotationsMap(Collection<ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType> sampleTypes) {
        HashSet<String> codes = new HashSet<String>();
        for (ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType sampleType : sampleTypes) {
            codes.add(sampleType.getCode());
        }
        SampleTypeSearchCriteria criteria = new SampleTypeSearchCriteria();
        criteria.withCodes().thatIn(codes);
        SampleTypeFetchOptions fo = new SampleTypeFetchOptions();
        fo.withSemanticAnnotations();
        SearchResult result = this.applicationServerApi.searchSampleTypes(this.sessionToken, criteria, fo);
        HashMap<String, List<SemanticAnnotation>> map = new HashMap<String, List<SemanticAnnotation>>();
        for (SampleType sampleType : result.getObjects()) {
            map.put(sampleType.getCode(), sampleType.getSemanticAnnotations());
        }
        return map;
    }
}

