/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server.resultset;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.semanticannotation.SemanticAnnotation;
import ch.systemsx.cisd.openbis.generic.shared.basic.SimpleYesNoRenderer;
import ch.systemsx.cisd.openbis.generic.shared.util.TypedTableModelBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class SemanticAnnotationProvider {
    private static final int DEFAULT_WIDTH = 200;

    public void addMoreColumns(TypedTableModelBuilder<?> builder, boolean inherited) {
        builder.addColumn("SEMANTIC_ANNOTATION_PERM_ID").hideByDefault().withDefaultWidth(200);
        builder.addColumn("SEMANTIC_ANNOTATION_PREDICATE_ONTOLOGY_ID").hideByDefault().withDefaultWidth(200);
        builder.addColumn("SEMANTIC_ANNOTATION_PREDICATE_ONTOLOGY_VERSION").hideByDefault().withDefaultWidth(200);
        builder.addColumn("SEMANTIC_ANNOTATION_PREDICATE_ACCESSION_ID").hideByDefault().withDefaultWidth(200);
        builder.addColumn("SEMANTIC_ANNOTATION_DESCRIPTOR_ONTOLOGY_ID").hideByDefault().withDefaultWidth(200);
        builder.addColumn("SEMANTIC_ANNOTATION_DESCRIPTOR_ONTOLOGY_VERSION").hideByDefault().withDefaultWidth(200);
        builder.addColumn("SEMANTIC_ANNOTATION_DESCRIPTOR_ACCESSION_ID").hideByDefault().withDefaultWidth(200);
        if (inherited) {
            builder.addColumn("SEMANTIC_ANNOTATION_INHERITED").hideByDefault().withDefaultWidth(200);
        }
    }

    public void addMoreCells(TypedTableModelBuilder<?> builder, List<SemanticAnnotation> annotations, Boolean inherited) {
        ArrayList<SemanticAnnotation> sortedAnnotations = new ArrayList<SemanticAnnotation>();
        if (annotations != null) {
            sortedAnnotations.addAll(annotations);
            sortedAnnotations.sort(new Comparator<SemanticAnnotation>(){

                @Override
                public int compare(SemanticAnnotation o1, SemanticAnnotation o2) {
                    return o1.getPermId().getPermId().compareTo(o2.getPermId().getPermId());
                }
            });
        }
        builder.column("SEMANTIC_ANNOTATION_PERM_ID").addString(new PermIdFormatter().format(sortedAnnotations));
        builder.column("SEMANTIC_ANNOTATION_PREDICATE_ONTOLOGY_ID").addString(new PredicateOntologyIdFormatter().format(sortedAnnotations));
        builder.column("SEMANTIC_ANNOTATION_PREDICATE_ONTOLOGY_VERSION").addString(new PredicateOntologyVersionFormatter().format(sortedAnnotations));
        builder.column("SEMANTIC_ANNOTATION_PREDICATE_ACCESSION_ID").addString(new PredicateAccessionIdFormatter().format(sortedAnnotations));
        builder.column("SEMANTIC_ANNOTATION_DESCRIPTOR_ONTOLOGY_ID").addString(new DescriptorOntologyIdFormatter().format(sortedAnnotations));
        builder.column("SEMANTIC_ANNOTATION_DESCRIPTOR_ONTOLOGY_VERSION").addString(new DescriptorOntologyVersionFormatter().format(sortedAnnotations));
        builder.column("SEMANTIC_ANNOTATION_DESCRIPTOR_ACCESSION_ID").addString(new DescriptorAccessionIdFormatter().format(sortedAnnotations));
        if (inherited != null) {
            builder.column("SEMANTIC_ANNOTATION_INHERITED").addString(SimpleYesNoRenderer.render(inherited));
        }
    }

    private class DescriptorAccessionIdFormatter
    extends Formatter {
        private DescriptorAccessionIdFormatter() {
        }

        @Override
        protected String getValue(SemanticAnnotation annotation) {
            return annotation.getDescriptorAccessionId();
        }
    }

    private class DescriptorOntologyVersionFormatter
    extends Formatter {
        private DescriptorOntologyVersionFormatter() {
        }

        @Override
        protected String getValue(SemanticAnnotation annotation) {
            return annotation.getDescriptorOntologyVersion();
        }
    }

    private class DescriptorOntologyIdFormatter
    extends Formatter {
        private DescriptorOntologyIdFormatter() {
        }

        @Override
        protected String getValue(SemanticAnnotation annotation) {
            return annotation.getDescriptorOntologyId();
        }
    }

    private class PredicateAccessionIdFormatter
    extends Formatter {
        private PredicateAccessionIdFormatter() {
        }

        @Override
        protected String getValue(SemanticAnnotation annotation) {
            return annotation.getPredicateAccessionId();
        }
    }

    private class PredicateOntologyVersionFormatter
    extends Formatter {
        private PredicateOntologyVersionFormatter() {
        }

        @Override
        protected String getValue(SemanticAnnotation annotation) {
            return annotation.getPredicateOntologyVersion();
        }
    }

    private class PredicateOntologyIdFormatter
    extends Formatter {
        private PredicateOntologyIdFormatter() {
        }

        @Override
        protected String getValue(SemanticAnnotation annotation) {
            return annotation.getPredicateOntologyId();
        }
    }

    private class PermIdFormatter
    extends Formatter {
        private PermIdFormatter() {
        }

        @Override
        protected String getValue(SemanticAnnotation annotation) {
            return annotation.getPermId().getPermId();
        }
    }

    private abstract class Formatter {
        private Formatter() {
        }

        public String format(Collection<SemanticAnnotation> annotations) {
            StringBuilder text = new StringBuilder();
            if (annotations != null) {
                Iterator<SemanticAnnotation> iter = annotations.iterator();
                while (iter.hasNext()) {
                    SemanticAnnotation annotation = iter.next();
                    String value = this.getValue(annotation);
                    if (value != null) {
                        text.append(value);
                    }
                    if (!iter.hasNext()) continue;
                    text.append("\n\r");
                }
            }
            return text.toString();
        }

        protected abstract String getValue(SemanticAnnotation var1);
    }
}

