/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server.resultset;

import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.AbstractCommonTableModelProvider;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TypedTableModel;
import ch.systemsx.cisd.openbis.generic.shared.util.TypedTableModelBuilder;
import java.util.List;

public class SpacesProvider
extends AbstractCommonTableModelProvider<Space> {
    public SpacesProvider(ICommonServer commonServer, String sessionToken) {
        super(commonServer, sessionToken);
    }

    @Override
    protected TypedTableModel<Space> createTableModel() {
        List<Space> spaces = this.commonServer.listSpaces(this.sessionToken);
        TypedTableModelBuilder<Space> builder = new TypedTableModelBuilder<Space>();
        builder.addColumn("CODE");
        builder.addColumn("DESCRIPTION").withDefaultWidth(200);
        builder.addColumn("REGISTRATOR").withDefaultWidth(200);
        builder.addColumn("MODIFICATION_DATE").withDefaultWidth(300).hideByDefault();
        for (Space space : spaces) {
            builder.addRow(space);
            builder.column("CODE").addString(space.getCode());
            builder.column("DESCRIPTION").addString(space.getDescription());
            builder.column("REGISTRATOR").addPerson(space.getRegistrator());
            builder.column("MODIFICATION_DATE").addDate(space.getRegistrationDate());
        }
        return builder.getModel();
    }
}

