/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server.resultset;

import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ColumnDistinctValues;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.CustomFilterInfo;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.GridColumnFilterInfo;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.GridCustomColumnInfo;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.GridFilters;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.GridRowModels;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.IResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.CachedResultSetManager;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.Column;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.IColumnCalculator;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.ICustomColumnsProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.GridRowModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.IColumnDefinition;
import ch.systemsx.cisd.openbis.generic.shared.basic.PrimitiveValue;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.GridCustomColumn;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelColumnHeader;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRow;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.ehcache.pool.sizeof.annotations.IgnoreSizeOf;

class TableData<K, T> {
    private final K dataKey;
    private final List<T> originalData;
    @IgnoreSizeOf
    private final ICustomColumnsProvider customColumnsProvider;
    @IgnoreSizeOf
    private final IColumnCalculator columnCalculator;
    @IgnoreSizeOf
    private final List<TableModelColumnHeader> headers;
    @IgnoreSizeOf
    private final List<IColumnDefinition<T>> headerColumnDefinitions = new ArrayList<IColumnDefinition<T>>();
    @IgnoreSizeOf
    private Map<String, Column> calculatedColumns = new HashMap<String, Column>();

    TableData(K dataKey, List<T> originalData, List<TableModelColumnHeader> headers, ICustomColumnsProvider customColumnsProvider, IColumnCalculator columnCalculator) {
        this.dataKey = dataKey;
        this.originalData = originalData;
        this.headers = headers;
        for (final TableModelColumnHeader header : headers) {
            this.headerColumnDefinitions.add(new IColumnDefinition<T>(){

                @Override
                public String getValue(GridRowModel<T> rowModel) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public Comparable<?> tryGetComparableValue(GridRowModel<T> rowModel) {
                    Object originalObject = rowModel.getOriginalObject();
                    if (originalObject instanceof TableModelRow) {
                        TableModelRow row = (TableModelRow)originalObject;
                        return row.getValues().get(header.getIndex());
                    }
                    return null;
                }

                @Override
                public String getHeader() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public String getIdentifier() {
                    return header.getId();
                }

                @Override
                public DataTypeCode tryToGetDataType() {
                    return null;
                }

                @Override
                public String tryToGetProperty(String key) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean isCustom() {
                    return false;
                }
            });
        }
        this.customColumnsProvider = customColumnsProvider;
        this.columnCalculator = columnCalculator;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("TableData%").append(this.dataKey);
        builder.append("[columns: ").append(this.headers.size());
        builder.append(", rows: ").append(this.originalData.size());
        if (!this.originalData.isEmpty()) {
            Object objectOrNull;
            T firstRow = this.originalData.get(0);
            Class<?> rowClass = firstRow.getClass();
            if (firstRow instanceof TableModelRowWithObject && (objectOrNull = ((TableModelRowWithObject)firstRow).getObjectOrNull()) != null) {
                rowClass = objectOrNull.getClass();
            }
            builder.append(", row type: ").append(rowClass.getSimpleName());
        }
        return builder.append("]").toString();
    }

    GridRowModels<T> getRows(String sessionToken, IResultSetConfig<?, T> config) {
        Set<Map.Entry<String, Column>> cachedColumns = this.calculatedColumns.entrySet();
        List<GridCustomColumn> allCustomColumnDefinitions = this.loadAllCustomColumnDefinitions(sessionToken, config);
        List<GridCustomColumn> neededCustomColumns = this.filterNeededCustomColumnDefinitions(allCustomColumnDefinitions, config);
        this.removedColumnsNoLongerNeeded(cachedColumns, neededCustomColumns);
        for (GridCustomColumn customColumn : neededCustomColumns) {
            String code = customColumn.getCode();
            Column column = this.calculatedColumns.get(code);
            if (column != null) continue;
            Set<IColumnDefinition<T>> availableColumns = this.getAvailableColumns(config);
            boolean errorMessageLong = config.isCustomColumnErrorMessageLong();
            long time = System.currentTimeMillis();
            List<PrimitiveValue> values = this.columnCalculator.evalCustomColumn(this.originalData, customColumn, availableColumns, errorMessageLong);
            CachedResultSetManager.operationLog.info((Object)(System.currentTimeMillis() - time + "ms for calculating column '" + customColumn.getName() + "' over " + this.originalData.size() + " rows."));
            column = new Column(customColumn);
            column.setValues(values);
            this.calculatedColumns.put(code, column);
        }
        ArrayList<GridRowModel<T>> rows = new ArrayList<GridRowModel<T>>();
        for (int i = 0; i < this.originalData.size(); ++i) {
            T rowData = this.originalData.get(i);
            HashMap<String, PrimitiveValue> customColumnValues = new HashMap<String, PrimitiveValue>();
            for (Map.Entry<String, Column> entry : cachedColumns) {
                String columnCode = entry.getKey();
                customColumnValues.put(columnCode, entry.getValue().getValues().get(i));
            }
            rows.add(new GridRowModel<T>(rowData, customColumnValues));
        }
        List<ColumnDistinctValues> columnDistinctValues = this.calculateColumnDistinctValues(rows, config.getFilters());
        List<GridCustomColumnInfo> customColumnInfos = this.extractColumnInfos(allCustomColumnDefinitions);
        return new GridRowModels<T>(rows, this.headers, customColumnInfos, columnDistinctValues);
    }

    private Set<IColumnDefinition<T>> getAvailableColumns(IResultSetConfig<?, T> config) {
        HashSet<IColumnDefinition<T>> columns = new HashSet<IColumnDefinition<T>>();
        HashSet<String> columnIDs = new HashSet<String>();
        for (IColumnDefinition<T> definition : this.headerColumnDefinitions) {
            columns.add(definition);
            columnIDs.add(definition.getIdentifier());
        }
        Set<IColumnDefinition<T>> columnsFromConfig = config.getAvailableColumns();
        for (IColumnDefinition<T> definition : columnsFromConfig) {
            if (columnIDs.contains(definition.getIdentifier())) continue;
            columns.add(definition);
        }
        return columns;
    }

    private List<GridCustomColumn> loadAllCustomColumnDefinitions(String sessionToken, IResultSetConfig<?, T> resultConfig) {
        String gridId = resultConfig.tryGetGridDisplayId();
        ArrayList<GridCustomColumn> result = new ArrayList<GridCustomColumn>();
        if (gridId != null) {
            List<GridCustomColumn> columns = this.customColumnsProvider.getGridCustomColumn(sessionToken, gridId);
            for (GridCustomColumn column : columns) {
                result.add(column);
            }
        }
        return result;
    }

    private List<GridCustomColumn> filterNeededCustomColumnDefinitions(List<GridCustomColumn> allDefinitions, IResultSetConfig<?, T> resultConfig) {
        Set<String> ids = this.gatherAllColumnIDs(resultConfig);
        ArrayList<GridCustomColumn> result = new ArrayList<GridCustomColumn>();
        for (GridCustomColumn column : allDefinitions) {
            if (!ids.contains(column.getCode())) continue;
            result.add(column);
        }
        return result;
    }

    private Set<String> gatherAllColumnIDs(IResultSetConfig<?, T> resultConfig) {
        CustomFilterInfo<T> customFilterInfo;
        GridFilters<T> filters;
        List<GridColumnFilterInfo<T>> filterInfos;
        String sortField;
        HashSet<String> ids = new HashSet<String>();
        Set<String> idsOfPresentedColumns = resultConfig.getIDsOfPresentedColumns();
        if (idsOfPresentedColumns != null) {
            ids.addAll(idsOfPresentedColumns);
        }
        if ((sortField = resultConfig.getSortInfo().getSortField()) != null) {
            ids.add(sortField);
        }
        if ((filterInfos = (filters = resultConfig.getFilters()).tryGetFilterInfos()) != null) {
            for (GridColumnFilterInfo<T> filterInfo : filterInfos) {
                ids.add(filterInfo.getFilteredField().getIdentifier());
            }
        }
        if ((customFilterInfo = filters.tryGetCustomFilterInfo()) != null) {
            String expression = customFilterInfo.getExpression();
            Set<IColumnDefinition<T>> availableColumns = resultConfig.getAvailableColumns();
            for (IColumnDefinition<T> columnDefinition : availableColumns) {
                String identifier = columnDefinition.getIdentifier();
                if (expression.indexOf(identifier) < 0) continue;
                ids.add(identifier);
            }
        }
        return ids;
    }

    private void removedColumnsNoLongerNeeded(Set<Map.Entry<String, Column>> cachedColumns, List<GridCustomColumn> neededCustomColumns) {
        HashMap<String, GridCustomColumn> map = new HashMap<String, GridCustomColumn>();
        for (GridCustomColumn customColumn : neededCustomColumns) {
            map.put(customColumn.getCode(), customColumn);
        }
        Iterator<Map.Entry<String, Column>> iterator = cachedColumns.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Column> entry = iterator.next();
            String code = entry.getKey();
            GridCustomColumn customColumn = (GridCustomColumn)map.get(code);
            if (customColumn == null) {
                iterator.remove();
                continue;
            }
            if (entry.getValue().hasSameExpression(customColumn)) continue;
            iterator.remove();
        }
    }

    private List<ColumnDistinctValues> calculateColumnDistinctValues(List<GridRowModel<T>> rowModels, GridFilters<T> gridFilters) {
        ArrayList<ColumnDistinctValues> result = new ArrayList<ColumnDistinctValues>();
        List<GridColumnFilterInfo<T>> filterInfos = gridFilters.tryGetFilterInfos();
        if (filterInfos == null) {
            return result;
        }
        for (GridColumnFilterInfo<T> column : filterInfos) {
            ColumnDistinctValues distinctValues = this.tryCalculateColumnDistinctValues(rowModels, column.getFilteredField());
            if (distinctValues == null) continue;
            result.add(distinctValues);
        }
        return result;
    }

    private ColumnDistinctValues tryCalculateColumnDistinctValues(List<GridRowModel<T>> rowModels, IColumnDefinition<T> column) {
        LinkedHashSet<String> distinctValues = new LinkedHashSet<String>();
        for (GridRowModel<T> rowModel : rowModels) {
            String value = CachedResultSetManager.getOriginalValue(column, rowModel);
            distinctValues.add(value);
            if (distinctValues.size() <= 50) continue;
            return null;
        }
        ArrayList<String> distinctValuesList = new ArrayList<String>(distinctValues);
        return new ColumnDistinctValues(column.getIdentifier(), distinctValuesList);
    }

    private List<GridCustomColumnInfo> extractColumnInfos(List<GridCustomColumn> allCustomColumnDefinitions) {
        ArrayList<GridCustomColumnInfo> result = new ArrayList<GridCustomColumnInfo>();
        for (GridCustomColumn definition : allCustomColumnDefinitions) {
            Column column = this.calculatedColumns.get(definition.getCode());
            if (column != null) {
                result.add(column.getInfo());
                continue;
            }
            result.add(CachedResultSetManager.translate(definition));
        }
        return result;
    }
}

