/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server.resultset;

import ch.systemsx.cisd.openbis.generic.shared.util.RuntimeCache;
import javax.annotation.PostConstruct;
import net.sf.ehcache.CacheManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TableDataCache<K, T> {
    public static final String CACHE_NAME = "tableDataCache";
    public static final String CACHE_SIZE_PROPERTY_NAME = "ch.ethz.sis.openbis.generic.client.web.tabledatacache.size";
    @Autowired
    private CacheManager cacheManager;
    private RuntimeCache<K, T> runtimeCache;

    public TableDataCache() {
    }

    public TableDataCache(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public T getTableData(K key) {
        return this.runtimeCache.get(key);
    }

    public void putTableData(K key, T table) {
        this.runtimeCache.put(key, table);
    }

    public boolean removeTableData(K key) {
        return this.runtimeCache.remove(key);
    }

    @PostConstruct
    public void initCache() {
        if (this.runtimeCache == null) {
            this.runtimeCache = new RuntimeCache(this.cacheManager, CACHE_NAME, CACHE_SIZE_PROPERTY_NAME);
        }
        this.runtimeCache.initCache();
    }
}

