/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server.resultset;

import ch.systemsx.cisd.common.shared.basic.string.CommaSeparatedListBuilder;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.GridRowModels;
import ch.systemsx.cisd.openbis.generic.client.web.server.IBasicTableDataProvider;
import ch.systemsx.cisd.openbis.generic.client.web.server.util.TSVRenderer;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.GridRowModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ContainerDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelColumnHeader;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TypedTableModel;
import ch.systemsx.cisd.openbis.generic.shared.util.TypedTableModelBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class TableForUpdateExporter {
    public static String getExportTableForUpdate(GridRowModels<?> rows, EntityKind entityKind, String lineSeparator, ICommonServer commonServer, String sessionToken) {
        switch (entityKind) {
            case EXPERIMENT: {
                return TableForUpdateExporter.getExperimentTableForUpdate(rows, lineSeparator, commonServer, sessionToken);
            }
            case SAMPLE: {
                return TableForUpdateExporter.getSampleTableForUpdate(rows, lineSeparator, commonServer, sessionToken);
            }
            case DATA_SET: {
                return TableForUpdateExporter.getDataSetTableForUpdate(rows, lineSeparator, commonServer, sessionToken);
            }
            case MATERIAL: {
                return "Export of materials for update is currently not supported.";
            }
        }
        throw new IllegalArgumentException("Unspecified entity kind.");
    }

    private static <T extends Serializable> List<PropertyType> getAllPropertyTypes(GridRowModels<TableModelRowWithObject<T>> rows, List<? extends EntityType> types) {
        HashSet<PropertyType> propertyTypes = new HashSet<PropertyType>();
        for (GridRowModel gridRowModel : rows) {
            Object t = ((TableModelRowWithObject)gridRowModel.getOriginalObject()).getObjectOrNull();
            if (t == null) continue;
            for (EntityType entityType : types) {
                if (!entityType.getCode().equals(TableForUpdateExporter.getType(t).getCode())) continue;
                for (EntityTypePropertyType<?> et : entityType.getAssignedPropertyTypes()) {
                    if (et.isDynamic() || et.isManaged()) continue;
                    propertyTypes.add(et.getPropertyType());
                }
            }
        }
        return new ArrayList<PropertyType>(propertyTypes);
    }

    private static <T> EntityType getType(T t) {
        if (t instanceof Experiment) {
            return ((Experiment)t).getExperimentType();
        }
        if (t instanceof AbstractExternalData) {
            return ((AbstractExternalData)t).getDataSetType();
        }
        if (t instanceof Sample) {
            return ((Sample)t).getSampleType();
        }
        throw new IllegalArgumentException("Unknown data type " + t);
    }

    public static String getExperimentTableForUpdate(GridRowModels<TableModelRowWithObject<Experiment>> rows, String lineSeparator, ICommonServer commonServer, String sessionToken) {
        TypedTableModelBuilder<Experiment> builder = new TypedTableModelBuilder<Experiment>();
        builder.addColumn("identifier");
        builder.addColumn("project");
        builder.columnGroup("").addColumnsForPropertyTypesForUpdate(TableForUpdateExporter.getAllPropertyTypes(rows, commonServer.listExperimentTypes(sessionToken)));
        for (GridRowModel gridRowModel : rows) {
            Experiment experiment = (Experiment)((TableModelRowWithObject)gridRowModel.getOriginalObject()).getObjectOrNull();
            builder.addRow(experiment);
            builder.column("identifier").addString(experiment.getIdentifier());
            TableForUpdateExporter.addProperties(builder, experiment.getProperties());
        }
        return TSVRenderer.createTable(new Adapter(builder), lineSeparator);
    }

    public static String getSampleTableForUpdate(GridRowModels<TableModelRowWithObject<Sample>> rows, String lineSeparator, ICommonServer commonServer, String sessionToken) {
        TreeMap<String, ArrayList<Sample>> samples = new TreeMap<String, ArrayList<Sample>>();
        TreeMap<String, GridRowModels<TableModelRowWithObject<Sample>>> rowMap = new TreeMap<String, GridRowModels<TableModelRowWithObject<Sample>>>();
        for (GridRowModel gridRowModel : rows) {
            Sample sample = (Sample)((TableModelRowWithObject)gridRowModel.getOriginalObject()).getObjectOrNull();
            String string = sample.getSampleType().getCode();
            ArrayList<Sample> sampleList = (ArrayList<Sample>)samples.get(string);
            GridRowModels<TableModelRowWithObject<Sample>> rowList = (GridRowModels<TableModelRowWithObject<Sample>>)rowMap.get(string);
            if (sampleList == null) {
                sampleList = new ArrayList<Sample>();
                samples.put(string, sampleList);
                rowList = rows.cloneWithData(new ArrayList());
                rowMap.put(string, rowList);
            }
            sampleList.add(sample);
            rowList.add(gridRowModel);
        }
        StringBuilder builder = new StringBuilder();
        Set set = samples.entrySet();
        for (Map.Entry<String, List<Sample>> entry : set) {
            if (samples.size() > 1) {
                builder.append("[").append((String)entry.getKey()).append("]").append(lineSeparator);
            }
            builder.append(TableForUpdateExporter.getTableForSamples(entry, lineSeparator, TableForUpdateExporter.getAllPropertyTypes((GridRowModels)rowMap.get(entry.getKey()), commonServer.listSampleTypes(sessionToken))));
        }
        return builder.toString();
    }

    private static String getTableForSamples(Map.Entry<String, List<Sample>> entry, String lineSeparator, List<PropertyType> allPropertyTypes) {
        TypedTableModelBuilder<Sample> builder = new TypedTableModelBuilder<Sample>();
        builder.addColumn("identifier");
        builder.addColumn("container");
        builder.addColumn("parents");
        builder.addColumn("experiment");
        builder.columnGroup("").addColumnsForPropertyTypesForUpdate(allPropertyTypes);
        List<Sample> samples = entry.getValue();
        Collections.sort(samples);
        for (Sample sample : samples) {
            Experiment experiment;
            Set<Sample> parents;
            builder.addRow(sample);
            builder.column("identifier").addString(sample.getIdentifier());
            Sample container = sample.getContainer();
            if (container != null) {
                builder.column("container").addString(container.getIdentifier());
            }
            if ((parents = sample.getParents()) != null && !parents.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (Sample parent : parents) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(parent.getIdentifier());
                }
                builder.column("parents").addString(sb.toString());
            }
            if ((experiment = sample.getExperiment()) != null) {
                builder.column("experiment").addString(experiment.getIdentifier());
            }
            TableForUpdateExporter.addProperties(builder, sample.getProperties());
        }
        return TSVRenderer.createTable(new Adapter(builder), lineSeparator);
    }

    public static String getDataSetTableForUpdate(GridRowModels<TableModelRowWithObject<AbstractExternalData>> rows, String lineSeparator, ICommonServer commonServer, String sessionToken) {
        TypedTableModelBuilder<AbstractExternalData> builder = new TypedTableModelBuilder<AbstractExternalData>();
        builder.addColumn("code");
        builder.addColumn("container");
        builder.addColumn("parents");
        builder.addColumn("experiment");
        builder.addColumn("sample");
        builder.columnGroup("").addColumnsForPropertyTypesForUpdate(TableForUpdateExporter.getAllPropertyTypes(rows, commonServer.listDataSetTypes(sessionToken)));
        for (GridRowModel gridRowModel : rows) {
            Sample sample;
            Experiment experiment;
            Collection<AbstractExternalData> parents;
            AbstractExternalData dataSet = (AbstractExternalData)((TableModelRowWithObject)gridRowModel.getOriginalObject()).getObjectOrNull();
            builder.addRow(dataSet);
            builder.column("code").addString(dataSet.getCode());
            List<ContainerDataSet> containerDataSets = dataSet.getContainerDataSets();
            if (!containerDataSets.isEmpty()) {
                CommaSeparatedListBuilder listBuilder = new CommaSeparatedListBuilder();
                for (ContainerDataSet containerDataSet : containerDataSets) {
                    listBuilder.append((Object)containerDataSet.getCode());
                }
                builder.column("container").addString(listBuilder.toString());
            }
            if ((parents = dataSet.getParents()) != null && !parents.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (AbstractExternalData parent : parents) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(parent.getCode());
                }
                builder.column("parents").addString(sb.toString());
            }
            if ((experiment = dataSet.getExperiment()) != null) {
                builder.column("experiment").addString(experiment.getIdentifier());
            }
            if ((sample = dataSet.getSample()) != null) {
                builder.column("sample").addString(sample.getIdentifier());
            }
            TableForUpdateExporter.addProperties(builder, dataSet.getProperties());
        }
        return TSVRenderer.createTable(new Adapter(builder), lineSeparator);
    }

    private static void addProperties(TypedTableModelBuilder<?> builder, List<IEntityProperty> properties) {
        builder.columnGroup("").addPropertiesForUpdate(TableForUpdateExporter.filterUpdatableProperties(properties));
    }

    private static List<IEntityProperty> filterUpdatableProperties(List<IEntityProperty> properties) {
        ArrayList<IEntityProperty> filteredProperties = new ArrayList<IEntityProperty>();
        for (IEntityProperty property : properties) {
            if (property.isDynamic() || property.isManaged()) continue;
            filteredProperties.add(property);
        }
        return filteredProperties;
    }

    private static final class Adapter<T extends Serializable>
    implements IBasicTableDataProvider {
        private TypedTableModel<T> model;

        Adapter(TypedTableModelBuilder<T> builder) {
            this.model = builder.getModel();
        }

        @Override
        public List<String> getAllColumnTitles() {
            List<TableModelColumnHeader> headers = this.model.getHeader();
            ArrayList<String> titles = new ArrayList<String>();
            for (TableModelColumnHeader header : headers) {
                titles.add(header.getId());
            }
            return titles;
        }

        @Override
        public List<List<? extends Comparable<?>>> getRows() {
            List<TableModelRowWithObject<T>> rows = this.model.getRows();
            ArrayList result = new ArrayList();
            for (TableModelRowWithObject<T> row : rows) {
                result.add(row.getValues());
            }
            return result;
        }
    }
}

