/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server.translator;

import ch.systemsx.cisd.common.collection.SimpleComparator;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.Type;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSetFileBlastSearchResultLocation;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSetFileSearchResultLocation;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.EntityPropertyBlastSearchResultLocation;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.ISearchDomainResultLocation;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchDomainSearchResult;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdentifierHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MatchingEntity;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyMatch;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SearchDomainSearchResultWithFullEntity;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Span;
import ch.systemsx.cisd.openbis.generic.shared.dto.SearchableEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SearchableEntityTranslator {
    private static final Set<Character> CHARACTERS_TO_ESCAPE = new HashSet<Character>(Arrays.asList(Character.valueOf('['), Character.valueOf(']'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('|'), Character.valueOf('&'), Character.valueOf('.'), Character.valueOf('^'), Character.valueOf('$')));

    private SearchableEntityTranslator() {
    }

    public static final SearchableEntity[] translate(ch.systemsx.cisd.openbis.generic.client.web.client.dto.SearchableEntity searchableEntityOrNull) {
        SearchableEntity[] matchingEntities = new SearchableEntity[]{};
        if (searchableEntityOrNull == null) {
            matchingEntities = SearchableEntity.values();
        } else if (searchableEntityOrNull.getType() == Type.ENTITY) {
            matchingEntities = new SearchableEntity[]{SearchableEntity.valueOf(searchableEntityOrNull.getName())};
        }
        return matchingEntities;
    }

    public static final List<MatchingEntity> translateSearchDomains(List<SearchDomainSearchResultWithFullEntity> searchDomains, String searchString) {
        ArrayList<MatchingEntity> translatedEntities = new ArrayList<MatchingEntity>();
        for (SearchDomainSearchResultWithFullEntity searchDomain : searchDomains) {
            MatchingEntity matchingEntity = new MatchingEntity();
            IEntityInformationHolderWithIdentifier entity = searchDomain.getEntity();
            matchingEntity.setCode(entity.getCode());
            matchingEntity.setEntityKind(entity.getEntityKind());
            matchingEntity.setEntityType(entity.getEntityType());
            matchingEntity.setId(entity.getId());
            matchingEntity.setPermId(entity.getPermId());
            SearchDomainSearchResult searchResult = searchDomain.getSearchResult();
            matchingEntity.setSearchDomain(searchResult.getSearchDomain().getLabel());
            if (entity instanceof IIdentifierHolder) {
                matchingEntity.setIdentifier(((IIdentifierHolder)entity).getIdentifier());
            }
            if (searchResult.getScore() != null) {
                matchingEntity.setScore(searchResult.getScore().getScore());
            }
            ISearchDomainResultLocation resultLocation = searchResult.getResultLocation();
            List<PropertyMatch> matches = SearchableEntityTranslator.createMatches(searchString, resultLocation);
            matchingEntity.setMatches(matches);
            translatedEntities.add(matchingEntity);
        }
        Collections.sort(translatedEntities, new SimpleComparator<MatchingEntity, Double>(){

            public Double evaluate(MatchingEntity item) {
                return -item.getScore();
            }
        });
        return translatedEntities;
    }

    private static List<PropertyMatch> createMatches(String searchString, ISearchDomainResultLocation resultLocation) {
        ArrayList<PropertyMatch> matches = new ArrayList<PropertyMatch>();
        PropertyMatch match = new PropertyMatch();
        if (resultLocation instanceof DataSetFileBlastSearchResultLocation) {
            DataSetFileBlastSearchResultLocation fileBlastLocation = (DataSetFileBlastSearchResultLocation)resultLocation;
            match.setCode("File '" + fileBlastLocation.getPathInDataSet() + "'");
            match.setValue(fileBlastLocation.getAlignmentMatch().toString());
            matches.add(match);
        } else if (resultLocation instanceof EntityPropertyBlastSearchResultLocation) {
            EntityPropertyBlastSearchResultLocation entityBlastLocation = (EntityPropertyBlastSearchResultLocation)resultLocation;
            match.setCode("Property '" + entityBlastLocation.getPropertyType() + "'");
            match.setValue(entityBlastLocation.getAlignmentMatch().toString());
            matches.add(match);
        } else if (resultLocation instanceof DataSetFileSearchResultLocation) {
            match.setValue(((DataSetFileSearchResultLocation)resultLocation).getPathInDataSet());
            String pathString = ((DataSetFileSearchResultLocation)resultLocation).getPathInDataSet();
            List<Span> spans = SearchableEntityTranslator.createSpanList(searchString, pathString);
            match.setSpans(spans);
            matches.add(match);
        } else {
            match.setValue(((DataSetFileSearchResultLocation)resultLocation).toString());
            matches.add(match);
        }
        return matches;
    }

    static List<Span> createSpanList(String searchString, String filePath) {
        List<SearchStringElement> splittedSearchString = SearchableEntityTranslator.split("*" + searchString + "*");
        Pattern pattern = SearchableEntityTranslator.compile(splittedSearchString);
        String normalizedFilePath = filePath.toLowerCase();
        Matcher matcher = pattern.matcher(normalizedFilePath);
        ArrayList<Span> spans = new ArrayList<Span>();
        if (matcher.matches()) {
            int groupCount = matcher.groupCount();
            int startIndex = 0;
            for (int i = 1; i <= groupCount; ++i) {
                String group = matcher.group(i);
                if (splittedSearchString.get(i - 1).constant) {
                    Span span = new Span();
                    span.setStart(startIndex);
                    span.setEnd(startIndex + group.length());
                    spans.add(span);
                }
                startIndex += group.length();
            }
        }
        return spans;
    }

    private static List<SearchStringElement> split(String searchString) {
        boolean previousWasWildcard = true;
        ArrayList<SearchStringElement> result = new ArrayList<SearchStringElement>();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < searchString.length(); ++i) {
            char c = Character.toLowerCase(searchString.charAt(i));
            if (c == '*' || c == '?') {
                if (!previousWasWildcard) {
                    result.add(new SearchStringElement(builder.toString()));
                    builder.setLength(0);
                }
                builder.append(c);
                previousWasWildcard = true;
                continue;
            }
            if (previousWasWildcard) {
                result.add(new SearchStringElement(builder.toString()));
                builder.setLength(0);
            }
            builder.append(c);
            previousWasWildcard = false;
        }
        if (builder.length() > 0) {
            result.add(new SearchStringElement(builder.toString()));
        }
        return result;
    }

    private static Pattern compile(List<SearchStringElement> elements) {
        StringBuilder builder = new StringBuilder();
        for (SearchStringElement searchStringElement : elements) {
            builder.append('(').append(searchStringElement.text).append(')');
        }
        return Pattern.compile(builder.toString());
    }

    private static class SearchStringElement {
        private boolean constant;
        private String text;

        SearchStringElement(String text) {
            if (text.contains("*")) {
                this.text = ".*";
                this.constant = false;
            } else if (text.equals("?")) {
                this.text = ".";
                this.constant = false;
            } else {
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < text.length(); ++i) {
                    char c = text.charAt(i);
                    if (CHARACTERS_TO_ESCAPE.contains(Character.valueOf(c))) {
                        builder.append('\\');
                    }
                    builder.append(c);
                }
                this.text = builder.toString();
                this.constant = true;
            }
        }

        public String toString() {
            return this.text;
        }
    }
}

