/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server.util;

import ch.systemsx.cisd.openbis.generic.client.web.server.IBasicTableDataProvider;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class TSVRenderer {
    private static final String TAB = "\t";
    private final String lineSeparator;

    public static String createTable(IBasicTableDataProvider dataProvider, String lineSeparator) {
        return new TSVRenderer(lineSeparator).createTable(dataProvider);
    }

    private String createTable(IBasicTableDataProvider dataProvider) {
        StringBuffer sb = new StringBuffer();
        this.appendHeader(dataProvider.getAllColumnTitles(), sb);
        List<List<Comparable<?>>> rows = dataProvider.getRows();
        for (List<? extends Comparable<?>> list : rows) {
            this.appendEntity(list, sb);
        }
        return sb.toString();
    }

    private TSVRenderer(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    private void appendEntity(List<? extends Comparable<?>> row, StringBuffer sb) {
        boolean isFirst = true;
        for (Comparable<?> value : row) {
            if (!isFirst) {
                sb.append(TAB);
            } else {
                isFirst = false;
            }
            sb.append(this.cleanWhitespaces(value == null ? "" : value.toString()));
        }
        sb.append(this.lineSeparator);
    }

    private String cleanWhitespaces(String value) {
        Object[] tokens = StringUtils.split((String)value);
        String result = StringUtils.join((Object[])tokens, (String)" ");
        return result;
    }

    private void appendHeader(List<String> headers, StringBuffer sb) {
        boolean isFirst = true;
        for (String header : headers) {
            if (!isFirst) {
                sb.append(TAB);
            } else {
                isFirst = false;
            }
            sb.append(header);
        }
        sb.append(this.lineSeparator);
    }
}

