/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server;

import ch.systemsx.cisd.authentication.IAuthenticationService;
import ch.systemsx.cisd.authentication.Principal;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.AbstractServer;
import ch.systemsx.cisd.openbis.generic.server.business.IPropertiesBatchManager;
import ch.systemsx.cisd.openbis.generic.server.business.bo.DataSetTable;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ICommonBusinessObjectFactory;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IDataSetTable;
import ch.systemsx.cisd.openbis.generic.server.business.bo.datasetlister.IDatasetLister;
import ch.systemsx.cisd.openbis.generic.server.business.bo.util.DataSetUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.plugin.IDataSetTypeSlaveServerPlugin;
import ch.systemsx.cisd.openbis.generic.shared.IOpenBisSessionManager;
import ch.systemsx.cisd.openbis.generic.shared.IServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DisplaySettings;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

abstract class AbstractCommonServer<T extends IServer>
extends AbstractServer<T> {
    private final IAuthenticationService authenticationService;
    protected final ICommonBusinessObjectFactory businessObjectFactory;

    public AbstractCommonServer(IAuthenticationService authenticationService, IOpenBisSessionManager sessionManager, IDAOFactory daoFactory, IPropertiesBatchManager propertiesBatchManager, ICommonBusinessObjectFactory businessObjectFactory) {
        super(sessionManager, daoFactory, propertiesBatchManager);
        this.authenticationService = authenticationService;
        this.businessObjectFactory = businessObjectFactory;
    }

    protected List<PersonPE> registerPersons(String sessionToken, List<String> userIDs) {
        Session session = this.getSession(sessionToken);
        List<PersonPE> persons = this.getDAOFactory().getPersonDAO().listByCodes(userIDs);
        if (persons.size() > 0) {
            throw UserFailureException.fromTemplate((String)"Following persons already exist: [%s]", (Object[])new Object[]{StringUtils.join(userIDs, (String)",")});
        }
        ArrayList<String> unknownUsers = new ArrayList<String>();
        DisplaySettings defaultDisplaySettings = this.getDefaultDisplaySettings(sessionToken);
        ArrayList<PersonPE> newPersons = new ArrayList<PersonPE>();
        for (String userID : userIDs) {
            try {
                Principal principal = this.authenticationService.getPrincipal(userID);
                newPersons.add(this.createPerson(principal, session.tryGetPerson(), defaultDisplaySettings));
            }
            catch (IllegalArgumentException e) {
                unknownUsers.add(userID);
            }
        }
        if (unknownUsers.size() > 0) {
            throw UserFailureException.fromTemplate((String)"Following persons unknown by the authentication service: [%s]", (Object[])new Object[]{StringUtils.join(unknownUsers, (String)",")});
        }
        return newPersons;
    }

    @Deprecated
    protected void permanentlyDeleteDataSets(Session session, IDataSetTable dataSetTable, List<String> dataSetCodes, String reason, boolean forceDisallowedTypes) {
        DataSetTypePE dataSetType;
        dataSetTable.loadByDataSetCodes(dataSetCodes, false, false);
        List<DataPE> dataSets = dataSetTable.getDataSets();
        if (this.atLeastOneOfDataSetsIsContainer(dataSets)) {
            List<TechId> ids = DataSetUtils.getAllDeletableComponentsRecursively(TechId.createList(dataSetTable.getDataSets()), true, this.createDatasetLister(session), this.getDAOFactory());
            dataSetTable.loadByIds(ids);
            dataSets = dataSetTable.getDataSets();
        }
        LinkedHashMap<DataSetTypePE, ArrayList<DataPE>> groupedDataSets = new LinkedHashMap<DataSetTypePE, ArrayList<DataPE>>();
        DataSetTable.assertDatasetsAreDeletable(dataSets);
        DataSetTable.assertDatasetsWithDisallowedTypes(dataSets, forceDisallowedTypes);
        for (DataPE dataPE : dataSets) {
            dataSetType = dataPE.getDataSetType();
            ArrayList<DataPE> list = (ArrayList<DataPE>)groupedDataSets.get(dataSetType);
            if (list == null) {
                list = new ArrayList<DataPE>();
                groupedDataSets.put(dataSetType, list);
            }
            list.add(dataPE);
        }
        for (Map.Entry entry : groupedDataSets.entrySet()) {
            dataSetType = (DataSetTypePE)entry.getKey();
            IDataSetTypeSlaveServerPlugin plugin = this.getDataSetTypeSlaveServerPlugin(dataSetType);
            plugin.permanentlyDeleteDataSets(session, (List)entry.getValue(), reason, forceDisallowedTypes);
        }
    }

    private boolean atLeastOneOfDataSetsIsContainer(Collection<DataPE> dataSets) {
        for (DataPE dataSet : dataSets) {
            if (!dataSet.isContainer()) continue;
            return true;
        }
        return false;
    }

    public int archiveDatasets(String sessionToken, List<String> datasetCodes, boolean deleteFromDataStore, Map<String, String> options) {
        Session session = this.getSession(sessionToken);
        IDataSetTable dataSetTable = this.businessObjectFactory.createDataSetTable(session);
        dataSetTable.loadByDataSetCodes(datasetCodes, false, true);
        return dataSetTable.archiveDatasets(deleteFromDataStore, options);
    }

    public int unarchiveDatasets(String sessionToken, List<String> datasetCodes) {
        Session session = this.getSession(sessionToken);
        IDataSetTable dataSetTable = this.businessObjectFactory.createDataSetTable(session);
        dataSetTable.loadByDataSetCodes(datasetCodes, false, true);
        return dataSetTable.unarchiveDatasets();
    }

    protected IDatasetLister createDatasetLister(Session session) {
        return this.businessObjectFactory.createDatasetLister(session);
    }
}

