/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server;

import ch.ethz.sis.openbis.generic.asapi.v3.IApplicationServerApi;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.cache.ICacheManager;
import ch.systemsx.cisd.authentication.DefaultSessionManager;
import ch.systemsx.cisd.authentication.IPrincipalProvider;
import ch.systemsx.cisd.authentication.ISessionActionListener;
import ch.systemsx.cisd.authentication.ISessionManager;
import ch.systemsx.cisd.authentication.Principal;
import ch.systemsx.cisd.common.action.IDelegatedActionWithResult;
import ch.systemsx.cisd.common.exceptions.InvalidSessionException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.common.mail.MailClient;
import ch.systemsx.cisd.common.mail.MailClientParameters;
import ch.systemsx.cisd.common.spring.ExposablePropertyPlaceholderConfigurer;
import ch.systemsx.cisd.openbis.common.spring.AbstractServiceWithLogger;
import ch.systemsx.cisd.openbis.generic.server.CommonServiceProvider;
import ch.systemsx.cisd.openbis.generic.server.DisplaySettingsProvider;
import ch.systemsx.cisd.openbis.generic.server.IASyncAction;
import ch.systemsx.cisd.openbis.generic.server.SessionFactory;
import ch.systemsx.cisd.openbis.generic.server.authorization.AuthorizationServiceUtils;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.ReturnValueFilter;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.RolesAllowed;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.ExpressionValidator;
import ch.systemsx.cisd.openbis.generic.server.business.IDataStoreServiceFactory;
import ch.systemsx.cisd.openbis.generic.server.business.IPropertiesBatchManager;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IRoleAssignmentDAO;
import ch.systemsx.cisd.openbis.generic.server.plugin.DataSetServerPluginRegistry;
import ch.systemsx.cisd.openbis.generic.server.plugin.IDataSetServerPlugin;
import ch.systemsx.cisd.openbis.generic.server.plugin.IDataSetTypeSlaveServerPlugin;
import ch.systemsx.cisd.openbis.generic.server.plugin.ISampleServerPlugin;
import ch.systemsx.cisd.openbis.generic.server.plugin.ISampleTypeSlaveServerPlugin;
import ch.systemsx.cisd.openbis.generic.server.plugin.SampleServerPluginRegistry;
import ch.systemsx.cisd.openbis.generic.shared.IOpenBisSessionManager;
import ch.systemsx.cisd.openbis.generic.shared.IRemoteHostValidator;
import ch.systemsx.cisd.openbis.generic.shared.IServer;
import ch.systemsx.cisd.openbis.generic.shared.ISessionWorkspaceProvider;
import ch.systemsx.cisd.openbis.generic.shared.authorization.IAuthorizationConfig;
import ch.systemsx.cisd.openbis.generic.shared.basic.EntityVisitComparatorByTimeStamp;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DisplaySettings;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityVisit;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.GridCustomColumn;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSamplesWithTypes;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.displaysettings.IDisplaySettingsUpdate;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataStorePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.GridCustomColumnPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IAuthSession;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityWithMetaprojects;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.RoleAssignmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.SessionContextDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.SimpleSession;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.translator.GridCustomExpressionTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.PersonRolesTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.PersonTranslator;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import ch.systemsx.cisd.openbis.generic.shared.util.ServerUtils;
import java.io.File;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractServer<T>
extends AbstractServiceWithLogger<T>
implements IServer {
    protected static ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 10, 360L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private static final String ETL_SERVER_USERNAME_PREFIX = "etlserver";
    @Resource(name="sample-plugin-registry")
    private SampleServerPluginRegistry sampleServerPluginRegistry;
    @Resource(name="data-set-plugin-registry")
    private DataSetServerPluginRegistry dataSetServerPluginRegistry;
    private ISampleTypeSlaveServerPlugin sampleTypeSlaveServerPlugin;
    private IDataSetTypeSlaveServerPlugin dataSetTypeSlaveServerPlugin;
    @Resource(name="session-manager")
    protected IOpenBisSessionManager sessionManager;
    @Resource(name="display-settings-provider")
    protected DisplaySettingsProvider displaySettingsProvider;
    @Resource(name="dao-factory")
    private IDAOFactory daoFactory;
    @Resource(name="dss-factory")
    private IDataStoreServiceFactory dssFactory;
    @Resource(name="remote-host-validator")
    private IRemoteHostValidator remoteHostValidator;
    @Resource(name="mail-client-parameters")
    protected MailClientParameters mailClientParameters;
    @Resource(name="propertyConfigurer")
    protected ExposablePropertyPlaceholderConfigurer configurer;
    @Resource(name="properties-batch-manager")
    private IPropertiesBatchManager propertiesBatchManager;
    @Autowired
    private IAuthorizationConfig authorizationConfig;
    @Autowired
    private ISessionWorkspaceProvider sessionWorkspaceProvider;
    private IApplicationServerApi v3Api;
    protected String CISDHelpdeskEmail;
    @Autowired
    private ICacheManager cacheManager;
    private ISessionActionListener sessionActionListener = new ISessionActionListener(){

        public void sessionClosed(String sessionToken) {
            AbstractServer.this.cacheManager.clearCacheOfUser(sessionToken);
            AbstractServer.this.logout(sessionToken);
        }
    };

    protected AbstractServer() {
        this.operationLog.info((Object)String.format("Creating new '%s' implementation: '%s'.", IServer.class.getSimpleName(), this.getClass().getName()));
    }

    protected AbstractServer(IOpenBisSessionManager sessionManager, IDAOFactory daoFactory, IPropertiesBatchManager propertiesBatchManager) {
        this();
        this.sessionManager = sessionManager;
        this.daoFactory = daoFactory;
        this.propertiesBatchManager = propertiesBatchManager;
    }

    protected AbstractServer(IOpenBisSessionManager sessionManager, IDAOFactory daoFactory, IPropertiesBatchManager propertiesBatchManager, ISampleTypeSlaveServerPlugin sampleTypeSlaveServerPlugin, IDataSetTypeSlaveServerPlugin dataSetTypeSlaveServerPlugin) {
        this(sessionManager, daoFactory, propertiesBatchManager);
        this.sampleTypeSlaveServerPlugin = sampleTypeSlaveServerPlugin;
        this.dataSetTypeSlaveServerPlugin = dataSetTypeSlaveServerPlugin;
    }

    @PostConstruct
    public void registerAtSessionManager() {
        this.sessionManager.addListener(this.sessionActionListener);
    }

    public void setDisplaySettingsProvider(DisplaySettingsProvider displaySettingsProvider) {
        this.displaySettingsProvider = displaySettingsProvider;
    }

    public void setSessionWorkspaceProvider(ISessionWorkspaceProvider sessionWorkspaceProvider) {
        this.sessionWorkspaceProvider = sessionWorkspaceProvider;
    }

    public void setCacheManager(ICacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setDssFactory(IDataStoreServiceFactory dssFactory) {
        this.dssFactory = dssFactory;
    }

    protected IPropertiesBatchManager getPropertiesBatchManager() {
        return this.propertiesBatchManager;
    }

    public final void setCISDHelpdeskEmail(String cisdHelpdeskEmail) {
        this.CISDHelpdeskEmail = cisdHelpdeskEmail;
    }

    public final void setSampleTypeSlaveServerPlugin(ISampleTypeSlaveServerPlugin sampleTypeSlaveServerPlugin) {
        this.sampleTypeSlaveServerPlugin = sampleTypeSlaveServerPlugin;
    }

    public final void setDataSetTypeSlaveServerPlugin(IDataSetTypeSlaveServerPlugin dataSetTypeSlaveServerPlugin) {
        this.dataSetTypeSlaveServerPlugin = dataSetTypeSlaveServerPlugin;
    }

    protected final ISampleTypeSlaveServerPlugin getSampleTypeSlaveServerPlugin(SampleTypePE sampleType) {
        if (this.sampleTypeSlaveServerPlugin != null) {
            return this.sampleTypeSlaveServerPlugin;
        }
        return ((ISampleServerPlugin)this.sampleServerPluginRegistry.getPlugin(EntityKind.SAMPLE, sampleType)).getSlaveServer();
    }

    protected final IDataSetTypeSlaveServerPlugin getDataSetTypeSlaveServerPlugin(DataSetTypePE dataSetType) {
        if (this.dataSetTypeSlaveServerPlugin != null) {
            return this.dataSetTypeSlaveServerPlugin;
        }
        return ((IDataSetServerPlugin)this.dataSetServerPluginRegistry.getPlugin(EntityKind.DATA_SET, dataSetType)).getSlaveServer();
    }

    private final RoleAssignmentPE createRoleAssigment(PersonPE registrator, PersonPE person, RoleWithHierarchy.RoleCode roleCode) {
        RoleAssignmentPE roleAssignmentPE = new RoleAssignmentPE();
        roleAssignmentPE.setRegistrator(registrator);
        roleAssignmentPE.setRole(roleCode);
        person.addRoleAssignment(roleAssignmentPE);
        return roleAssignmentPE;
    }

    protected final PersonPE createPerson(Principal principal, PersonPE registrator, DisplaySettings defaultDisplaySettings) {
        PersonPE person = new PersonPE();
        person.setUserId(principal.getUserId());
        person.setFirstName(principal.getFirstName());
        person.setLastName(principal.getLastName());
        person.setEmail(principal.getEmail());
        person.setRegistrator(registrator);
        person.setDisplaySettings(defaultDisplaySettings);
        person.setActive(true);
        try {
            this.daoFactory.getPersonDAO().createPerson(person);
        }
        catch (DataAccessException e) {
            throw new UserFailureException(e.getMessage(), (Throwable)e);
        }
        return person;
    }

    private final void updatePersonIfNecessary(PersonPE person, Principal principal) {
        boolean changed = false;
        if (this.updateNeeded(person.getEmail(), principal.getEmail())) {
            person.setEmail(principal.getEmail());
            changed = true;
        }
        if (this.updateNeeded(person.getFirstName(), principal.getFirstName())) {
            person.setFirstName(principal.getFirstName());
            changed = true;
        }
        if (this.updateNeeded(person.getLastName(), principal.getLastName())) {
            person.setLastName(principal.getLastName());
            changed = true;
        }
        if (changed) {
            try {
                this.daoFactory.getPersonDAO().updatePerson(person);
            }
            catch (DataAccessException e) {
                throw new UserFailureException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private boolean updateNeeded(String currentValue, String newValue) {
        if (newValue == null) {
            return false;
        }
        return currentValue == null || !currentValue.equals(newValue);
    }

    protected final PersonPE getSystemUser() {
        return AbstractServer.getSystemUser(this.daoFactory.getPersonDAO().listPersons());
    }

    private static final PersonPE getSystemUser(List<PersonPE> persons) {
        for (PersonPE personPE : persons) {
            if (!personPE.isSystemUser()) continue;
            return personPE;
        }
        throw new IllegalStateException(String.format("No system user could be found in given list '%s'.", persons));
    }

    protected final ISessionManager<Session> getSessionManager() {
        return this.sessionManager;
    }

    protected final IDAOFactory getDAOFactory() {
        return this.daoFactory;
    }

    @Override
    public void checkSession(String sessionToken) throws InvalidSessionException {
        this.getSession(sessionToken);
    }

    protected Session getSession(String sessionToken) {
        assert (sessionToken != null) : "Unspecified session token";
        return (Session)this.getSessionManager().getSession(sessionToken);
    }

    @Override
    public final IAuthSession getAuthSession(String sessionToken) throws UserFailureException {
        return new SimpleSession((IAuthSession)this.sessionManager.getSession(sessionToken));
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public Map<String, String> getServerInformation(String sessionToken) {
        return this.getV3Api().getServerInformation(sessionToken);
    }

    private IApplicationServerApi getV3Api() {
        if (this.v3Api == null) {
            this.v3Api = CommonServiceProvider.getApplicationServerApi();
        }
        return this.v3Api;
    }

    @Override
    @Transactional(readOnly=true)
    public final void logout(String sessionToken) throws UserFailureException {
        try {
            this.cacheManager.clearCacheOfUser(sessionToken);
            this.sessionManager.closeSession(sessionToken);
            this.sessionWorkspaceProvider.deleteSessionWorkspace(sessionToken);
            SessionFactory.cleanUpSessionOnDataStoreServers(sessionToken, this.daoFactory.getDataStoreDAO(), this.dssFactory);
        }
        catch (InvalidSessionException invalidSessionException) {
            // empty catch block
        }
    }

    @Override
    @Transactional(readOnly=true)
    public final void expireSession(String sessionToken) throws UserFailureException {
        try {
            this.sessionManager.expireSession(sessionToken);
            this.sessionWorkspaceProvider.deleteSessionWorkspace(sessionToken);
            SessionFactory.cleanUpSessionOnDataStoreServers(sessionToken, this.daoFactory.getDataStoreDAO(), this.dssFactory);
        }
        catch (InvalidSessionException invalidSessionException) {
            // empty catch block
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public void deactivatePersons(String sessionToken, List<String> personsCodes) {
        this.checkSession(sessionToken);
        for (String personCode : personsCodes) {
            PersonPE person = this.getDAOFactory().getPersonDAO().tryFindPersonByUserId(personCode);
            if (person == null) continue;
            IRoleAssignmentDAO roleAssignmenDAO = this.getDAOFactory().getRoleAssignmentDAO();
            person.setActive(false);
            person.setDisplaySettings(null);
            person.clearAuthorizationGroups();
            ArrayList<RoleAssignmentPE> roleAssignments = new ArrayList<RoleAssignmentPE>(person.getRoleAssignments());
            for (RoleAssignmentPE roleAssignment : roleAssignments) {
                roleAssignmenDAO.deleteRoleAssignment(roleAssignment);
            }
            this.getDAOFactory().getPersonDAO().updatePerson(person);
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public int countActivePersons(String sessionToken) {
        this.checkSession(sessionToken);
        return this.getDAOFactory().getPersonDAO().countActivePersons();
    }

    public SessionContextDTO tryToAuthenticateAsSystem() {
        PersonPE systemUser = this.getSystemUser();
        HibernateUtils.initialize(systemUser.getAllPersonRoles());
        RoleAssignmentPE role = new RoleAssignmentPE();
        role.setRole(RoleWithHierarchy.RoleCode.ADMIN);
        systemUser.addRoleAssignment(role);
        String sessionToken = this.sessionManager.tryToOpenSession(systemUser.getUserId(), new AuthenticatedPersonBasedPrincipalProvider(systemUser));
        Session session = (Session)this.sessionManager.getSession(sessionToken);
        session.setPerson(systemUser);
        session.setCreatorPerson(systemUser);
        return this.tryGetSession(sessionToken);
    }

    @Override
    public SessionContextDTO tryAuthenticateAnonymously() {
        String userForAnonymousLogin = this.sessionManager.getUserForAnonymousLogin();
        if (userForAnonymousLogin == null) {
            return null;
        }
        PersonPE person = this.daoFactory.getPersonDAO().tryFindPersonByUserId(userForAnonymousLogin);
        if (person == null) {
            return null;
        }
        return this.tryToAuthenticate(this.sessionManager.tryToOpenSession(userForAnonymousLogin, new AuthenticatedPersonBasedPrincipalProvider(person)));
    }

    @Override
    public final SessionContextDTO tryAuthenticate(String user, String password) {
        return this.tryToAuthenticate(this.sessionManager.tryToOpenSession(user, password));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final SessionContextDTO tryAuthenticateAs(String user, String password, final String asUser) {
        SessionContextDTO userSessionContext = this.tryAuthenticate(user, password);
        try {
            if (userSessionContext != null) {
                SessionContextDTO asUserSessionContext;
                Session userSession = (Session)this.sessionManager.getSession(userSessionContext.getSessionToken());
                AuthorizationServiceUtils userAuthorizationUtils = new AuthorizationServiceUtils(this.daoFactory, user);
                boolean userIsInstanceAdmin = userAuthorizationUtils.doesUserHaveRole(RoleWithHierarchy.RoleCode.ADMIN.name(), null);
                if (!userIsInstanceAdmin) {
                    SessionContextDTO sessionContextDTO = null;
                    return sessionContextDTO;
                }
                String asUserSessionToken = this.sessionManager.tryToOpenSession(asUser, new IPrincipalProvider(){

                    public Principal tryToGetPrincipal(String userID) {
                        PersonPE asUserPerson = AbstractServer.this.daoFactory.getPersonDAO().tryFindPersonByUserId(asUser);
                        if (asUserPerson != null) {
                            return new Principal(asUser, asUserPerson.getFirstName(), asUserPerson.getLastName(), asUserPerson.getEmail(), true);
                        }
                        return null;
                    }
                });
                if (asUserSessionToken != null && (asUserSessionContext = this.tryToAuthenticate(asUserSessionToken)) != null) {
                    Session asUserSession = (Session)this.sessionManager.getSession(asUserSessionToken);
                    asUserSession.setCreatorPerson(userSession.tryGetPerson());
                    SessionContextDTO sessionContextDTO = asUserSessionContext;
                    return sessionContextDTO;
                }
            }
            SessionContextDTO sessionContextDTO = null;
            return sessionContextDTO;
        }
        finally {
            if (userSessionContext != null) {
                this.logout(userSessionContext.getSessionToken());
            }
        }
    }

    @Override
    public SessionContextDTO tryToAuthenticate(String sessionToken) {
        Set<RoleAssignmentPE> roles;
        if (DefaultSessionManager.NO_LOGIN_FILE.exists()) {
            throw new UserFailureException("Login is disabled by the administrator.");
        }
        if (sessionToken == null) {
            return null;
        }
        Session session = (Session)this.sessionManager.getSession(sessionToken);
        List<PersonPE> persons = null;
        PersonPE person = this.daoFactory.getPersonDAO().tryFindPersonByUserId(session.getUserName());
        if (person == null) {
            persons = this.daoFactory.getPersonDAO().listPersons();
            PersonPE systemUser = AbstractServer.getSystemUser(persons);
            DisplaySettings defaultDisplaySettings = this.getDefaultDisplaySettings(sessionToken);
            person = this.createPerson(session.getPrincipal(), systemUser, defaultDisplaySettings);
            roles = Collections.emptySet();
        } else {
            this.updatePersonIfNecessary(person, session.getPrincipal());
            roles = person.getAllPersonRoles();
            HibernateUtils.initialize(roles);
        }
        if (session.tryGetPerson() == null) {
            session.setPerson(person);
            session.setCreatorPerson(person);
            this.displaySettingsProvider.addDisplaySettingsForPerson(person);
        }
        if (roles.isEmpty()) {
            if (persons == null) {
                persons = this.daoFactory.getPersonDAO().listPersons();
            }
            if (this.isFirstLoggedUser(person, persons)) {
                this.grantRoleAtFirstLogin(persons, person, RoleWithHierarchy.RoleCode.ADMIN);
            } else if (this.isFirstLoggedETLServer(person, persons)) {
                this.grantRoleAtFirstLogin(persons, person, RoleWithHierarchy.RoleCode.ETL_SERVER);
            } else {
                throw this.createException(person, "has no role assignments");
            }
        }
        if (!person.isActive()) {
            throw this.createException(person, "has been deactivated");
        }
        this.removeNotExistingVisits(session);
        return this.asDTO(session);
    }

    private UserFailureException createException(PersonPE person, String reason) {
        String message = String.format("User '%s' %s and thus is not permitted to login.", person.getUserId(), reason);
        this.authenticationLog.info((Object)message);
        UserFailureException failureException = new UserFailureException(message);
        return failureException;
    }

    private void removeNotExistingVisits(Session session) {
        if (session == null || session.tryGetPerson() == null) {
            return;
        }
        DisplaySettings settings = session.tryGetPerson().getDisplaySettings();
        Iterator<EntityVisit> iterator = settings.getVisits().iterator();
        boolean changed = false;
        while (iterator.hasNext()) {
            EntityVisit visit = iterator.next();
            EntityKind kind = EntityKind.valueOf((String)visit.getEntityKind());
            IEntityWithMetaprojects entity = null;
            switch (kind) {
                case DATA_SET: {
                    entity = this.daoFactory.getDataDAO().tryToFindDataSetByCode(visit.getIdentifier());
                    break;
                }
                case EXPERIMENT: {
                    entity = this.daoFactory.getExperimentDAO().tryGetByPermID(visit.getPermID());
                    break;
                }
                case MATERIAL: {
                    entity = this.daoFactory.getMaterialDAO().tryFindMaterial(MaterialIdentifier.tryParseIdentifier(visit.getIdentifier()));
                    break;
                }
                case SAMPLE: {
                    entity = this.daoFactory.getSampleDAO().tryToFindByPermID(visit.getPermID());
                }
            }
            if (entity != null) continue;
            iterator.remove();
            changed = true;
        }
        if (changed) {
            this.daoFactory.getPersonDAO().updatePerson(session.tryGetPerson());
        }
    }

    private void grantRoleAtFirstLogin(List<PersonPE> persons, PersonPE person, RoleWithHierarchy.RoleCode roleCode) {
        PersonPE systemUser = AbstractServer.getSystemUser(persons);
        if (systemUser.getRoleAssignments().isEmpty()) {
            RoleAssignmentPE roleAssignment = this.createRoleAssigment(systemUser, person, roleCode);
            this.daoFactory.getRoleAssignmentDAO().createRoleAssignment(roleAssignment);
        }
    }

    private boolean isFirstLoggedUser(PersonPE newPerson, List<PersonPE> persons) {
        if (this.isETLServerUserId(newPerson)) {
            return false;
        }
        for (PersonPE person : persons) {
            if (person.isSystemUser() || this.isETLServerUserId(person)) continue;
            return false;
        }
        return true;
    }

    private boolean isFirstLoggedETLServer(PersonPE person, List<PersonPE> persons) {
        if (!this.isETLServerUserId(person)) {
            return false;
        }
        for (PersonPE existingPerson : persons) {
            if (!this.isETLServerUserId(existingPerson)) continue;
            return false;
        }
        return true;
    }

    private boolean isETLServerUserId(PersonPE person) {
        return person.getUserId().startsWith(ETL_SERVER_USERNAME_PREFIX);
    }

    private SessionContextDTO asDTO(Session session) {
        SessionContextDTO result = new SessionContextDTO();
        PersonPE person = session.tryGetPerson();
        assert (person != null) : "cannot obtain the person which is logged in";
        result.setDisplaySettings(this.displaySettingsProvider.getRegularDisplaySettings(person));
        SpacePE homeGroup = person.getHomeSpace();
        result.setHomeGroupCode(homeGroup == null ? null : homeGroup.getCode());
        result.setSessionExpirationTime(session.getSessionExpirationTime());
        result.setSessionToken(session.getSessionToken());
        result.setUserName(session.getUserName());
        result.setUserEmail(session.getUserEmail());
        result.setAnonymous(session.isAnonymous());
        result.setUserPersonObject(PersonTranslator.translate(person));
        result.setUserPersonRoles(PersonRolesTranslator.translate(person.getAllPersonRoles()));
        return result;
    }

    @Override
    public SessionContextDTO tryGetSession(String sessionToken) {
        try {
            Session session = (Session)this.sessionManager.getSession(sessionToken);
            return this.asDTO(session);
        }
        catch (InvalidSessionException ex) {
            return null;
        }
    }

    @Override
    public boolean isArchivingConfigured(String sessionToken) {
        List<DataStorePE> stores = this.daoFactory.getDataStoreDAO().listDataStores();
        for (DataStorePE store : stores) {
            if (!store.isArchiverConfigured()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isProjectSamplesEnabled(String sessionToken) {
        return SamplePE.projectSamplesEnabled;
    }

    @Override
    public boolean isProjectLevelAuthorizationEnabled(String sessionToken) {
        this.checkSession(sessionToken);
        return this.authorizationConfig.isProjectLevelEnabled();
    }

    @Override
    public boolean isProjectLevelAuthorizationUser(String sessionToken) {
        Session session = this.getSession(sessionToken);
        return this.authorizationConfig.isProjectLevelUser(session.getUserName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveDisplaySettings(String sessionToken, final DisplaySettings displaySettings, final int maxEntityVisits) {
        try {
            Session session;
            Session session2 = session = this.getSession(sessionToken);
            synchronized (session2) {
                PersonPE person = session.tryGetPerson();
                if (person != null) {
                    org.hibernate.Session hibernateSession = this.getDAOFactory().getSessionFactory().getCurrentSession();
                    final PersonPE attachedPerson = (PersonPE)hibernateSession.get(PersonPE.class, (Serializable)person.getId());
                    this.getDAOFactory().getPersonDAO().lock(attachedPerson);
                    this.displaySettingsProvider.executeActionWithPersonLock(attachedPerson, new IDelegatedActionWithResult<Void>(){

                        public Void execute(boolean didOperationSucceed) {
                            if (maxEntityVisits >= 0) {
                                List<EntityVisit> visits = displaySettings.getVisits();
                                AbstractServer.this.sortAndRemoveMultipleVisits(visits);
                                for (int i = visits.size() - 1; i >= maxEntityVisits; --i) {
                                    visits.remove(i);
                                }
                            }
                            AbstractServer.this.displaySettingsProvider.replaceRegularDisplaySettings(attachedPerson, displaySettings);
                            AbstractServer.this.getDAOFactory().getPersonDAO().updatePerson(attachedPerson);
                            return null;
                        }
                    });
                }
            }
        }
        catch (InvalidSessionException invalidSessionException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDisplaySettings(String sessionToken, final IDisplaySettingsUpdate displaySettingsUpdate) {
        if (displaySettingsUpdate == null) {
            throw new IllegalArgumentException("Display settings update cannot be null");
        }
        try {
            Session session;
            Session session2 = session = this.getSession(sessionToken);
            synchronized (session2) {
                PersonPE person = session.tryGetPerson();
                if (person != null) {
                    org.hibernate.Session hibernateSession = this.getDAOFactory().getSessionFactory().getCurrentSession();
                    final PersonPE attachedPerson = (PersonPE)hibernateSession.get(PersonPE.class, (Serializable)person.getId());
                    this.getDAOFactory().getPersonDAO().lock(attachedPerson);
                    this.displaySettingsProvider.executeActionWithPersonLock(attachedPerson, new IDelegatedActionWithResult<Void>(){

                        public Void execute(boolean didOperationSucceed) {
                            DisplaySettings currentDisplaySettings = AbstractServer.this.displaySettingsProvider.getCurrentDisplaySettings(attachedPerson);
                            DisplaySettings newDisplaySettings = displaySettingsUpdate.update(currentDisplaySettings);
                            AbstractServer.this.displaySettingsProvider.replaceCurrentDisplaySettings(attachedPerson, newDisplaySettings);
                            AbstractServer.this.getDAOFactory().getPersonDAO().updatePerson(attachedPerson);
                            return null;
                        }
                    });
                }
            }
        }
        catch (InvalidSessionException invalidSessionException) {
            // empty catch block
        }
    }

    private void sortAndRemoveMultipleVisits(List<EntityVisit> visits) {
        Collections.sort(visits, new EntityVisitComparatorByTimeStamp());
        HashSet<String> permIds = new HashSet<String>();
        Iterator<EntityVisit> iterator = visits.iterator();
        while (iterator.hasNext()) {
            EntityVisit entityVisit = iterator.next();
            String permID = entityVisit.getPermID();
            if (permIds.contains(permID)) {
                iterator.remove();
            }
            permIds.add(permID);
        }
    }

    @Override
    public DisplaySettings getDefaultDisplaySettings(String sessionToken) {
        PersonPE systemUser = this.getDAOFactory().getPersonDAO().tryFindPersonByUserId("system");
        if (systemUser == null) {
            throw new UserFailureException("Couldn't find system user with default settings in the DB.");
        }
        return systemUser.getDisplaySettings();
    }

    @Override
    public void changeUserHomeSpace(String sessionToken, TechId groupIdOrNull) {
        Session session = (Session)this.getSessionManager().getSession(sessionToken);
        PersonPE person = session.tryGetPerson();
        if (person != null) {
            SpacePE homeGroup = groupIdOrNull == null ? null : (SpacePE)this.getDAOFactory().getSpaceDAO().getByTechId(groupIdOrNull);
            person.setHomeSpace(homeGroup);
            this.getDAOFactory().getPersonDAO().updatePerson(person);
        }
    }

    @Override
    public void setBaseIndexURL(String sessionToken, String baseIndexURL) {
        Session session = (Session)this.getSessionManager().getSession(sessionToken);
        session.setBaseIndexURL(baseIndexURL);
    }

    @Override
    public String getBaseIndexURL(String sessionToken) {
        Session session = (Session)this.getSessionManager().getSession(sessionToken);
        return session.getBaseIndexURL();
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER})
    @ReturnValueFilter(validatorClass=ExpressionValidator.class)
    public List<GridCustomColumn> listGridCustomColumns(String sessionToken, String gridId) {
        Session session = this.getSession(sessionToken);
        List<GridCustomColumnPE> columnPEs = this.getDAOFactory().getGridCustomColumnDAO().listColumns(gridId);
        ArrayList<GridCustomColumn> result = new ArrayList<GridCustomColumn>();
        List<GridCustomColumn> columns = GridCustomExpressionTranslator.GridCustomColumnTranslator.translate(columnPEs);
        ExpressionValidator validator = new ExpressionValidator();
        PersonPE currentPerson = session.tryGetPerson();
        for (GridCustomColumn column : columns) {
            if (!validator.isValid(currentPerson, column)) continue;
            result.add(column);
        }
        return result;
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public void setSessionUser(String sessionToken, String userID) {
        Session session = this.getSession(sessionToken);
        String remoteHost = session.getRemoteHost();
        if (!this.remoteHostValidator.isValidRemoteHost(remoteHost)) {
            throw new UserFailureException("It is not allowed to change the user from remote host " + remoteHost);
        }
        this.injectPerson(session, userID);
    }

    protected void injectPerson(Session session, String personID) {
        PersonPE person = this.daoFactory.getPersonDAO().tryFindPersonByUserId(personID);
        if (person == null) {
            throw new UserFailureException("Unknown user: " + personID);
        }
        HibernateUtils.initialize(person.getAllPersonRoles());
        session.setPerson(person);
        session.setCreatorPerson(person);
        this.displaySettingsProvider.addDisplaySettingsForPerson(person);
    }

    protected void registerSamples(Session session, NewSamplesWithTypes newSamplesWithType, PersonPE registratorOrNull) {
        SampleType sampleType = (SampleType)newSamplesWithType.getEntityType();
        List<NewSample> newSamples = newSamplesWithType.getNewEntities();
        assert (sampleType != null) : "Unspecified sample type.";
        assert (newSamples != null) : "Unspecified new samples.";
        if (newSamples.size() == 0) {
            return;
        }
        AbstractServer.fillHomeSpace(newSamples, session.tryGetHomeGroupCode());
        ServerUtils.prevalidate(newSamples, "sample");
        String sampleTypeCode = sampleType.getCode();
        SampleTypePE sampleTypePE = this.getDAOFactory().getSampleTypeDAO().tryFindSampleTypeByCode(sampleTypeCode);
        if (sampleTypePE == null) {
            throw UserFailureException.fromTemplate((String)"Sample type with code '%s' does not exist.", (Object[])new Object[]{sampleTypeCode});
        }
        this.getPropertiesBatchManager().manageProperties(sampleTypePE, newSamples, registratorOrNull);
        this.getSampleTypeSlaveServerPlugin(sampleTypePE).registerSamples(session, newSamples, registratorOrNull);
    }

    protected static void fillHomeSpace(List<NewSample> samples, String homeSpaceOrNull) {
        if (homeSpaceOrNull == null) {
            return;
        }
        String spaceIdentifier = new SpaceIdentifier(homeSpaceOrNull).toString();
        for (NewSample sample : samples) {
            if (sample.getDefaultSpaceIdentifier() != null) continue;
            sample.setDefaultSpaceIdentifier(spaceIdentifier);
        }
    }

    protected void executeASync(String userEmail, final IASyncAction action) {
        MailClient mailClient = new MailClient(this.mailClientParameters);
        Runnable task = new Runnable((IMailClient)mailClient, userEmail){
            final /* synthetic */ IMailClient val$mailClient;
            final /* synthetic */ String val$userEmail;
            {
                this.val$mailClient = iMailClient;
                this.val$userEmail = string;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                StringWriter writer = new StringWriter();
                boolean success = true;
                Date startDate = new Date();
                try {
                    success = action.doAction(writer);
                }
                catch (RuntimeException e) {
                    try {
                        AbstractServer.this.operationLog.error((Object)("Asynchronous action '" + action.getName() + "' failed. "), (Throwable)e);
                        success = false;
                    }
                    catch (Throwable throwable) {
                        AbstractServer.this.sendEmail(this.val$mailClient, writer.toString(), AbstractServer.getSubject(action.getName(), startDate, success), this.val$userEmail);
                        throw throwable;
                    }
                    AbstractServer.this.sendEmail(this.val$mailClient, writer.toString(), AbstractServer.getSubject(action.getName(), startDate, success), this.val$userEmail);
                }
                AbstractServer.this.sendEmail(this.val$mailClient, writer.toString(), AbstractServer.getSubject(action.getName(), startDate, success), this.val$userEmail);
            }
        };
        executor.submit(task);
    }

    protected void sendEmail(IMailClient mailClient, String content, String subject, String ... recipient) {
        mailClient.sendMessage(subject, content, null, null, recipient);
    }

    private static String getSubject(String actionName, Date startDate, boolean success) {
        return AbstractServer.addDate(actionName + " " + (success ? "successfully performed" : "failed"), startDate);
    }

    private static String addDate(String subject, Date startDate) {
        return subject + " (initiated at " + startDate + ")";
    }

    static boolean isResolved(String name) {
        return StringUtils.isNotBlank((CharSequence)name) && !name.startsWith("${");
    }

    protected static String tryGetDisabledText() {
        if (!DefaultSessionManager.NO_LOGIN_FILE.exists()) {
            return null;
        }
        return FileUtilities.loadToString((File)DefaultSessionManager.NO_LOGIN_FILE).trim();
    }

    protected static final class AuthenticatedPersonBasedPrincipalProvider
    implements IPrincipalProvider {
        private final PersonPE person;

        AuthenticatedPersonBasedPrincipalProvider(PersonPE person) {
            this.person = person;
        }

        public Principal tryToGetPrincipal(String userID) {
            Principal result = new Principal(this.person.getUserId(), this.person.getFirstName(), this.person.getLastName(), this.person.getEmail(), true);
            result.setAnonymous(true);
            return result;
        }
    }
}

