/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.server.ConcurrentOperation;
import ch.systemsx.cisd.openbis.generic.server.ConcurrentOperationLimit;
import ch.systemsx.cisd.openbis.generic.server.ConcurrentOperationLimiterConfig;
import ch.systemsx.cisd.openbis.generic.server.IConcurrentOperationLimiter;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="concurrent-operation-limiter")
public class ConcurrentOperationLimiter
implements IConcurrentOperationLimiter {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, ConcurrentOperationLimiter.class);
    @Autowired
    private ConcurrentOperationLimiterConfig config;
    private Map<Pattern, Semaphore> semaphores;
    private Set<Thread> threads;

    private ConcurrentOperationLimiter() {
    }

    public ConcurrentOperationLimiter(ConcurrentOperationLimiterConfig config) {
        this.config = config;
        this.init();
    }

    @PostConstruct
    private void init() {
        LinkedHashMap<Pattern, Semaphore> semaphores = new LinkedHashMap<Pattern, Semaphore>();
        for (ConcurrentOperationLimit limit : this.config.getLimits()) {
            Semaphore semaphore = new Semaphore(limit.getLimit());
            Pattern pattern = Pattern.compile(limit.getOperation());
            semaphores.put(pattern, semaphore);
        }
        this.semaphores = semaphores;
        this.threads = new HashSet<Thread>();
    }

    @Override
    public <T> T executeLimitedWithTimeout(String operationName, ConcurrentOperation<T> operation) {
        return this.executeLimited(operationName, operation, this.config.getTimeout());
    }

    @Override
    public <T> T executeLimitedWithTimeoutAsync(String operationName, ConcurrentOperation<T> operation) {
        return this.executeLimited(operationName, operation, this.config.getTimeoutAsync());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T executeLimited(String operationName, ConcurrentOperation<T> operation, long timeout) {
        if (this.threads.contains(Thread.currentThread())) {
            return operation.execute();
        }
        Semaphore semaphore = this.getSemaphore(operationName);
        if (semaphore == null) {
            return operation.execute();
        }
        try {
            operationLog.info((Object)("Operation '" + operationName + "' will try to acquire an execution permit."));
            if (!semaphore.tryAcquire(timeout, TimeUnit.MILLISECONDS)) {
                operationLog.info((Object)("Operation '" + operationName + "' failed to acquire an execution permit within " + DurationFormatUtils.formatDuration((long)timeout, (String)"H:mm:ss.SSS") + "."));
                throw new UserFailureException("Sorry, the server is very loaded at the moment. Your request can not be currently processed. Please try again later.");
            }
            try {
                operationLog.info((Object)("Operation '" + operationName + "' successfully acquired an execution permit."));
                this.threads.add(Thread.currentThread());
                T t = operation.execute();
                return t;
            }
            finally {
                operationLog.info((Object)("Operation '" + operationName + "' released an execution permit."));
                this.threads.remove(Thread.currentThread());
                semaphore.release();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    private Semaphore getSemaphore(String operationName) {
        for (Map.Entry<Pattern, Semaphore> entry : this.semaphores.entrySet()) {
            if (!entry.getKey().matcher(operationName).matches()) continue;
            return entry.getValue();
        }
        return null;
    }
}

