/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.PropertyParametersUtil;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.spring.ExposablePropertyPlaceholderConfigurer;
import ch.systemsx.cisd.openbis.generic.server.ConcurrentOperationLimit;
import ch.systemsx.cisd.openbis.generic.server.ConcurrentOperationLimiter;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class ConcurrentOperationLimiterConfig {
    private static final String CONCURRENT_OPERATION_LIMITER_PROPERTY_PREFIX = "concurrent-operation-limiter";
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, ConcurrentOperationLimiter.class);
    private static final String TIMEOUT_PROPERTY = "timeout";
    private static final String TIMEOUT_ASYNC_PROPERTY = "timeout-async";
    private static final String LIMITS_PROPERTY = "limits";
    private static final String OPERATION_PROPERTY_SUFFIX = ".operation";
    private static final String LIMIT_PROPERTY_SUFFIX = ".limit";
    private static final long TIMEOUT_DEFAULT = 30000L;
    private static final long TIMEOUT_ASYNC_DEFAULT = 86400000L;
    private static final int LIMIT_DEFAULT = -1;
    @Resource(name="propertyConfigurer")
    private ExposablePropertyPlaceholderConfigurer configurer;
    private long timeout;
    private long timeoutAsync;
    private List<ConcurrentOperationLimit> limits;

    private ConcurrentOperationLimiterConfig() {
    }

    public ConcurrentOperationLimiterConfig(Properties properties) {
        this.init(properties);
    }

    @PostConstruct
    private void init() {
        this.init(this.configurer.getResolvedProps());
    }

    private void init(Properties allProperties) {
        long timeoutAsync;
        ArrayList<ConcurrentOperationLimit> limits = new ArrayList<ConcurrentOperationLimit>();
        Properties properties = PropertyParametersUtil.extractSingleSectionProperties((Properties)allProperties, (String)CONCURRENT_OPERATION_LIMITER_PROPERTY_PREFIX, (boolean)false).getProperties();
        for (String limitKey : PropertyUtils.getList((Properties)properties, (String)LIMITS_PROPERTY)) {
            String operation = PropertyUtils.getProperty((Properties)properties, (String)(limitKey + OPERATION_PROPERTY_SUFFIX));
            int limit = PropertyUtils.getInt((Properties)properties, (String)(limitKey + LIMIT_PROPERTY_SUFFIX), (int)-1);
            if (StringUtils.isBlank((CharSequence)operation) || limit <= 0) continue;
            limits.add(new ConcurrentOperationLimit(operation, limit));
            operationLog.info((Object)("Configured limit: " + limit + " for operation: " + operation));
        }
        long timeout = PropertyUtils.getLong((Properties)properties, (String)TIMEOUT_PROPERTY, (long)30000L);
        if (timeout <= 0L) {
            timeout = 30000L;
        }
        if ((timeoutAsync = PropertyUtils.getLong((Properties)properties, (String)TIMEOUT_ASYNC_PROPERTY, (long)86400000L)) <= 0L) {
            timeoutAsync = 86400000L;
        }
        operationLog.info((Object)("Configured timeout: " + DurationFormatUtils.formatDuration((long)timeout, (String)"H:mm:ss.SSS")));
        operationLog.info((Object)("Configured timeout async: " + DurationFormatUtils.formatDuration((long)timeoutAsync, (String)"H:mm:ss.SSS")));
        this.timeout = timeout;
        this.timeoutAsync = timeoutAsync;
        this.limits = limits;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public long getTimeoutAsync() {
        return this.timeoutAsync;
    }

    public List<ConcurrentOperationLimit> getLimits() {
        return this.limits;
    }
}

