/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server;

import ch.ethz.cisd.hotdeploy.PluginContainer;
import ch.ethz.cisd.hotdeploy.PluginDescriptor;
import ch.ethz.cisd.hotdeploy.PluginEvent;
import ch.ethz.cisd.hotdeploy.PluginMapHolder;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.server.ICommonServerForInternalUse;
import ch.systemsx.cisd.openbis.generic.server.IHotDeploymentController;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.IDynamicPropertyCalculatorFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.entity_validation.IEntityValidatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PluginType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Script;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ScriptType;
import ch.systemsx.cisd.openbis.generic.shared.dto.SessionContextDTO;
import ch.systemsx.cisd.openbis.generic.shared.hotdeploy_plugins.api.ICommonPropertyBasedHotDeployPlugin;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.translator.ScriptTranslator;
import java.io.File;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.transaction.annotation.Transactional;

public class HotDeploymentController
implements IHotDeploymentController {
    public static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, HotDeploymentController.class);
    private final PluginContainer pluginContainer;
    private ICommonServerForInternalUse commonServer;

    public HotDeploymentController(ICommonServerForInternalUse commonServer, IEntityValidatorFactory entityValidationFactory, IDynamicPropertyCalculatorFactory dynamicPropertyCalculatorFactory, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        this.commonServer = commonServer;
        PluginContainer.initHotDeployment();
        this.pluginContainer = PluginContainer.tryGetInstance();
        entityValidationFactory.initializeHotDeployment(this);
        dynamicPropertyCalculatorFactory.initializeHotDeployment(this);
        managedPropertyEvaluatorFactory.initializeHotDeployment(this);
    }

    @Override
    public void addPluginDirectory(File pluginDirectory) {
        this.pluginContainer.addPluginDirectory(pluginDirectory);
    }

    @Override
    public <T extends ICommonPropertyBasedHotDeployPlugin> PluginMapHolder<T> getPluginMap(Class<T> pluginClass) {
        return new PluginMapHolder(this.pluginContainer, pluginClass, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Transactional
    public void pluginChanged(PluginEvent event, ICommonPropertyBasedHotDeployPlugin plugin, ScriptType scriptType) {
        String pluginName = event.getPluginName();
        SessionContextDTO sessionCtx = this.commonServer.tryToAuthenticateAsSystem();
        if (sessionCtx == null) return;
        try {
            switch (event.getEventType()) {
                case REGISTER_NEW_PLUGIN: 
                case UPDATE_PLUGIN: {
                    Script script = new Script();
                    script.setName(pluginName);
                    script.setDescription(plugin.getDescription());
                    script.setScript(null);
                    script.setPluginType(PluginType.PREDEPLOYED);
                    script.setScriptType(scriptType);
                    script.setEntityKind(ScriptTranslator.translateEntityKinds(plugin.getSupportedEntityKinds()));
                    script.setAvailable(true);
                    this.commonServer.registerOrUpdatePredeployedPlugin(sessionCtx.getSessionToken(), script);
                    return;
                }
                case UNREGISTER_PLUGIN: {
                    this.commonServer.invalidatePredeployedPlugin(sessionCtx.getSessionToken(), pluginName, scriptType);
                    return;
                }
            }
            return;
        }
        finally {
            this.commonServer.logout(sessionCtx.getSessionToken());
        }
    }

    @Override
    public void disablePlugin(String pluginName) {
        PluginDescriptor pluginDescription = this.tryGetPlugin(pluginName);
        if (pluginDescription == null) {
            operationLog.warn((Object)("Couldn't disable unknown plugin: " + pluginName));
        } else {
            boolean success = this.pluginContainer.disablePlugin(pluginDescription.getPluginClass());
            if (success) {
                operationLog.info((Object)("Plugin '" + pluginName + "' successfully disabled."));
            } else {
                operationLog.warn((Object)("Disabling plugin '" + pluginName + "' failed."));
            }
        }
    }

    private PluginDescriptor tryGetPlugin(String pluginName) {
        List plugins = this.pluginContainer.getPlugins();
        for (PluginDescriptor pluginDescriptor : plugins) {
            if (!pluginDescriptor.getPluginName().equals(pluginName)) continue;
            return pluginDescriptor;
        }
        return null;
    }

    protected void setCommonServer(ICommonServerForInternalUse commonServer) {
        this.commonServer = commonServer;
    }
}

