/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.common.spring.IInvocationLoggerContext;
import ch.systemsx.cisd.openbis.common.spring.IInvocationLoggerFactory;
import ch.systemsx.cisd.openbis.generic.server.LongRunningThreadInterceptor;
import ch.systemsx.cisd.openbis.generic.server.LongRunningThreadLogConfiguration;
import java.lang.reflect.Method;
import java.util.Set;
import org.apache.log4j.Logger;

public class LongRunningThreadLogger
implements Runnable {
    private static final Logger logger = LogFactory.getLogger((LogCategory)LogCategory.ACCESS, LongRunningThreadLogger.class);
    private final LongRunningThreadLogConfiguration config;
    private final LongRunningThreadInterceptor interceptor;

    public LongRunningThreadLogger(LongRunningThreadInterceptor interceptor, LongRunningThreadLogConfiguration config) {
        this.interceptor = interceptor;
        this.config = config;
    }

    @Override
    public void run() {
        while (true) {
            Set<LongRunningThreadInterceptor.InvocationStart> invocations = this.interceptor.getInvocationsRunningLongerThan(this.config.maxValidInvocationLength());
            if (this.config.isLoggingEnabled()) {
                this.log(invocations);
            }
            try {
                Thread.sleep(this.config.logInterval());
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private void log(Set<LongRunningThreadInterceptor.InvocationStart> invocations) {
        if (invocations.size() != 0) {
            logger.warn((Object)"Long running invocation report");
            logger.warn((Object)"------------------------------");
            for (final LongRunningThreadInterceptor.InvocationStart invocation : invocations) {
                Object wrappedObject = invocation.invocation.getThis();
                if (!(wrappedObject instanceof IInvocationLoggerFactory)) continue;
                IInvocationLoggerFactory loggerFactory = (IInvocationLoggerFactory)wrappedObject;
                Object serviceLogger = loggerFactory.createLogger(new IInvocationLoggerContext(){

                    public String tryToGetSessionToken() {
                        return null;
                    }

                    public boolean invocationFinished() {
                        return false;
                    }

                    public boolean invocationWasSuccessful() {
                        return false;
                    }

                    public long getElapsedTime() {
                        return System.currentTimeMillis() - invocation.startTime;
                    }
                });
                Method method = invocation.invocation.getMethod();
                long duration = (System.currentTimeMillis() - invocation.startTime) / 1000L;
                logger.warn((Object)("Thread " + invocation.threadName + " has been executing " + method.getDeclaringClass().getCanonicalName() + "." + method.getName() + " for " + String.format("%d:%02d:%02d", duration / 3600L, duration % 3600L / 60L, duration % 60L)));
                try {
                    method.invoke(serviceLogger, invocation.invocation.getArguments());
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
            logger.info((Object)"-----------");
        }
    }
}

