/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server;

import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.operation.config.IOperationExecutionConfig;
import ch.ethz.sis.openbis.generic.server.asapi.v3.task.OperationExecutionMarkFailedAfterServerRestartMaintenanceTask;
import ch.ethz.sis.openbis.generic.server.asapi.v3.task.OperationExecutionMarkTimeOutPendingMaintenanceTask;
import ch.ethz.sis.openbis.generic.server.asapi.v3.task.OperationExecutionMarkTimedOutOrDeletedMaintenanceTask;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.maintenance.MaintenancePlugin;
import ch.systemsx.cisd.common.maintenance.MaintenanceTaskParameters;
import ch.systemsx.cisd.common.maintenance.MaintenanceTaskUtils;
import ch.systemsx.cisd.common.spring.ExposablePropertyPlaceholderConfigurer;
import ch.systemsx.cisd.openbis.generic.server.CommonServiceProvider;
import ch.systemsx.cisd.openbis.generic.server.task.CacheClearanceMaintenanceTask;
import ch.systemsx.cisd.openbis.generic.server.task.SessionWorkspaceCleanUpMaintenanceTask;
import ch.systemsx.cisd.openbis.generic.server.task.StatisticsCollectionMaintenanceTask;
import ch.systemsx.cisd.openbis.generic.server.task.events_search.EventsSearchMaintenanceTask;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class MaintenanceTaskStarter
implements ApplicationContextAware,
InitializingBean,
DisposableBean {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, MaintenanceTaskStarter.class);
    @Resource(name="propertyConfigurer")
    private ExposablePropertyPlaceholderConfigurer configurer;
    @Autowired
    private IOperationExecutionConfig operationExecutionConfig;
    private List<MaintenancePlugin> plugins;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        CommonServiceProvider.setApplicationContext(applicationContext);
    }

    public void afterPropertiesSet() throws Exception {
        MaintenanceTaskParameters[] tasks = MaintenanceTaskUtils.createMaintenancePlugins((Properties)this.configurer.getResolvedProps());
        if (!this.isTaskConfigured(tasks, OperationExecutionMarkFailedAfterServerRestartMaintenanceTask.class)) {
            tasks = this.addTask(tasks, OperationExecutionMarkFailedAfterServerRestartMaintenanceTask.class, this.operationExecutionConfig.getMarkFailedAfterServerRestartTaskName(), true, null);
        }
        if (!this.isTaskConfigured(tasks, OperationExecutionMarkTimeOutPendingMaintenanceTask.class)) {
            tasks = this.addTask(tasks, OperationExecutionMarkTimeOutPendingMaintenanceTask.class, this.operationExecutionConfig.getMarkTimeOutPendingTaskName(), false, this.operationExecutionConfig.getMarkTimeOutPendingTaskInterval());
        }
        if (!this.isTaskConfigured(tasks, OperationExecutionMarkTimedOutOrDeletedMaintenanceTask.class)) {
            tasks = this.addTask(tasks, OperationExecutionMarkTimedOutOrDeletedMaintenanceTask.class, this.operationExecutionConfig.getMarkTimedOutOrDeletedTaskName(), false, this.operationExecutionConfig.getMarkTimedOutOrDeletedTaskInterval());
        }
        if (!this.isTaskConfigured(tasks, SessionWorkspaceCleanUpMaintenanceTask.class)) {
            tasks = this.addTask(tasks, SessionWorkspaceCleanUpMaintenanceTask.class, "session-workspace-clean-up-task", false, 3600);
        }
        if (!this.isTaskConfigured(tasks, StatisticsCollectionMaintenanceTask.class)) {
            tasks = this.addTask(tasks, StatisticsCollectionMaintenanceTask.class, "statistics-collection-task", false, 86400);
        }
        if (!this.isTaskConfigured(tasks, CacheClearanceMaintenanceTask.class)) {
            tasks = this.addTask(tasks, CacheClearanceMaintenanceTask.class, this.operationExecutionConfig.getCacheClearanceTaskName(), false, this.operationExecutionConfig.getCacheClearanceTaskInterval());
        }
        if (!this.isTaskConfigured(tasks, EventsSearchMaintenanceTask.class)) {
            tasks = this.addTask(tasks, EventsSearchMaintenanceTask.class, "events-search-task", false, 900);
        }
        this.plugins = MaintenanceTaskUtils.startupMaintenancePlugins((MaintenanceTaskParameters[])tasks);
    }

    private boolean isTaskConfigured(MaintenanceTaskParameters[] tasks, Class<?> clazz) {
        for (MaintenanceTaskParameters task : tasks) {
            if (!clazz.getName().equals(task.getClassName())) continue;
            return true;
        }
        return false;
    }

    private MaintenanceTaskParameters[] addTask(MaintenanceTaskParameters[] tasks, Class<?> clazz, String name, boolean executeOnce, Integer intervalOrNull) {
        Properties properties = new Properties();
        properties.setProperty("class", clazz.getName());
        properties.setProperty("execute-only-once", String.valueOf(executeOnce));
        if (intervalOrNull != null) {
            properties.setProperty("interval", String.valueOf(intervalOrNull));
        }
        if (operationLog.isInfoEnabled()) {
            StringBuilder message = new StringBuilder();
            message.append("Automatically adding maintenance task '" + name + "' (");
            message.append("class: " + clazz.getName());
            message.append(", executeOnce: " + executeOnce);
            if (intervalOrNull != null) {
                message.append(", interval: " + intervalOrNull);
            }
            message.append(")");
            operationLog.info((Object)message.toString());
        }
        ArrayList<MaintenanceTaskParameters> tasksList = new ArrayList<MaintenanceTaskParameters>(Arrays.asList(tasks));
        tasksList.add(new MaintenanceTaskParameters(properties, name));
        return tasksList.toArray(new MaintenanceTaskParameters[0]);
    }

    public void destroy() throws Exception {
        MaintenanceTaskUtils.shutdownMaintenancePlugins(this.plugins);
    }

    public List<MaintenancePlugin> getPlugins() {
        return Collections.unmodifiableList(this.plugins);
    }
}

