/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server;

import ch.systemsx.cisd.openbis.generic.server.EntityGroupingDAG;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewMaterialWithType;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MaterialGroupingDAG
extends EntityGroupingDAG<NewMaterialWithType> {
    private Map<String, Set<String>> typesWithMaterialProperty;

    private MaterialGroupingDAG(Collection<NewMaterialWithType> materials, Map<String, Set<String>> typesWithMaterialProperty) {
        super(materials);
        this.typesWithMaterialProperty = typesWithMaterialProperty;
    }

    public static List<List<NewMaterialWithType>> groupByDepencies(Collection<NewMaterialWithType> materials, Map<String, Set<String>> typesWithMaterialProperty) {
        if (materials.size() == 0) {
            return Collections.emptyList();
        }
        MaterialGroupingDAG dag = new MaterialGroupingDAG(materials, typesWithMaterialProperty);
        return dag.getDependencyGroups();
    }

    @Override
    public String getCode(NewMaterialWithType material) {
        return MaterialIdentifier.toString(material.getCode(), material.getType());
    }

    @Override
    public Collection<String> getDependent(NewMaterialWithType sample) {
        return null;
    }

    @Override
    public Collection<String> getDependencies(NewMaterialWithType newMaterial) {
        IEntityProperty[] properties;
        LinkedList<String> relatedMaterials = null;
        for (IEntityProperty iEntityProperty : properties = newMaterial.getProperties()) {
            if (relatedMaterials == null) {
                relatedMaterials = new LinkedList<String>();
            }
            if (!this.typesWithMaterialProperty.get(newMaterial.getType()).contains(iEntityProperty.getPropertyType().getCode())) continue;
            relatedMaterials.add(iEntityProperty.getValue());
        }
        return relatedMaterials;
    }
}

