/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server;

import ch.systemsx.cisd.authentication.DefaultSessionManager;
import ch.systemsx.cisd.authentication.IAuthenticationService;
import ch.systemsx.cisd.authentication.ILogMessagePrefixGenerator;
import ch.systemsx.cisd.authentication.ISessionFactory;
import ch.systemsx.cisd.common.server.IRemoteHostProvider;
import ch.systemsx.cisd.openbis.generic.server.AbstractServer;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IPersonDAO;
import ch.systemsx.cisd.openbis.generic.shared.IOpenBisSessionManager;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class OpenBisSessionManager
extends DefaultSessionManager<Session>
implements IOpenBisSessionManager {
    private static final int DEFAULT_SESSION_EXPIRATION_PERIOD_FOR_NO_LOGIN = 10;
    IDAOFactory daoFactory;
    private String userForAnonymousLogin;
    private int maxNumberOfSessionsPerUser;
    private Set<String> usersWithUnrestrictedNumberOfSessions = new HashSet<String>();

    private static final int parseAsIntOrReturnDefaultValue(String string, int defaultValue) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public OpenBisSessionManager(ISessionFactory<Session> sessionFactory, ILogMessagePrefixGenerator<Session> prefixGenerator, IAuthenticationService authenticationService, IRemoteHostProvider remoteHostProvider, int sessionExpirationPeriodMinutes, String sessionExpirationPeriodMinutesForNoLogin, boolean tryEmailAsUserName, IDAOFactory daoFactory) {
        super(sessionFactory, prefixGenerator, authenticationService, remoteHostProvider, sessionExpirationPeriodMinutes, OpenBisSessionManager.parseAsIntOrReturnDefaultValue(sessionExpirationPeriodMinutesForNoLogin, 10), tryEmailAsUserName);
        this.daoFactory = daoFactory;
    }

    public OpenBisSessionManager(ISessionFactory<Session> sessionFactory, ILogMessagePrefixGenerator<Session> prefixGenerator, IAuthenticationService authenticationService, IRemoteHostProvider remoteHostProvider, int sessionExpirationPeriodMinutes, String sessionExpirationPeriodMinutesForNoLogin, IDAOFactory daoFactory) {
        this(sessionFactory, prefixGenerator, authenticationService, remoteHostProvider, sessionExpirationPeriodMinutes, sessionExpirationPeriodMinutesForNoLogin, false, daoFactory);
    }

    protected int getMaxNumberOfSessionsFor(String user) {
        if (this.usersWithUnrestrictedNumberOfSessions.contains(user)) {
            return 0;
        }
        PersonPE person = this.daoFactory.getPersonDAO().tryFindPersonByUserId(user);
        if (person != null && person.isSystemUser()) {
            return 0;
        }
        return this.maxNumberOfSessionsPerUser;
    }

    public void setMaxNumberOfSessionsPerUser(String number) {
        this.maxNumberOfSessionsPerUser = OpenBisSessionManager.parseAsIntOrReturnDefaultValue(number, 5);
    }

    public void setUsersWithUnrestrictedNumberOfSessions(String users) {
        if (!users.startsWith("${")) {
            for (String user : users.split(",")) {
                this.usersWithUnrestrictedNumberOfSessions.add(user.trim());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAllSessions() {
        Map map = this.sessions;
        synchronized (map) {
            for (DefaultSessionManager.FullSession fullSession : this.sessions.values()) {
                Session session;
                Session session2 = session = (Session)fullSession.getSession();
                synchronized (session2) {
                    IPersonDAO personDAO;
                    PersonPE person;
                    PersonPE oldPerson = session.tryGetPerson();
                    if (oldPerson != null && !oldPerson.isSystemUser() && (person = (PersonPE)(personDAO = this.daoFactory.getPersonDAO()).tryGetByTechId(new TechId(oldPerson.getId()), new String[0])) != null) {
                        HibernateUtils.initialize(person.getAllPersonRoles());
                        session.setPerson(person);
                        session.setCreatorPerson(person);
                    }
                }
            }
        }
    }

    public final void setUserForAnonymousLogin(String userID) {
        this.userForAnonymousLogin = AbstractServer.isResolved(userID) ? userID : null;
    }

    @Override
    public String getUserForAnonymousLogin() {
        return this.userForAnonymousLogin;
    }
}

