/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server;

import ch.systemsx.cisd.common.servlet.AbstractCrossOriginFilter;
import ch.systemsx.cisd.openbis.generic.server.ICommonServerForInternalUse;
import ch.systemsx.cisd.openbis.generic.server.TrustedCrossOriginDomainsProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataStore;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletContext;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class OpenbisCrossOriginFilter
extends AbstractCrossOriginFilter {
    private List<String> ownDomains;
    private List<String> trustedDomains;

    protected List<String> getOwnDomains() {
        this.initializeIfNeeded();
        return Collections.unmodifiableList(this.ownDomains);
    }

    protected List<String> getConfiguredTrustedDomains() {
        this.initializeIfNeeded();
        return Collections.unmodifiableList(this.trustedDomains);
    }

    private void initializeIfNeeded() {
        if (this.ownDomains != null) {
            return;
        }
        WebApplicationContext appContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        this.ownDomains = this.getDssDomains((ApplicationContext)appContext);
        this.trustedDomains = this.getTrustedDomains((ApplicationContext)appContext);
    }

    private List<String> getDssDomains(ApplicationContext appContext) {
        ArrayList<String> dataStoreServerUrls = new ArrayList<String>();
        ICommonServerForInternalUse commonServer = (ICommonServerForInternalUse)appContext.getBean("common-server");
        List<DataStore> dataStores = commonServer.listDataStores();
        for (DataStore dataStore : dataStores) {
            String dssDomainOrNull = this.tryExtractDomainFromDownloadUrl(dataStore);
            if (dssDomainOrNull == null) continue;
            dataStoreServerUrls.add(dssDomainOrNull);
        }
        return dataStoreServerUrls;
    }

    protected String tryExtractDomainFromDownloadUrl(DataStore dataStore) {
        try {
            URL url = new URL(dataStore.getDownloadUrl());
            return url.getProtocol() + "://" + url.getAuthority();
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    private List<String> getTrustedDomains(ApplicationContext appContext) {
        TrustedCrossOriginDomainsProvider trustedDomainsProvider = (TrustedCrossOriginDomainsProvider)appContext.getBean("trusted-origin-domain-provider");
        return trustedDomainsProvider.getTrustedDomains();
    }
}

