/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server;

import ch.systemsx.cisd.common.exceptions.ExceptionUtils;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.shared.IServer;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.log4j.Logger;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.MethodMatcher;
import org.springframework.aop.Pointcut;
import org.springframework.aop.framework.ReflectiveMethodInvocation;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.aop.support.RootClassFilter;
import org.springframework.dao.DeadlockLoserDataAccessException;
import org.springframework.orm.hibernate5.HibernateOptimisticLockingFailureException;

public class OptimisticLockingRetryAdvisor
extends DefaultPointcutAdvisor {
    private static final long serialVersionUID = 1L;
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, OptimisticLockingRetryAdvisor.class);

    public OptimisticLockingRetryAdvisor() {
        super((Pointcut)new AllServerMethodsPointcut(), (Advice)new RetryInterceptor());
        this.setOrder(-2147483647);
    }

    private static class RetryInterceptor
    implements MethodInterceptor {
        private static final int MAX_WAITING_TIME_FOR_RETRY = 5000;
        private static final int NUMBER_OF_TRIES = 5;

        private RetryInterceptor() {
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            Exception latestException = new IllegalStateException();
            for (int i = 0; i < 5; ++i) {
                try {
                    if (invocation instanceof ReflectiveMethodInvocation) {
                        return ((ReflectiveMethodInvocation)invocation).invocableClone().proceed();
                    }
                    return invocation.proceed();
                }
                catch (Exception ex) {
                    boolean retry;
                    latestException = ex;
                    if (!this.causedByOptimisticLockingOrDeadlockLoserException(ex)) {
                        throw ex;
                    }
                    boolean bl = retry = i < 4;
                    if (retry) {
                        operationLog.info((Object)("Retry after the " + (i + 1) + ". failed invocation of " + invocation.getMethod()));
                        try {
                            Thread.sleep((int)(Math.random() * 5000.0));
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    operationLog.error((Object)("Giving up after " + (i + 1) + ". failed invocation of " + invocation.getMethod() + ". Reason: " + ex));
                    continue;
                }
            }
            throw latestException;
        }

        private boolean causedByOptimisticLockingOrDeadlockLoserException(Exception ex) {
            HibernateOptimisticLockingFailureException optimisticLockingException = (HibernateOptimisticLockingFailureException)ExceptionUtils.tryGetThrowableOfClass((Throwable)ex, HibernateOptimisticLockingFailureException.class);
            if (optimisticLockingException != null) {
                return true;
            }
            DeadlockLoserDataAccessException deadlockLoserException = (DeadlockLoserDataAccessException)ExceptionUtils.tryGetThrowableOfClass((Throwable)ex, DeadlockLoserDataAccessException.class);
            return deadlockLoserException != null;
        }
    }

    private static class AllServerMethodsPointcut
    implements Pointcut {
        private AllServerMethodsPointcut() {
        }

        public MethodMatcher getMethodMatcher() {
            return MethodMatcher.TRUE;
        }

        public ClassFilter getClassFilter() {
            return new RootClassFilter(IServer.class);
        }
    }
}

