/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server;

import ch.systemsx.cisd.openbis.generic.server.EntityGroupingDAG;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class SampleGroupingDAG
extends EntityGroupingDAG<NewSample> {
    private SampleGroupingDAG(Collection<NewSample> samples) {
        super(samples);
    }

    public static List<List<NewSample>> groupByDepencies(Collection<NewSample> samples) {
        if (samples.size() == 0) {
            return Collections.emptyList();
        }
        SampleGroupingDAG dag = new SampleGroupingDAG(samples);
        return dag.getDependencyGroups();
    }

    @Override
    public String getCode(NewSample sample) {
        return sample.getIdentifier();
    }

    @Override
    public Collection<String> getDependent(NewSample sample) {
        return null;
    }

    @Override
    public Collection<String> getDependencies(NewSample sample) {
        String[] parents;
        LinkedList<String> parentsAndContainers = null;
        if (sample.getContainerIdentifier() != null) {
            parentsAndContainers = new LinkedList<String>();
            parentsAndContainers.add(sample.getContainerIdentifier());
        }
        if ((parents = sample.getParentsOrNull()) != null && parents.length > 0) {
            if (parentsAndContainers == null) {
                parentsAndContainers = new LinkedList();
            }
            for (String parent : parents) {
                parentsAndContainers.add(parent);
            }
        }
        return parentsAndContainers;
    }
}

