/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.IServer;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.postgresql.util.PSQLException;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.MethodMatcher;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.aop.support.RootClassFilter;
import org.springframework.core.NestedRuntimeException;
import org.springframework.dao.DataAccessException;
import org.springframework.transaction.TransactionSystemException;

public class ServerExceptionTranslatingAdvisor
extends DefaultPointcutAdvisor {
    private static final long serialVersionUID = 1L;

    public ServerExceptionTranslatingAdvisor() {
        super((Pointcut)new AllServerMethodsPointcut(), (Advice)new UserFailureExceptionTranslatingInterceptor());
    }

    private static class UserFailureExceptionTranslatingInterceptor
    implements MethodInterceptor {
        private UserFailureExceptionTranslatingInterceptor() {
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            try {
                return invocation.proceed();
            }
            catch (NestedRuntimeException ex) {
                if (ex instanceof TransactionSystemException || ex instanceof DataAccessException) {
                    int indexOfWhere;
                    Throwable cause = ex.getMostSpecificCause();
                    String message = cause.getMessage();
                    if (cause instanceof PSQLException && (indexOfWhere = message.indexOf("Where: PL/pgSQL")) > 0) {
                        message = message.substring(0, indexOfWhere).trim();
                    }
                    throw new UserFailureException(message, (Throwable)ex);
                }
                throw ex;
            }
        }
    }

    private static class AllServerMethodsPointcut
    implements Pointcut {
        private AllServerMethodsPointcut() {
        }

        public MethodMatcher getMethodMatcher() {
            return MethodMatcher.TRUE;
        }

        public ClassFilter getClassFilter() {
            return new RootClassFilter(IServer.class);
        }
    }
}

