/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server;

import ch.systemsx.cisd.openbis.common.conversation.client.ServiceConversationClientDetails;
import ch.systemsx.cisd.openbis.common.conversation.manager.BaseServiceConversationServerManager;
import ch.systemsx.cisd.openbis.generic.server.business.IServiceConversationServerManagerLocal;
import ch.systemsx.cisd.openbis.generic.shared.IServiceForDataStoreServer;
import ch.systemsx.cisd.openbis.generic.shared.conversation.ServiceConversationDataStoreClientId;
import ch.systemsx.cisd.openbis.generic.shared.conversation.ServiceConversationDataStoreUrl;
import java.util.HashMap;
import java.util.Map;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.InitializingBean;

public class ServiceConversationServerManager
extends BaseServiceConversationServerManager
implements IServiceConversationServerManagerLocal,
InitializingBean {
    private Map<Object, ServiceConversationClientDetails> dataStoreIdToDataStoreDetailsMap = new HashMap<Object, ServiceConversationClientDetails>();
    private IServiceForDataStoreServer etlService;

    public void afterPropertiesSet() throws Exception {
        this.addService(IServiceForDataStoreServer.class, this.etlService);
    }

    protected ServiceConversationClientDetails getClientDetailsForClientId(Object clientId) {
        if (clientId instanceof ServiceConversationDataStoreClientId) {
            return this.dataStoreIdToDataStoreDetailsMap.get(clientId);
        }
        return null;
    }

    @Override
    public void setDataStoreInformation(String dataStoreCode, String dataStoreUrl, int dataStoreTimeoutInMinutes) {
        String dataStoreClientUrl = new ServiceConversationDataStoreUrl(dataStoreUrl).getClientUrl();
        int dataStoreTimeoutInMillis = dataStoreTimeoutInMinutes * 60 * 1000;
        this.dataStoreIdToDataStoreDetailsMap.put(new ServiceConversationDataStoreClientId(dataStoreCode), new ServiceConversationClientDetails(dataStoreClientUrl, dataStoreTimeoutInMillis));
    }

    public void setEtlService(IServiceForDataStoreServer etlService) {
        ProxyFactory factory = new ProxyFactory((Object)etlService);
        this.etlService = (IServiceForDataStoreServer)factory.getProxy();
    }
}

