/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server;

import ch.systemsx.cisd.authentication.ISessionFactory;
import ch.systemsx.cisd.authentication.Principal;
import ch.systemsx.cisd.base.exceptions.InterruptedExceptionUnchecked;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.logging.LogLevel;
import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.server.business.IDataStoreServiceFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDataStoreDAO;
import ch.systemsx.cisd.openbis.generic.shared.ISessionWorkspaceProvider;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataStorePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;

public final class SessionFactory
implements ISessionFactory<Session> {
    private static final BlockingQueue<CleanUpTask> sessionsToBeClosedQueue = new LinkedBlockingQueue<CleanUpTask>();
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, SessionFactory.class);
    private final IDataStoreDAO datastoreDAO;
    private final IDataStoreServiceFactory dssFactory;
    private final ISessionWorkspaceProvider sessionWorkspaceProvider;

    public SessionFactory() {
        this(null, null, null);
    }

    public SessionFactory(IDAOFactory daoFactory, IDataStoreServiceFactory dssFactory, ISessionWorkspaceProvider sessionWorkspaceProvider) {
        this.datastoreDAO = daoFactory != null ? daoFactory.getDataStoreDAO() : null;
        this.dssFactory = dssFactory;
        this.sessionWorkspaceProvider = sessionWorkspaceProvider;
    }

    public final Session create(final String sessionToken, String userName, Principal principal, String remoteHost, long sessionStart, int expirationTime) {
        Session session = new Session(userName, sessionToken, principal, remoteHost, sessionStart, expirationTime);
        if (this.datastoreDAO != null && this.dssFactory != null) {
            session.addCleanupListener(new Session.ISessionCleaner(){

                @Override
                public void cleanup() {
                    SessionFactory.this.sessionWorkspaceProvider.deleteSessionWorkspace(sessionToken);
                    SessionFactory.cleanUpSessionOnDataStoreServers(sessionToken, SessionFactory.this.datastoreDAO, SessionFactory.this.dssFactory);
                }
            });
        }
        return session;
    }

    public static void cleanUpSessionOnDataStoreServers(String sessionToken, IDataStoreDAO datastoreDAO, IDataStoreServiceFactory dssFactory) {
        for (DataStorePE datastore : datastoreDAO.listDataStores()) {
            String remoteUrl = datastore.getRemoteUrl();
            if (!StringUtils.isBlank((String)remoteUrl)) {
                sessionsToBeClosedQueue.add(new CleanUpTask(dssFactory, remoteUrl, sessionToken));
                continue;
            }
            operationLog.warn((Object)("datastore remoteUrl of datastore " + datastore.getCode() + " is empty - skipping DSS session cleanup."));
        }
    }

    static {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            CleanUpTask task = (CleanUpTask)sessionsToBeClosedQueue.take();
                            task.execute();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    catch (InterruptedExceptionUnchecked interruptedExceptionUnchecked) {
                        continue;
                    }
                    break;
                }
            }
        }, "Session clean up queue");
        thread.setDaemon(true);
        thread.start();
    }

    private static final class CleanUpTask {
        private IDataStoreServiceFactory dssFactory;
        private String remoteUrl;
        private String sessionToken;

        CleanUpTask(IDataStoreServiceFactory dssFactory, String remoteUrl, String sessionToken) {
            this.dssFactory = dssFactory;
            this.remoteUrl = remoteUrl;
            this.sessionToken = sessionToken;
        }

        void execute() {
            try {
                operationLog.info((Object)("Execute clean-up task for session " + this.sessionToken + " on DSS " + this.remoteUrl));
                this.dssFactory.createMonitored(this.remoteUrl, LogLevel.WARN).cleanupSession(this.sessionToken);
                operationLog.info((Object)("Clean-up task for session " + this.sessionToken + " finished on DSS " + this.remoteUrl));
            }
            catch (Exception e) {
                operationLog.error((Object)("Clean-up task for session " + this.sessionToken + " failed on DSS " + this.remoteUrl + ". Reason: " + e), (Throwable)e);
            }
        }
    }
}

