/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.api.v1;

import ch.systemsx.cisd.authentication.ISessionManager;
import ch.systemsx.cisd.openbis.common.spring.IInvocationLoggerContext;
import ch.systemsx.cisd.openbis.generic.shared.AbstractServerLogger;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.IGeneralInformationChangingService;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DeletionType;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.MetaprojectAssignmentsIds;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.NewVocabularyTerm;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.WebAppSettings;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.metaproject.IMetaprojectId;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Metaproject;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import java.util.List;
import java.util.Map;

class GeneralInformationChangingServiceLogger
extends AbstractServerLogger
implements IGeneralInformationChangingService {
    public GeneralInformationChangingServiceLogger(ISessionManager<Session> sessionManagerNull, IInvocationLoggerContext context) {
        super(sessionManagerNull, context);
    }

    public void updateSampleProperties(String sessionToken, long sampleID, Map<String, String> properties) {
        this.logTracking(sessionToken, "update-sample-properties", "SAMPLE(%s)", sampleID);
    }

    public void addUnofficialVocabularyTerm(String sessionToken, TechId vocabularyId, String code, String label, String description, Long previousTermOrdinal) {
        this.logTracking(sessionToken, "add_unofficial_vocabulary_term", "ID(%s) CODE(%s), LABEL(%s), DESCRIPTION(%s), PREVIOUS_ORDINAL(%s)", vocabularyId, code, label, description, Long.toString(previousTermOrdinal));
    }

    public void addUnofficialVocabularyTerm(String sessionToken, Long vocabularyId, NewVocabularyTerm term) {
        this.logTracking(sessionToken, "add-unofficial-vocabulary-term", "VOCABULARY_ID(%s) TERM(%s)", vocabularyId, term);
    }

    public WebAppSettings getWebAppSettings(String sessionToken, String webAppId) {
        this.logAccess(sessionToken, "get-custom-display-settings", "WEB_APP_ID(%s)", webAppId);
        return null;
    }

    public void setWebAppSettings(String sessionToken, WebAppSettings webAppSettings) {
        this.logAccess(sessionToken, "set-custom-display-settings", "WEB_APP_ID(%s)", webAppSettings.getWebAppId());
    }

    public Metaproject createMetaproject(String sessionToken, String name, String description) {
        this.logAccess(sessionToken, "createMetaproject", "NAME(%s) DESCRIPTION(%s)", name, description);
        return null;
    }

    public Metaproject updateMetaproject(String sessionToken, IMetaprojectId metaprojectId, String name, String descriptionOrNull) {
        this.logAccess(sessionToken, "updateMetaproject", "METAPROJECT_ID(%s) NAME(%s) DESCRIPTION(%s)", metaprojectId, name, descriptionOrNull);
        return null;
    }

    public void deleteMetaproject(String sessionToken, IMetaprojectId metaprojectId) {
        this.logAccess(sessionToken, "deleteMetaproject", "METAPROJECT_ID(%s)", metaprojectId);
    }

    public void addToMetaproject(String sessionToken, IMetaprojectId metaprojectId, MetaprojectAssignmentsIds assignmentsToAdd) {
        MetaprojectAssignmentsIds assignments = assignmentsToAdd != null ? assignmentsToAdd : new MetaprojectAssignmentsIds();
        this.logAccess(sessionToken, "addToMetaproject", "METAPROJECT_ID(%s), EXPERIMENTS(%s), SAMPLES(%s), DATA_SETS(%s), MATERIALS(%s)", metaprojectId, this.abbreviate(assignments.getExperiments()), this.abbreviate(assignments.getSamples()), this.abbreviate(assignments.getDataSets()), this.abbreviate(assignments.getMaterials()));
    }

    public void removeFromMetaproject(String sessionToken, IMetaprojectId metaprojectId, MetaprojectAssignmentsIds assignmentsToRemove) {
        MetaprojectAssignmentsIds assignments = assignmentsToRemove != null ? assignmentsToRemove : new MetaprojectAssignmentsIds();
        this.logAccess(sessionToken, "removeFromMetaproject", "METAPROJECT_ID(%s), EXPERIMENTS(%s), SAMPLES(%s), DATA_SETS(%s), MATERIALS(%s)", metaprojectId, this.abbreviate(assignments.getExperiments()), this.abbreviate(assignments.getSamples()), this.abbreviate(assignments.getDataSets()), this.abbreviate(assignments.getMaterials()));
    }

    public String registerSamplesWithSilentOverrides(String sessionToken, String sampleTypeCode, String spaceIdentifierSilentOverrideOrNull, String experimentIdentifierSilentOverrideOrNull, String sessionKey, String defaultGroupIdentifier) {
        this.logAccess(sessionToken, "registerSamplesWithSilentOverrides", "sampleTypeCode(%s), sessionKey(%s), spaceIdentifierSilentOverrideOrNull(%s), experimentIdentifierSilentOverrideOrNull(%s), defaultGroupIdentifier(%s)", sampleTypeCode, spaceIdentifierSilentOverrideOrNull, experimentIdentifierSilentOverrideOrNull, sessionKey, defaultGroupIdentifier);
        return null;
    }

    public String registerSamples(String sessionToken, String sampleTypeCode, String sessionKey, String defaultGroupIdentifier) {
        this.logAccess(sessionToken, "registerSamples", "sampleTypeCode(%s), sessionKey(%s), defaultGroupIdentifier(%s)", sampleTypeCode, sessionKey, defaultGroupIdentifier);
        return null;
    }

    public String updateSamplesWithSilentOverrides(String sessionToken, String sampleTypeCode, String spaceIdentifierSilentOverrideOrNull, String experimentIdentifierSilentOverrideOrNull, String sessionKey, String defaultGroupIdentifier) {
        this.logAccess(sessionToken, "updateSamplesWithSilentOverrides", "sampleTypeCode(%s), sessionKey(%s), spaceIdentifierSilentOverrideOrNull(%s), experimentIdentifierSilentOverrideOrNull(%s), defaultGroupIdentifier(%s)", sampleTypeCode, spaceIdentifierSilentOverrideOrNull, experimentIdentifierSilentOverrideOrNull, sessionKey, defaultGroupIdentifier);
        return null;
    }

    public String updateSamples(String sessionToken, String sampleTypeCode, String sessionKey, String defaultGroupIdentifier) {
        this.logAccess(sessionToken, "updateSamples", "sampleTypeCode(%s), sessionKey(%s), defaultGroupIdentifier(%s)", sampleTypeCode, sessionKey, defaultGroupIdentifier);
        return null;
    }

    public Map<String, Object> uploadedSamplesInfo(String sessionToken, String sampleTypeCode, String sessionKey) {
        this.logAccess(sessionToken, "uploadedSamplesInfo", "sampleTypeCode(%s), sessionKey(%s)", sampleTypeCode, sessionKey);
        return null;
    }

    public void deleteProjects(String sessionToken, List<Long> projectIds, String reason) {
        this.logAccess(sessionToken, "deleteProjects", "projectIds(%s), reason(%s)", this.abbreviate(projectIds), reason);
    }

    public void deleteExperiments(String sessionToken, List<Long> experimentIds, String reason, DeletionType deletionType) {
        this.logAccess(sessionToken, "deleteExperiments", "experimentIds(%s), reason(%s), deletionType(%s)", this.abbreviate(experimentIds), reason, deletionType);
    }

    public void deleteSamples(String sessionToken, List<Long> sampleIds, String reason, DeletionType deletionType) {
        this.logAccess(sessionToken, "deleteSamples", "sampleIds(%s), reason(%s), deletionType(%s)", this.abbreviate(sampleIds), reason, deletionType);
    }

    public void deleteDataSets(String sessionToken, List<String> dataSetCodes, String reason, DeletionType deletionType) {
        this.logAccess(sessionToken, "deleteDataSets", "dataSetCodes(%s), reason(%s), deletionType(%s)", this.abbreviate(dataSetCodes), reason, deletionType);
    }

    public void deleteDataSetsForced(String sessionToken, List<String> dataSetCodes, String reason, DeletionType deletionType) {
        this.logAccess(sessionToken, "deleteDataSetsForced", "dataSetCodes(%s), reason(%s), deletionType(%s)", this.abbreviate(dataSetCodes), reason, deletionType);
    }

    public void revertDeletions(String sessionToken, List<Long> deletionIds) {
        this.logAccess(sessionToken, "revertDeletions", "deletionIds(%s)", this.abbreviate(deletionIds));
    }

    public void deletePermanently(String sessionToken, List<Long> deletionIds) {
        this.logAccess(sessionToken, "deletePermanently", "deletionIds(%s)", this.abbreviate(deletionIds));
    }

    public void deletePermanentlyForced(String sessionToken, List<Long> deletionIds) {
        this.logAccess(sessionToken, "deletePermanentlyForced", "deletionIds(%s)", this.abbreviate(deletionIds));
    }

    public int getMajorVersion() {
        return 0;
    }

    public int getMinorVersion() {
        return 0;
    }

    public void registerPerson(String sessionToken, String userID) {
        this.logAccess(sessionToken, "registerPerson", "userID(%s)", userID);
    }

    public void registerSpace(String sessionToken, String spaceCode, String spaceDescription) {
        this.logAccess(sessionToken, "registerSpace", "spaceCode(%s), spaceDescription(%s)", spaceCode, spaceDescription);
    }

    public void registerPersonSpaceRole(String sessionToken, String spaceCode, String userID, String roleCode) {
        this.logAccess(sessionToken, "registerPersonSpaceRole", "spaceCode(%s), userID(%s), roleCode(%s)", spaceCode, userID, roleCode);
    }
}

