/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.api.v1;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.common.spring.IInvocationLoggerContext;
import ch.systemsx.cisd.openbis.generic.server.AbstractServer;
import ch.systemsx.cisd.openbis.generic.server.ConcurrentOperation;
import ch.systemsx.cisd.openbis.generic.server.IConcurrentOperationLimiter;
import ch.systemsx.cisd.openbis.generic.server.api.v1.ExperimentToDataSetRelatedEntitiesTranslator;
import ch.systemsx.cisd.openbis.generic.server.api.v1.GeneralInformationServiceLogger;
import ch.systemsx.cisd.openbis.generic.server.api.v1.SampleToDataSetRelatedEntitiesTranslator;
import ch.systemsx.cisd.openbis.generic.server.api.v1.SearchCriteriaToDetailedSearchCriteriaTranslator;
import ch.systemsx.cisd.openbis.generic.server.api.v1.sort.SampleSearchResultSorter;
import ch.systemsx.cisd.openbis.generic.server.authorization.AuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.AuthorizationGuard;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.Capability;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.ReturnValueFilter;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.RolesAllowed;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.DataSetCodeCollectionPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.ExperimentAugmentedCodePredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.ExperimentIdPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.ExperimentListPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.ProjectIdPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.ProjectPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SampleIdPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SampleListPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SamplePredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.DataSetByExperimentOrSampleIdentifierValidator;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.ExperimentByIdentiferValidator;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.ProjectByIdentiferValidator;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.SampleByIdentiferValidator;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.SamplePropertyAccessValidator;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.SimpleSpaceValidator;
import ch.systemsx.cisd.openbis.generic.server.business.IPropertiesBatchManager;
import ch.systemsx.cisd.openbis.generic.server.business.bo.EntityCodeGenerator;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ICommonBusinessObjectFactory;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IExperimentBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IProjectBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ISampleBO;
import ch.systemsx.cisd.openbis.generic.server.business.bo.fetchoptions.datasetlister.DataSetLister;
import ch.systemsx.cisd.openbis.generic.server.business.bo.fetchoptions.samplelister.ISampleLister;
import ch.systemsx.cisd.openbis.generic.server.business.bo.fetchoptions.samplelister.SampleLister;
import ch.systemsx.cisd.openbis.generic.server.business.search.SampleSearchManager;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDataDAO;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.IOpenBisSessionManager;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.IGeneralInformationService;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.Translator;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Attachment;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.ControlledVocabularyPropertyType;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSet;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSetFetchOption;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSetFetchOptions;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataStore;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataStoreURLForDataSets;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Deletion;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DeletionFetchOption;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Role;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SampleFetchOption;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchCriteria;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchDomain;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchDomainSearchResult;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchableEntityKind;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SpaceWithProjectsAndRoleAssignments;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Vocabulary;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.IObjectId;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.experiment.IExperimentId;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.metaproject.IMetaprojectId;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.project.IProjectId;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.sample.ISampleId;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdentifierHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ContainerDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetRelatedEntities;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.FetchOption;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListMaterialCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListSampleCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Metaproject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MetaprojectAssignments;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Person;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SearchDomainSearchResultWithFullEntity;
import ch.systemsx.cisd.openbis.generic.shared.dto.AttachmentHolderPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.AttachmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.AuthorizationGroupPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.RoleAssignmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.SessionContextDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.translator.DataSetTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.ExperimentTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.MetaprojectTranslator;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.hibernate.query.NativeQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="general-information-api-server-v1")
public class GeneralInformationService
extends AbstractServer<IGeneralInformationService>
implements IGeneralInformationService {
    public static final int MINOR_VERSION = 32;
    @Resource(name="common-server")
    private ICommonServer commonServer;
    @Resource(name="common-business-object-factory")
    private ICommonBusinessObjectFactory boFactory;
    @Resource(name="managed-property-evaluator-factory")
    private IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory;
    @Autowired
    private IConcurrentOperationLimiter operationLimiter;

    public GeneralInformationService() {
    }

    GeneralInformationService(IOpenBisSessionManager sessionManager, IDAOFactory daoFactory, ICommonBusinessObjectFactory boFactory, IPropertiesBatchManager propertiesBatchManager, ICommonServer commonServer, IConcurrentOperationLimiter operationLimiter) {
        super(sessionManager, daoFactory, propertiesBatchManager);
        this.boFactory = boFactory;
        this.commonServer = commonServer;
        this.operationLimiter = operationLimiter;
    }

    public IGeneralInformationService createLogger(IInvocationLoggerContext context) {
        return new GeneralInformationServiceLogger(this.sessionManager, context);
    }

    @Transactional
    public String tryToAuthenticateForAllServices(String userID, String userPassword) {
        SessionContextDTO session = this.tryAuthenticate(userID, userPassword);
        return session == null ? null : session.getSessionToken();
    }

    @Transactional(readOnly=true)
    public boolean isSessionActive(String sessionToken) {
        return this.tryGetSession(sessionToken) != null;
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_OBSERVER})
    public Map<String, Set<Role>> listNamedRoleSets(String sessionToken) {
        RoleWithHierarchy[] values;
        this.checkSession(sessionToken);
        LinkedHashMap<String, Set<Role>> namedRoleSets = new LinkedHashMap<String, Set<Role>>();
        for (RoleWithHierarchy roleSet : values = RoleWithHierarchy.values()) {
            if (roleSet.isProjectLevel()) continue;
            Set<RoleWithHierarchy> roles = roleSet.getRoles();
            HashSet<Role> translatedRoles = new HashSet<Role>();
            for (RoleWithHierarchy role : roles) {
                if (roleSet.isProjectLevel()) continue;
                translatedRoles.add(Translator.translate(role));
            }
            namedRoleSets.put(roleSet.name(), translatedRoles);
        }
        return namedRoleSets;
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    @ReturnValueFilter(validatorClass=SimpleSpaceValidator.class)
    public List<SpaceWithProjectsAndRoleAssignments> listSpacesWithProjectsAndRoleAssignments(String sessionToken, String databaseInstanceCodeOrNull) {
        this.checkSession(sessionToken);
        Map<String, List<RoleAssignmentPE>> roleAssignmentsPerSpace = this.getRoleAssignmentsPerSpace();
        List<RoleAssignmentPE> instanceRoleAssignments = roleAssignmentsPerSpace.get(null);
        List<SpacePE> spaces = this.listSpaces();
        ArrayList<SpaceWithProjectsAndRoleAssignments> result = new ArrayList<SpaceWithProjectsAndRoleAssignments>();
        for (SpacePE space : spaces) {
            SpaceWithProjectsAndRoleAssignments fullSpace = new SpaceWithProjectsAndRoleAssignments(space.getCode());
            this.addProjectsTo(fullSpace, space);
            this.addRoles(fullSpace, instanceRoleAssignments);
            List<RoleAssignmentPE> list = roleAssignmentsPerSpace.get(space.getCode());
            if (list != null) {
                this.addRoles(fullSpace, list);
            }
            result.add(fullSpace);
        }
        return result;
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 32;
    }

    private Map<String, List<RoleAssignmentPE>> getRoleAssignmentsPerSpace() {
        List<RoleAssignmentPE> roleAssignments = this.getDAOFactory().getRoleAssignmentDAO().listRoleAssignments();
        HashMap<String, List<RoleAssignmentPE>> roleAssignmentsPerSpace = new HashMap<String, List<RoleAssignmentPE>>();
        for (RoleAssignmentPE roleAssignment : roleAssignments) {
            if (roleAssignment.getRoleWithHierarchy().isProjectLevel()) continue;
            SpacePE space = roleAssignment.getSpace();
            String spaceCode = space == null ? null : space.getCode();
            ArrayList<RoleAssignmentPE> list = (ArrayList<RoleAssignmentPE>)roleAssignmentsPerSpace.get(spaceCode);
            if (list == null) {
                list = new ArrayList<RoleAssignmentPE>();
                roleAssignmentsPerSpace.put(spaceCode, list);
            }
            list.add(roleAssignment);
        }
        return roleAssignmentsPerSpace;
    }

    private List<SpacePE> listSpaces() {
        IDAOFactory daoFactory = this.getDAOFactory();
        return daoFactory.getSpaceDAO().listSpaces();
    }

    private void addProjectsTo(SpaceWithProjectsAndRoleAssignments fullSpace, SpacePE space) {
        List<ProjectPE> projects = this.getDAOFactory().getProjectDAO().listProjects(space);
        for (ProjectPE project : projects) {
            fullSpace.add(new Project(project.getId(), project.getPermId(), fullSpace.getCode(), project.getCode(), project.getDescription()));
        }
    }

    private void addRoles(SpaceWithProjectsAndRoleAssignments fullSpace, List<RoleAssignmentPE> list) {
        for (RoleAssignmentPE roleAssignment : list) {
            Role role = Translator.translate(roleAssignment.getRole(), roleAssignment.getSpace() != null);
            AuthorizationGroupPE authorizationGroup = roleAssignment.getAuthorizationGroup();
            Set<PersonPE> persons = authorizationGroup != null ? authorizationGroup.getPersons() : Collections.singleton(roleAssignment.getPerson());
            for (PersonPE person : persons) {
                fullSpace.add(person.getUserId(), role);
            }
        }
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER})
    @ReturnValueFilter(validatorClass=SampleByIdentiferValidator.class)
    public List<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample> searchForSamples(String sessionToken, SearchCriteria searchCriteria) {
        return this.searchForSamples(sessionToken, searchCriteria, EnumSet.of(SampleFetchOption.PROPERTIES));
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER})
    @ReturnValueFilter(validatorClass=SampleByIdentiferValidator.class)
    public List<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample> searchForSamples(String sessionToken, SearchCriteria searchCriteria, EnumSet<SampleFetchOption> fetchOptions) {
        Session session = this.getSession(sessionToken);
        PersonPE user = session.tryGetPerson();
        return this.searchForSamples(session, session.getUserName(), user, searchCriteria, fetchOptions);
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_OBSERVER})
    @Capability(value="SEARCH_ON_BEHALF_OF_USER")
    public List<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample> searchForSamplesOnBehalfOfUser(String sessionToken, SearchCriteria searchCriteria, EnumSet<SampleFetchOption> fetchOptions, String userId) {
        Session session = this.getSession(sessionToken);
        PersonPE user = this.getDAOFactory().getPersonDAO().tryFindPersonByUserId(userId);
        return this.searchForSamples(session, userId, user, searchCriteria, fetchOptions);
    }

    private List<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample> searchForSamples(final Session session, final String userId, final PersonPE user, final SearchCriteria searchCriteria, final EnumSet<SampleFetchOption> fetchOptions) {
        return this.operationLimiter.executeLimitedWithTimeout("SearchSamplesOperation", new ConcurrentOperation<List<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample>>(){

            @Override
            public List<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample> execute() {
                EnumSet<SampleFetchOption> sampleFetchOptions = fetchOptions != null ? fetchOptions : EnumSet.noneOf(SampleFetchOption.class);
                DetailedSearchCriteria detailedSearchCriteria = SearchCriteriaToDetailedSearchCriteriaTranslator.convert(GeneralInformationService.this.getDAOFactory(), SearchableEntityKind.SAMPLE, searchCriteria);
                ch.systemsx.cisd.openbis.generic.server.business.bo.samplelister.ISampleLister sampleLister = GeneralInformationService.this.boFactory.createSampleLister(session, user.getId());
                Collection<Long> sampleIDs = new SampleSearchManager(GeneralInformationService.this.getDAOFactory().getHibernateSearchDAO(), sampleLister).searchForSampleIDs(userId, detailedSearchCriteria);
                SampleByIdentiferValidator filter = new SampleByIdentiferValidator();
                filter.init(new AuthorizationDataProvider(GeneralInformationService.this.getDAOFactory()));
                List<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample> results = GeneralInformationService.this.createSampleLister(user).getSamples(sampleIDs, sampleFetchOptions, filter);
                return new SampleSearchResultSorter().sort(results, detailedSearchCriteria);
            }
        });
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_OBSERVER})
    @Capability(value="SEARCH_ON_BEHALF_OF_USER")
    public List<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample> filterSamplesVisibleToUser(String sessionToken, List<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample> allSamples, String userId) {
        this.checkSession(sessionToken);
        PersonPE person = this.getDAOFactory().getPersonDAO().tryFindPersonByUserId(userId);
        SampleByIdentiferValidator validator = new SampleByIdentiferValidator();
        validator.init(new AuthorizationDataProvider(this.getDAOFactory()));
        ArrayList<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample> samples = new ArrayList<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample>(allSamples.size());
        for (ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample sample : allSamples) {
            if (!validator.doValidation(person, (IIdentifierHolder)sample)) continue;
            samples.add(sample);
        }
        return samples;
    }

    protected ISampleLister createSampleLister(PersonPE person) {
        return new SampleLister(this.getDAOFactory(), person);
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER})
    @ReturnValueFilter(validatorClass=SampleByIdentiferValidator.class)
    public List<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample> listSamplesForExperiment(String sessionToken, @AuthorizationGuard(guardClass=ExperimentAugmentedCodePredicate.class) String experimentIdentifierString) {
        this.checkSession(sessionToken);
        ExperimentIdentifier experimentId = new ExperimentIdentifierFactory(experimentIdentifierString).createIdentifier();
        ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment privateExperiment = this.commonServer.getExperimentInfo(sessionToken, experimentId);
        ListSampleCriteria listSampleCriteria = ListSampleCriteria.createForExperiment(new TechId(privateExperiment.getId()));
        List<Sample> privateSamples = this.commonServer.listSamples(sessionToken, listSampleCriteria);
        return Translator.translateSamples(privateSamples);
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_OBSERVER})
    @Capability(value="SEARCH_ON_BEHALF_OF_USER")
    public List<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample> listSamplesForExperimentOnBehalfOfUser(String sessionToken, @AuthorizationGuard(guardClass=ExperimentAugmentedCodePredicate.class) String experimentIdentifierString, String userId) {
        this.checkSession(sessionToken);
        ExperimentIdentifier experimentId = new ExperimentIdentifierFactory(experimentIdentifierString).createIdentifier();
        ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment privateExperiment = this.commonServer.getExperimentInfo(sessionToken, experimentId);
        ListSampleCriteria listSampleCriteria = ListSampleCriteria.createForExperiment(new TechId(privateExperiment.getId()));
        List<Sample> privateSamples = this.commonServer.listSamplesOnBehalfOfUser(sessionToken, listSampleCriteria, userId);
        List<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample> unfilteredSamples = Translator.translateSamples(privateSamples);
        PersonPE person = this.getDAOFactory().getPersonDAO().tryFindPersonByUserId(userId);
        SampleByIdentiferValidator validator = new SampleByIdentiferValidator();
        validator.init(new AuthorizationDataProvider(this.getDAOFactory()));
        ArrayList<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample> samples = new ArrayList<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample>(unfilteredSamples.size());
        for (ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample sample : unfilteredSamples) {
            if (!validator.doValidation(person, (IIdentifierHolder)sample)) continue;
            samples.add(sample);
        }
        return samples;
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER})
    @ReturnValueFilter(validatorClass=DataSetByExperimentOrSampleIdentifierValidator.class)
    public List<DataSet> listDataSets(String sessionToken, @AuthorizationGuard(guardClass=SampleListPredicate.class) List<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample> samples) {
        return this.listDataSets(sessionToken, samples, EnumSet.noneOf(DataSet.Connections.class));
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER})
    @ReturnValueFilter(validatorClass=ExperimentByIdentiferValidator.class)
    public List<Experiment> listExperiments(String sessionToken, @AuthorizationGuard(guardClass=ProjectPredicate.class) List<Project> projects, String experimentTypeString) {
        return this.listExperiments(sessionToken, projects, experimentTypeString, false, false);
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER})
    @ReturnValueFilter(validatorClass=ExperimentByIdentiferValidator.class)
    public List<Experiment> listExperimentsHavingDataSets(String sessionToken, @AuthorizationGuard(guardClass=ProjectPredicate.class) List<Project> projects, String experimentTypeString) {
        return this.listExperiments(sessionToken, projects, experimentTypeString, false, true);
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER})
    @ReturnValueFilter(validatorClass=ExperimentByIdentiferValidator.class)
    public List<Experiment> listExperimentsHavingSamples(String sessionToken, @AuthorizationGuard(guardClass=ProjectPredicate.class) List<Project> projects, String experimentTypeString) {
        return this.listExperiments(sessionToken, projects, experimentTypeString, true, false);
    }

    private List<Experiment> listExperiments(String sessionToken, List<Project> projects, String experimentTypeString, boolean onlyHavingSamples, boolean onlyHavingDataSets) {
        this.checkSession(sessionToken);
        ExperimentType experimentType = null;
        if (experimentTypeString == null || "(all)".equals(experimentTypeString)) {
            experimentType = new ExperimentType();
            experimentType.setCode("(all)");
        } else {
            experimentType = this.tryFindExperimentType(sessionToken, experimentTypeString);
            if (null == experimentType) {
                throw new UserFailureException("Unknown experiment type : " + experimentTypeString);
            }
        }
        LinkedList<ProjectIdentifier> projectIdentifiers = new LinkedList<ProjectIdentifier>();
        ArrayList<Experiment> experiments = new ArrayList<Experiment>();
        for (Project project : projects) {
            ProjectIdentifier projectIdentifier = new ProjectIdentifier(project.getSpaceCode(), project.getCode());
            projectIdentifiers.add(projectIdentifier);
        }
        List<ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment> basicExperiments = onlyHavingSamples ? this.commonServer.listExperimentsHavingSamples(sessionToken, experimentType, projectIdentifiers) : (onlyHavingDataSets ? this.commonServer.listExperimentsHavingDataSets(sessionToken, experimentType, projectIdentifiers) : this.commonServer.listExperiments(sessionToken, experimentType, projectIdentifiers));
        for (ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment basicExperiment : basicExperiments) {
            experiments.add(Translator.translate(basicExperiment));
        }
        return experiments;
    }

    private ExperimentType tryFindExperimentType(String sessionToken, String experimentTypeString) {
        List<ExperimentType> experimentTypes = this.commonServer.listExperimentTypes(sessionToken);
        for (ExperimentType anExperimentType : experimentTypes) {
            if (!anExperimentType.getCode().equals(experimentTypeString)) continue;
            return anExperimentType;
        }
        return null;
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_OBSERVER})
    @Capability(value="SEARCH_ON_BEHALF_OF_USER")
    public List<Experiment> filterExperimentsVisibleToUser(String sessionToken, List<Experiment> allExperiments, String userId) {
        this.checkSession(sessionToken);
        PersonPE person = this.getDAOFactory().getPersonDAO().tryFindPersonByUserId(userId);
        ArrayList<Experiment> experiments = new ArrayList<Experiment>(allExperiments.size());
        ExperimentByIdentiferValidator validator = new ExperimentByIdentiferValidator();
        validator.init(new AuthorizationDataProvider(this.getDAOFactory()));
        for (Experiment experiment : allExperiments) {
            if (!validator.doValidation(person, (IIdentifierHolder)experiment)) continue;
            experiments.add(experiment);
        }
        return experiments;
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER})
    @ReturnValueFilter(validatorClass=DataSetByExperimentOrSampleIdentifierValidator.class)
    public List<DataSet> listDataSetsForSample(String sessionToken, @AuthorizationGuard(guardClass=SamplePredicate.class) ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample sample, boolean areOnlyDirectlyConnectedIncluded) {
        this.checkSession(sessionToken);
        List<AbstractExternalData> externalData = this.commonServer.listSampleExternalData(sessionToken, new TechId(sample.getId()), areOnlyDirectlyConnectedIncluded);
        return Translator.translate(externalData, EnumSet.noneOf(DataSet.Connections.class));
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER})
    public List<DataStore> listDataStores(String sessionToken) {
        return Translator.translateDataStores(this.commonServer.listDataStores(sessionToken));
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER})
    public String getDefaultPutDataStoreBaseURL(String sessionToken) {
        return this.commonServer.getDefaultPutDataStoreBaseURL(sessionToken);
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    public String tryGetDataStoreBaseURL(String sessionToken, String dataSetCode) {
        Session session = this.getSession(sessionToken);
        DataSetLister lister = new DataSetLister(this.getDAOFactory(), session.tryGetPerson());
        List<DataStoreURLForDataSets> dataStores = lister.getDataStoreDownloadURLs(Collections.singletonList(dataSetCode));
        if (dataStores.isEmpty()) {
            return null;
        }
        return dataStores.get(0).getDataStoreURL();
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<DataStoreURLForDataSets> getDataStoreBaseURLs(String sessionToken, List<String> dataSetCodes) {
        Session session = this.getSession(sessionToken);
        DataSetLister lister = new DataSetLister(this.getDAOFactory(), session.tryGetPerson());
        return lister.getDataStoreDownloadURLs(dataSetCodes);
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER})
    public List<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSetType> listDataSetTypes(String sessionToken) {
        List<DataSetType> privateDataSetTypes = this.commonServer.listDataSetTypes(sessionToken);
        HashMap<ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary, List<ControlledVocabularyPropertyType.VocabularyTerm>> vocabTerms = this.getVocabularyTermsMap(sessionToken);
        ArrayList<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSetType> dataSetTypes = new ArrayList<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSetType>();
        for (DataSetType privateDataSetType : privateDataSetTypes) {
            dataSetTypes.add(Translator.translate(privateDataSetType, vocabTerms));
        }
        return dataSetTypes;
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER})
    public List<SampleType> listSampleTypes(String sessionToken) {
        List<ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType> sampleTypes = this.commonServer.listSampleTypes(sessionToken);
        HashMap<ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary, List<ControlledVocabularyPropertyType.VocabularyTerm>> vocabTerms = this.getVocabularyTermsMap(sessionToken);
        ArrayList<SampleType> result = new ArrayList<SampleType>();
        for (ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType sampleType : sampleTypes) {
            result.add(Translator.translate(sampleType, vocabTerms));
        }
        return result;
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER})
    public List<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.ExperimentType> listExperimentTypes(String sessionToken) {
        List<ExperimentType> experimentTypes = this.commonServer.listExperimentTypes(sessionToken);
        HashMap<ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary, List<ControlledVocabularyPropertyType.VocabularyTerm>> vocabTerms = this.getVocabularyTermsMap(sessionToken);
        ArrayList<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.ExperimentType> result = new ArrayList<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.ExperimentType>();
        for (ExperimentType experimentType : experimentTypes) {
            result.add(Translator.translate(experimentType, vocabTerms));
        }
        return result;
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER})
    public HashMap<ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary, List<ControlledVocabularyPropertyType.VocabularyTerm>> getVocabularyTermsMap(String sessionToken) {
        HashMap<ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary, List<ControlledVocabularyPropertyType.VocabularyTerm>> vocabTerms = new HashMap<ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary, List<ControlledVocabularyPropertyType.VocabularyTerm>>();
        List<ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary> privateVocabularies = this.commonServer.listVocabularies(sessionToken, true, false);
        for (ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary privateVocabulary : privateVocabularies) {
            vocabTerms.put(privateVocabulary, Translator.translatePropertyTypeTerms(privateVocabulary.getTerms()));
        }
        return vocabTerms;
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER})
    public List<Vocabulary> listVocabularies(String sessionToken) {
        List<ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary> privateVocabularies = this.commonServer.listVocabularies(sessionToken, true, false);
        ArrayList<Vocabulary> result = new ArrayList<Vocabulary>();
        for (ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary privateVocabulary : privateVocabularies) {
            result.add(Translator.translate(privateVocabulary));
        }
        return result;
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER})
    @ReturnValueFilter(validatorClass=DataSetByExperimentOrSampleIdentifierValidator.class)
    public List<DataSet> listDataSets(String sessionToken, @AuthorizationGuard(guardClass=SampleListPredicate.class) List<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample> samples, EnumSet<DataSet.Connections> connections) {
        this.checkSession(sessionToken);
        EnumSet<DataSet.Connections> connectionsToGet = connections != null ? connections : EnumSet.noneOf(DataSet.Connections.class);
        List<ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType> sampleTypes = this.commonServer.listSampleTypes(sessionToken);
        SampleToDataSetRelatedEntitiesTranslator translator = new SampleToDataSetRelatedEntitiesTranslator(sampleTypes, samples);
        DataSetRelatedEntities dsre = translator.convertToDataSetRelatedEntities();
        List<AbstractExternalData> dataSets = this.commonServer.listRelatedDataSets(sessionToken, dsre, true);
        return Translator.translate(dataSets, connectionsToGet);
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_OBSERVER})
    @Capability(value="SEARCH_ON_BEHALF_OF_USER")
    public List<DataSet> listDataSetsOnBehalfOfUser(String sessionToken, List<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample> samples, EnumSet<DataSet.Connections> connections, String userId) {
        this.checkSession(sessionToken);
        EnumSet<DataSet.Connections> connectionsToGet = connections != null ? connections : EnumSet.noneOf(DataSet.Connections.class);
        List<ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType> sampleTypes = this.commonServer.listSampleTypes(sessionToken);
        SampleToDataSetRelatedEntitiesTranslator translator = new SampleToDataSetRelatedEntitiesTranslator(sampleTypes, samples);
        DataSetRelatedEntities dsre = translator.convertToDataSetRelatedEntities();
        List<AbstractExternalData> dataSets = this.commonServer.listRelatedDataSetsOnBehalfOfUser(sessionToken, dsre, true, userId);
        List<DataSet> unfilteredDatasets = Translator.translate(dataSets, connectionsToGet);
        PersonPE person = this.getDAOFactory().getPersonDAO().tryFindPersonByUserId(userId);
        ArrayList<DataSet> datasets = new ArrayList<DataSet>(unfilteredDatasets.size());
        DataSetByExperimentOrSampleIdentifierValidator validator = new DataSetByExperimentOrSampleIdentifierValidator();
        validator.init(new AuthorizationDataProvider(this.getDAOFactory()));
        for (DataSet dataset : unfilteredDatasets) {
            if (!validator.doValidation(person, dataset)) continue;
            datasets.add(dataset);
        }
        return datasets;
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER})
    @ReturnValueFilter(validatorClass=DataSetByExperimentOrSampleIdentifierValidator.class)
    public List<DataSet> listDataSetsForExperiments(String sessionToken, @AuthorizationGuard(guardClass=ExperimentListPredicate.class) List<Experiment> experiments, EnumSet<DataSet.Connections> connections) {
        this.checkSession(sessionToken);
        EnumSet<DataSet.Connections> connectionsToGet = connections != null ? connections : EnumSet.noneOf(DataSet.Connections.class);
        List<ExperimentType> experimentTypes = this.commonServer.listExperimentTypes(sessionToken);
        ExperimentToDataSetRelatedEntitiesTranslator translator = new ExperimentToDataSetRelatedEntitiesTranslator(experimentTypes, experiments);
        DataSetRelatedEntities dsre = translator.convertToDataSetRelatedEntities();
        List<AbstractExternalData> dataSets = this.commonServer.listRelatedDataSets(sessionToken, dsre, true);
        return Translator.translate(dataSets, connectionsToGet);
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_OBSERVER})
    @Capability(value="SEARCH_ON_BEHALF_OF_USER")
    public List<DataSet> listDataSetsForExperimentsOnBehalfOfUser(String sessionToken, List<Experiment> experiments, EnumSet<DataSet.Connections> connections, String userId) {
        this.checkSession(sessionToken);
        EnumSet<DataSet.Connections> connectionsToGet = connections != null ? connections : EnumSet.noneOf(DataSet.Connections.class);
        List<ExperimentType> experimentTypes = this.commonServer.listExperimentTypes(sessionToken);
        ExperimentToDataSetRelatedEntitiesTranslator translator = new ExperimentToDataSetRelatedEntitiesTranslator(experimentTypes, experiments);
        DataSetRelatedEntities dsre = translator.convertToDataSetRelatedEntities();
        List<AbstractExternalData> dataSets = this.commonServer.listRelatedDataSetsOnBehalfOfUser(sessionToken, dsre, true, userId);
        List<DataSet> unfilteredDatasets = Translator.translate(dataSets, connectionsToGet);
        PersonPE person = this.getDAOFactory().getPersonDAO().tryFindPersonByUserId(userId);
        ArrayList<DataSet> datasets = new ArrayList<DataSet>(unfilteredDatasets.size());
        DataSetByExperimentOrSampleIdentifierValidator validator = new DataSetByExperimentOrSampleIdentifierValidator();
        validator.init(new AuthorizationDataProvider(this.getDAOFactory()));
        for (DataSet dataset : unfilteredDatasets) {
            if (!validator.doValidation(person, dataset)) continue;
            datasets.add(dataset);
        }
        return datasets;
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER})
    @ReturnValueFilter(validatorClass=DataSetByExperimentOrSampleIdentifierValidator.class)
    public List<DataSet> getDataSetMetaData(String sessionToken, @AuthorizationGuard(guardClass=DataSetCodeCollectionPredicate.class) List<String> dataSetCodes) {
        return this.getDataSetMetaData(this.getSession(sessionToken), dataSetCodes, true);
    }

    private List<DataSet> getDataSetMetaData(Session session, List<String> dataSetCodes, boolean noContainedDataSets) {
        IDataDAO dataDAO = this.getDAOFactory().getDataDAO();
        ArrayList<DataSet> result = new ArrayList<DataSet>();
        EnumSet<DataSet.Connections> connections = EnumSet.of(DataSet.Connections.PARENTS, DataSet.Connections.CHILDREN);
        for (String dataSetCode : dataSetCodes) {
            DataPE dataPE = dataDAO.tryToFindDataSetByCode(dataSetCode);
            if (dataPE == null) {
                throw new UserFailureException("Unknown data set " + dataSetCode);
            }
            HibernateUtils.initialize(dataPE.getChildRelationships());
            HibernateUtils.initialize(dataPE.getProperties());
            Collection<MetaprojectPE> metaprojects = this.getDAOFactory().getMetaprojectDAO().listMetaprojectsForEntity(session.tryGetPerson(), dataPE);
            AbstractExternalData ds = DataSetTranslator.translate(dataPE, session.getBaseIndexURL(), MetaprojectTranslator.translate(metaprojects), this.managedPropertyEvaluatorFactory, new SamplePropertyAccessValidator(session, this.getDAOFactory()), new ExperimentTranslator.LoadableFields[0]);
            if (ds instanceof ContainerDataSet && noContainedDataSets) {
                ContainerDataSet cds = (ContainerDataSet)ds;
                cds.getContainedDataSets().clear();
            }
            result.add(Translator.translate(ds, connections, new HashMap<String, DataSet>()));
        }
        return result;
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER})
    @ReturnValueFilter(validatorClass=DataSetByExperimentOrSampleIdentifierValidator.class)
    public List<DataSet> getDataSetMetaData(String sessionToken, @AuthorizationGuard(guardClass=DataSetCodeCollectionPredicate.class) List<String> dataSetCodes, EnumSet<DataSetFetchOption> fetchOptions) {
        if (sessionToken == null) {
            throw new IllegalArgumentException("SessionToken was null");
        }
        if (dataSetCodes == null) {
            throw new IllegalArgumentException("DataSetCodes were null");
        }
        if (fetchOptions == null) {
            throw new IllegalArgumentException("FetchOptions were null");
        }
        DataSetFetchOptions dataSetFetchOptions = new DataSetFetchOptions();
        for (DataSetFetchOption option : fetchOptions) {
            dataSetFetchOptions.addOption((FetchOption)option);
        }
        Session session = this.getSession(sessionToken);
        if (dataSetFetchOptions.isSubsetOf((FetchOption[])new DataSetFetchOption[]{DataSetFetchOption.BASIC, DataSetFetchOption.PARENTS, DataSetFetchOption.CHILDREN})) {
            DataSetLister lister = new DataSetLister(this.getDAOFactory(), session.tryGetPerson());
            return lister.getDataSetMetaData(dataSetCodes, dataSetFetchOptions);
        }
        List<DataSet> dataSetList = this.getDataSetMetaData(session, dataSetCodes, false);
        if (dataSetList != null) {
            for (DataSet dataSet : dataSetList) {
                if (dataSet == null) continue;
                dataSet.setFetchOptions(new DataSetFetchOptions(DataSetFetchOption.values()));
            }
        }
        return dataSetList;
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER})
    public List<SearchDomainSearchResult> searchOnSearchDomain(String sessionToken, String preferredSearchDomainOrNull, String searchString, Map<String, String> optionalParametersOrNull) {
        this.checkSession(sessionToken);
        ArrayList<SearchDomainSearchResult> result = new ArrayList<SearchDomainSearchResult>();
        List<SearchDomainSearchResultWithFullEntity> list = this.commonServer.searchOnSearchDomain(sessionToken, preferredSearchDomainOrNull, searchString, optionalParametersOrNull);
        for (SearchDomainSearchResultWithFullEntity sequenceSearchResult : list) {
            result.add(sequenceSearchResult.getSearchResult());
        }
        return result;
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER})
    public List<SearchDomain> listAvailableSearchDomains(String sessionToken) {
        this.checkSession(sessionToken);
        return this.commonServer.listAvailableSearchDomains(sessionToken);
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER})
    @ReturnValueFilter(validatorClass=DataSetByExperimentOrSampleIdentifierValidator.class)
    public List<DataSet> searchForDataSets(String sessionToken, SearchCriteria searchCriteria) {
        this.checkSession(sessionToken);
        DetailedSearchCriteria detailedSearchCriteria = SearchCriteriaToDetailedSearchCriteriaTranslator.convert(this.getDAOFactory(), SearchableEntityKind.DATA_SET, searchCriteria);
        List<AbstractExternalData> privateDataSets = this.commonServer.searchForDataSets(sessionToken, detailedSearchCriteria);
        return Translator.translate(privateDataSets, EnumSet.noneOf(DataSet.Connections.class));
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_OBSERVER})
    @Capability(value="SEARCH_ON_BEHALF_OF_USER")
    public List<DataSet> searchForDataSetsOnBehalfOfUser(String sessionToken, SearchCriteria searchCriteria, String userId) {
        this.checkSession(sessionToken);
        DetailedSearchCriteria detailedSearchCriteria = SearchCriteriaToDetailedSearchCriteriaTranslator.convert(this.getDAOFactory(), SearchableEntityKind.DATA_SET, searchCriteria);
        List<AbstractExternalData> privateDataSets = this.commonServer.searchForDataSetsOnBehalfOfUser(sessionToken, detailedSearchCriteria, userId);
        return Translator.translate(privateDataSets, EnumSet.noneOf(DataSet.Connections.class));
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_OBSERVER})
    @Capability(value="SEARCH_ON_BEHALF_OF_USER")
    public List<DataSet> filterDataSetsVisibleToUser(String sessionToken, List<DataSet> allDataSets, String userId) {
        this.checkSession(sessionToken);
        PersonPE person = this.getDAOFactory().getPersonDAO().tryFindPersonByUserId(userId);
        DataSetByExperimentOrSampleIdentifierValidator experimentIdentifierValidator = new DataSetByExperimentOrSampleIdentifierValidator();
        experimentIdentifierValidator.init(new AuthorizationDataProvider(this.getDAOFactory()));
        ArrayList<DataSet> dataSets = new ArrayList<DataSet>(allDataSets.size());
        for (DataSet dataSet : allDataSets) {
            if (!experimentIdentifierValidator.doValidation(person, dataSet)) continue;
            dataSets.add(dataSet);
        }
        return dataSets;
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER})
    @ReturnValueFilter(validatorClass=ExperimentByIdentiferValidator.class)
    public List<Experiment> listExperiments(String sessionToken, @AuthorizationGuard(guardClass=ExperimentAugmentedCodePredicate.class) List<String> experimentIdentifiers) {
        this.checkSession(sessionToken);
        List<ExperimentIdentifier> parsedIdentifiers = ExperimentIdentifierFactory.parse(experimentIdentifiers);
        List<ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment> experiments = this.commonServer.listExperiments(sessionToken, parsedIdentifiers);
        return Translator.translateExperiments(experiments);
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER})
    @ReturnValueFilter(validatorClass=ExperimentByIdentiferValidator.class)
    public List<Experiment> searchForExperiments(String sessionToken, SearchCriteria searchCriteria) {
        this.checkSession(sessionToken);
        DetailedSearchCriteria detailedSearchCriteria = SearchCriteriaToDetailedSearchCriteriaTranslator.convert(this.getDAOFactory(), SearchableEntityKind.EXPERIMENT, searchCriteria);
        List<ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment> experiments = this.commonServer.searchForExperiments(sessionToken, detailedSearchCriteria);
        return Translator.translateExperiments(experiments);
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER})
    @ReturnValueFilter(validatorClass=ProjectByIdentiferValidator.class)
    public List<Project> listProjects(String sessionToken) {
        this.checkSession(sessionToken);
        return Translator.translateProjects(this.commonServer.listProjects(sessionToken));
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_OBSERVER})
    @Capability(value="SEARCH_ON_BEHALF_OF_USER")
    public List<Project> listProjectsOnBehalfOfUser(String sessionToken, String userId) {
        List<Project> unfilteredProjects = this.listProjects(sessionToken);
        PersonPE person = this.getDAOFactory().getPersonDAO().tryFindPersonByUserId(userId);
        ProjectByIdentiferValidator validator = new ProjectByIdentiferValidator();
        validator.init(new AuthorizationDataProvider(this.getDAOFactory()));
        ArrayList<Project> projects = new ArrayList<Project>();
        for (Project project : unfilteredProjects) {
            if (!validator.doValidation(person, (IIdentifierHolder)project)) continue;
            projects.add(project);
        }
        return projects;
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER})
    public List<Material> getMaterialByCodes(String sessionToken, List<MaterialIdentifier> materialIdentifier) {
        Collection materialCodes = CollectionUtils.collect(materialIdentifier, (Transformer)new Transformer<MaterialIdentifier, ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier>(){

            public ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier transform(MaterialIdentifier arg0) {
                return new ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier(arg0.getMaterialCode(), arg0.getMaterialTypeIdentifier().getMaterialTypeCode());
            }
        });
        ListMaterialCriteria criteria = ListMaterialCriteria.createFromMaterialIdentifiers(materialCodes);
        List<ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material> materials = this.commonServer.listMaterials(sessionToken, criteria, true);
        return Translator.translateMaterials(materials);
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER})
    public List<Material> searchForMaterials(String sessionToken, SearchCriteria searchCriteria) {
        DetailedSearchCriteria detailedSearchCriteria = SearchCriteriaToDetailedSearchCriteriaTranslator.convert(this.getDAOFactory(), SearchableEntityKind.MATERIAL, searchCriteria);
        List<ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material> materials = this.commonServer.searchForMaterials(sessionToken, detailedSearchCriteria);
        return Translator.translateMaterials(materials);
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER})
    public List<Metaproject> listMetaprojects(String sessionToken) {
        return this.commonServer.listMetaprojects(sessionToken);
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_OBSERVER})
    public List<Metaproject> listMetaprojectsOnBehalfOfUser(String sessionToken, String userId) {
        return this.commonServer.listMetaprojectsOnBehalfOfUser(sessionToken, userId);
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER})
    public ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.MetaprojectAssignments getMetaproject(String sessionToken, IMetaprojectId metaprojectId) {
        MetaprojectAssignments assignments = this.commonServer.getMetaprojectAssignments(sessionToken, Translator.translate(metaprojectId));
        return this.translate(assignments);
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_OBSERVER})
    public ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.MetaprojectAssignments getMetaprojectOnBehalfOfUser(String sessionToken, IMetaprojectId metaprojectId, String userId) {
        MetaprojectAssignments assignments = this.commonServer.getMetaprojectAssignmentsOnBehalfOfUser(sessionToken, Translator.translate(metaprojectId), userId);
        return this.translate(assignments);
    }

    private ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.MetaprojectAssignments translate(MetaprojectAssignments assignments) {
        ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.MetaprojectAssignments result = new ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.MetaprojectAssignments();
        result.setMetaproject(assignments.getMetaproject());
        result.setExperiments(Translator.translateExperiments(assignments.getExperiments()));
        result.setSamples(Translator.translateSamples(assignments.getSamples()));
        result.setDataSets(Translator.translate(assignments.getDataSets(), EnumSet.noneOf(DataSet.Connections.class)));
        result.setMaterials(Translator.translateMaterials(assignments.getMaterials()));
        return result;
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER})
    public List<Attachment> listAttachmentsForProject(String sessionToken, @AuthorizationGuard(guardClass=ProjectIdPredicate.class) IProjectId projectId, boolean allVersions) {
        Session session = this.getSession(sessionToken);
        IProjectBO projectBO = this.boFactory.createProjectBO(session);
        ProjectPE project = projectBO.tryFindByProjectId(projectId);
        if (project == null) {
            throw new UserFailureException("No project found for id '" + projectId + "'.");
        }
        return this.listAttachments(sessionToken, (IObjectId)projectId, project, allVersions);
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER})
    public List<Attachment> listAttachmentsForExperiment(String sessionToken, @AuthorizationGuard(guardClass=ExperimentIdPredicate.class) IExperimentId experimentId, boolean allVersions) {
        Session session = this.getSession(sessionToken);
        IExperimentBO experimentBO = this.boFactory.createExperimentBO(session);
        ExperimentPE experiment = experimentBO.tryFindByExperimentId(Translator.translate(experimentId));
        if (experiment == null) {
            throw new UserFailureException("No experiment found for id '" + experimentId + "'.");
        }
        return this.listAttachments(sessionToken, (IObjectId)experimentId, experiment, allVersions);
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER})
    public List<Attachment> listAttachmentsForSample(String sessionToken, @AuthorizationGuard(guardClass=SampleIdPredicate.class) ISampleId sampleId, boolean allVersions) {
        Session session = this.getSession(sessionToken);
        ISampleBO sampleBO = this.boFactory.createSampleBO(session);
        SamplePE sample = sampleBO.tryFindBySampleId(Translator.translate(sampleId));
        if (sample == null) {
            throw new UserFailureException("No sample found for id '" + sampleId + "'.");
        }
        return this.listAttachments(sessionToken, (IObjectId)sampleId, sample, allVersions);
    }

    private List<Attachment> listAttachments(String sessionToken, IObjectId objectId, AttachmentHolderPE attachmentHolder, boolean allVersions) {
        List<AttachmentPE> attachments = this.getDAOFactory().getAttachmentDAO().listAttachments(attachmentHolder);
        return Translator.translateAttachments(sessionToken, objectId, attachmentHolder, attachments, allVersions);
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER})
    public final Map<String, String> getUserDisplaySettings(String sessionToken) {
        String spaceCode = null;
        String projectCode = null;
        PersonPE person = this.getAuthSession(sessionToken).tryGetPerson();
        if (person != null && person.getHomeSpace() != null) {
            spaceCode = person.getHomeSpace().getCode();
        }
        if (person != null && person.getDisplaySettings() != null) {
            projectCode = person.getDisplaySettings().getDefaultProject();
        }
        HashMap<String, String> userSettings = new HashMap<String, String>();
        if (spaceCode != null) {
            userSettings.put("spaceCode", spaceCode);
        }
        if (projectCode != null) {
            userSettings.put("projectCode", projectCode);
        }
        return userSettings;
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER})
    public List<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.PropertyType> listPropertyTypes(String sessionToken, boolean withRelations) {
        HashMap<ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary, List<ControlledVocabularyPropertyType.VocabularyTerm>> vocabTerms = this.getVocabularyTermsMap(sessionToken);
        List<PropertyType> basic = this.commonServer.listPropertyTypes(sessionToken, withRelations);
        ArrayList<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.PropertyType> api = new ArrayList<ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.PropertyType>();
        for (PropertyType propertyType : basic) {
            api.add(Translator.translate(propertyType, vocabTerms));
        }
        return api;
    }

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_USER})
    public String generateCode(String sessionToken, String prefix, String entityKind) {
        this.checkSession(sessionToken);
        return new EntityCodeGenerator(this.getDAOFactory()).generateCode(prefix, EntityKind.valueOf((String)entityKind));
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_USER})
    public List<Deletion> listDeletions(String sessionToken, EnumSet<DeletionFetchOption> fetchOptions) {
        if (fetchOptions != null && fetchOptions.contains(DeletionFetchOption.ALL_ENTITIES)) {
            return Translator.translate(this.commonServer.listDeletions(sessionToken, true));
        }
        if (fetchOptions != null && fetchOptions.contains(DeletionFetchOption.ORIGINAL_ENTITIES)) {
            return Translator.translate(this.commonServer.listOriginalDeletions(sessionToken));
        }
        return Translator.translate(this.commonServer.listDeletions(sessionToken, false));
    }

    public List<Person> listPersons(String sessionToken) {
        return this.commonServer.listPersons(sessionToken);
    }

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_USER})
    public Long countNumberOfSamplesForType(String sessionToken, String sampleTypeCode) {
        org.hibernate.Session currentSession = this.getDAOFactory().getSessionFactory().getCurrentSession();
        NativeQuery querySampleTypeId = currentSession.createSQLQuery("SELECT id from sample_types WHERE code = :sampleTypeCode");
        querySampleTypeId.setParameter("sampleTypeCode", (Object)sampleTypeCode);
        int sampleTypeId = ((Number)querySampleTypeId.uniqueResult()).intValue();
        NativeQuery querySampleCount = currentSession.createSQLQuery("SELECT COUNT(*) FROM samples_all WHERE saty_id = :sampleTypeId");
        querySampleCount.setParameter("sampleTypeId", (Object)sampleTypeId);
        long sampleCount = ((Number)querySampleCount.uniqueResult()).longValue();
        return sampleCount;
    }
}

