/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization;

import ch.systemsx.cisd.common.action.IMapper;
import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.SpaceOwnerKind;
import ch.systemsx.cisd.openbis.generic.server.batch.BatchOperationExecutor;
import ch.systemsx.cisd.openbis.generic.server.batch.IBatchOperation;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IAuthorizationDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.authorization.IAuthorizationConfig;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetAccessPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DeletionPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentAccessPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.GridCustomColumnPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.GridCustomFilterPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PermId;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.QueryPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleAccessPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Session;
import org.hibernate.query.Query;

public final class AuthorizationDataProvider
implements IAuthorizationDataProvider {
    private final IAuthorizationDAOFactory daoFactory;

    public AuthorizationDataProvider(IAuthorizationDAOFactory daoFactory) {
        this.daoFactory = daoFactory;
    }

    @Override
    public IAuthorizationDAOFactory getDaoFactory() {
        return this.daoFactory;
    }

    @Override
    public IAuthorizationConfig getAuthorizationConfig() {
        return this.daoFactory.getAuthorizationConfig();
    }

    @Override
    public List<SpacePE> listSpaces() {
        return this.daoFactory.getSpaceDAO().listSpaces();
    }

    @Override
    public SpacePE tryGetSpace(String spaceCode) {
        return this.daoFactory.getSpaceDAO().tryFindSpaceByCode(spaceCode);
    }

    @Override
    public ExperimentPE tryGetExperimentByTechId(TechId techId) {
        return (ExperimentPE)this.daoFactory.getExperimentDAO().tryGetByTechId(techId, new String[0]);
    }

    @Override
    public Map<TechId, ExperimentPE> tryGetExperimentsByTechIds(Collection<TechId> techIds) {
        List<ExperimentPE> experiments = this.daoFactory.getExperimentDAO().listByIDs(TechId.asLongs(techIds));
        HashMap<TechId, ExperimentPE> map = new HashMap<TechId, ExperimentPE>();
        for (ExperimentPE experiment : experiments) {
            map.put(new TechId(experiment.getId()), experiment);
        }
        return map;
    }

    @Override
    public ExperimentPE tryGetExperimentByPermId(String permId) {
        return this.daoFactory.getExperimentDAO().tryGetByPermID(permId);
    }

    @Override
    public SamplePE tryGetSampleByPermId(String permId) {
        return this.daoFactory.getSampleDAO().tryToFindByPermID(permId);
    }

    @Override
    public SamplePE tryGetSampleBySpaceAndCode(SpacePE space, String sampleCode) {
        return this.daoFactory.getSampleDAO().tryFindByCodeAndSpace(sampleCode, space);
    }

    @Override
    public SamplePE tryGetSampleByProjectAndCode(ProjectPE project, String sampleCode) {
        return this.daoFactory.getSampleDAO().tryfindByCodeAndProject(sampleCode, project);
    }

    @Override
    public Map<TechId, SamplePE> tryGetSamplesByTechIds(Collection<TechId> techIds) {
        List<SamplePE> samples = this.daoFactory.getSampleDAO().listByIDs(TechId.asLongs(techIds));
        HashMap<TechId, SamplePE> map = new HashMap<TechId, SamplePE>();
        for (SamplePE sample : samples) {
            map.put(new TechId(sample.getId()), sample);
        }
        return map;
    }

    @Override
    public Map<TechId, DataPE> tryGetDataSetsByTechIds(Collection<TechId> techIds) {
        List<DataPE> dataSets = this.daoFactory.getDataDAO().listByIDs(TechId.asLongs(techIds));
        HashMap<TechId, DataPE> map = new HashMap<TechId, DataPE>();
        for (DataPE dataSet : dataSets) {
            map.put(new TechId(dataSet.getId()), dataSet);
        }
        return map;
    }

    @Override
    public ProjectPE tryGetProjectByPermId(PermId permId) {
        return this.daoFactory.getProjectDAO().tryGetByPermID(permId.getId());
    }

    @Override
    public ProjectPE tryGetProjectByTechId(TechId techId) {
        return (ProjectPE)this.daoFactory.getProjectDAO().tryGetByTechId(techId, new String[0]);
    }

    @Override
    public Map<TechId, ProjectPE> tryGetProjectsByTechIds(Collection<TechId> techIds) {
        List<ProjectPE> projects = this.daoFactory.getProjectDAO().listByIDs(TechId.asLongs(techIds));
        HashMap<TechId, ProjectPE> map = new HashMap<TechId, ProjectPE>();
        for (ProjectPE project : projects) {
            map.put(new TechId(project.getId()), project);
        }
        return map;
    }

    @Override
    public ProjectPE tryGetProjectByIdentifier(ProjectIdentifier identifier) {
        return this.daoFactory.getProjectDAO().tryFindProject(identifier.getSpaceCode(), identifier.getProjectCode());
    }

    @Override
    public ProjectPE tryGetProjectForDataSet(String dataSetCode) {
        DataPE dataSet = this.daoFactory.getDataDAO().tryToFindDataSetByCode(dataSetCode);
        if (dataSet != null && dataSet.getExperiment() != null) {
            return dataSet.getExperiment().getProject();
        }
        return null;
    }

    @Override
    public Set<DataSetAccessPE> getDatasetCollectionAccessDataByTechIds(List<TechId> dataSetTechIds, boolean grouped) {
        return this.getEntityCollectionAccessData("dataset", "dataset_access_by_tech_ids", "ids", dataSetTechIds, new TechId2LongMapper(), grouped ? new GroupDataSetMapper() : null);
    }

    @Override
    public Set<DataSetAccessPE> getDatasetCollectionAccessDataByCodes(List<String> dataSetCodes) {
        return this.getEntityCollectionAccessData("dataset", "dataset_access_by_codes", "codes", dataSetCodes, null, new GroupDataSetMapper());
    }

    @Override
    public Set<DataSetAccessPE> getDeletedDatasetCollectionAccessData(List<TechId> deletionIds) {
        return this.getEntityCollectionAccessData("deletion", "deleted_dataset_access", "del_ids", deletionIds, new TechId2LongMapper(), new GroupDataSetMapper());
    }

    @Override
    public Set<SampleAccessPE> getSampleCollectionAccessDataByTechIds(List<TechId> sampleTechIds, boolean grouped) {
        return this.getEntityCollectionAccessData("sample", "sample_access_by_tech_ids", "ids", sampleTechIds, new TechId2LongMapper(), grouped ? new GroupSampleMapper() : null);
    }

    @Override
    public Set<SampleAccessPE> getSampleCollectionAccessDataByPermIds(List<PermId> samplePermIds) {
        return this.getEntityCollectionAccessData("sample", "sample_access_by_perm_ids", "ids", samplePermIds, new PermId2StringMapper(), new GroupSampleMapper());
    }

    @Override
    public Set<SampleAccessPE> getDeletedSampleCollectionAccessData(List<TechId> deletionIds) {
        return this.getEntityCollectionAccessData("deletion", "deleted_sample_access", "del_ids", deletionIds, new TechId2LongMapper(), new GroupSampleMapper());
    }

    @Override
    public Set<ExperimentAccessPE> getExperimentCollectionAccessData(List<TechId> experimentIds, boolean grouped) {
        return this.getEntityCollectionAccessData("experiment", "experiment_access", "ids", experimentIds, new TechId2LongMapper(), grouped ? new GroupExperimentMapper() : null);
    }

    @Override
    public Set<ExperimentAccessPE> getDeletedExperimentCollectionAccessData(List<TechId> deletionIds) {
        return this.getEntityCollectionAccessData("deletion", "deleted_experiment_access", "del_ids", deletionIds, new TechId2LongMapper(), new GroupExperimentMapper());
    }

    private <V, R> Set<R> getEntityCollectionAccessData(final String entityName, final String queryName, final String parameterName, final List<V> values, final IMapper<List<V>, List<?>> valuesMapperOrNull, final IMapper<List<R>, List<R>> resultMapperOrNull) {
        final Session session = this.daoFactory.getSessionFactory().getCurrentSession();
        final HashSet fullResults = new HashSet();
        BatchOperationExecutor.executeInBatches(new IBatchOperation<V>(){

            @Override
            public void execute(List<V> entities) {
                List mappedValues = valuesMapperOrNull != null ? (List)valuesMapperOrNull.map(entities) : entities;
                AuthorizationDataProvider.this.assertNoNullElements(mappedValues);
                Query query = session.getNamedQuery(queryName);
                query.setReadOnly(true);
                query.setParameterList(parameterName, (Collection)mappedValues);
                List singleResults = AuthorizationDataProvider.cast(query.list());
                if (resultMapperOrNull != null) {
                    singleResults = (List)resultMapperOrNull.map((Object)singleResults);
                }
                fullResults.addAll(singleResults);
            }

            @Override
            public List<V> getAllEntities() {
                return values;
            }

            @Override
            public String getEntityName() {
                return entityName;
            }

            @Override
            public String getOperationName() {
                return "authorization";
            }
        });
        return fullResults;
    }

    private void assertNoNullElements(List<?> list) {
        for (Object object : list) {
            if (object != null) continue;
            throw new NullPointerException();
        }
    }

    @Override
    public SpacePE tryGetSpace(SpaceOwnerKind kind, TechId techId) {
        switch (kind) {
            case EXPERIMENT: {
                ExperimentPE experiment = (ExperimentPE)this.daoFactory.getExperimentDAO().getByTechId(techId);
                return experiment.getProject().getSpace();
            }
            case SPACE: {
                SpacePE space = (SpacePE)this.daoFactory.getSpaceDAO().getByTechId(techId);
                return space;
            }
            case PROJECT: {
                ProjectPE project = (ProjectPE)this.daoFactory.getProjectDAO().getByTechId(techId);
                return project.getSpace();
            }
        }
        return null;
    }

    @Override
    public Set<SpacePE> getDistinctSpacesByEntityIds(SpaceOwnerKind kind, List<TechId> techIds) {
        HashSet<SpacePE> spaces = new HashSet<SpacePE>();
        List ids = TechId.asLongs(techIds);
        switch (kind) {
            case EXPERIMENT: {
                spaces.addAll(this.daoFactory.getExperimentDAO().listSpacesByExperimentIds(ids));
                break;
            }
            case SPACE: {
                List<SpacePE> allSpaces = this.daoFactory.getSpaceDAO().listSpaces();
                HashSet idSet = new HashSet(ids);
                for (SpacePE space : allSpaces) {
                    if (!idSet.contains(space.getId())) continue;
                    spaces.add(space);
                }
                break;
            }
            case PROJECT: {
                List<ProjectPE> projects = this.daoFactory.getProjectDAO().listProjects();
                HashSet idSet2 = new HashSet(ids);
                for (ProjectPE project : projects) {
                    if (!idSet2.contains(project.getId())) continue;
                    spaces.add(project.getSpace());
                }
                break;
            }
        }
        return spaces;
    }

    @Override
    public SamplePE getSample(TechId techId) {
        return (SamplePE)this.daoFactory.getSampleDAO().getByTechId(techId);
    }

    @Override
    public GridCustomFilterPE getGridCustomFilter(TechId techId) {
        return (GridCustomFilterPE)this.daoFactory.getGridCustomFilterDAO().getByTechId(techId);
    }

    @Override
    public GridCustomColumnPE getGridCustomColumn(TechId techId) {
        return (GridCustomColumnPE)this.daoFactory.getGridCustomColumnDAO().getByTechId(techId);
    }

    @Override
    public QueryPE getQuery(TechId techId) {
        return (QueryPE)this.daoFactory.getQueryDAO().getByTechId(techId);
    }

    @Override
    public List<DeletionPE> getDeletions(List<TechId> deletionIds) {
        return this.daoFactory.getDeletionDAO().findAllById(TechId.asLongs(deletionIds));
    }

    @Override
    public MetaprojectPE getMetaproject(TechId id) {
        return (MetaprojectPE)this.daoFactory.getMetaprojectDAO().getByTechId(id);
    }

    private static final <T> List<T> cast(List list) {
        return list;
    }

    private static final class GroupDataSetMapper
    implements IMapper<List<DataSetAccessPE>, List<DataSetAccessPE>> {
        private GroupDataSetMapper() {
        }

        public List<DataSetAccessPE> map(List<DataSetAccessPE> list) {
            for (DataSetAccessPE item : list) {
                item.setGroup(true);
            }
            return list;
        }
    }

    private static final class GroupSampleMapper
    implements IMapper<List<SampleAccessPE>, List<SampleAccessPE>> {
        private GroupSampleMapper() {
        }

        public List<SampleAccessPE> map(List<SampleAccessPE> list) {
            for (SampleAccessPE item : list) {
                item.setGroup(true);
            }
            return list;
        }
    }

    private static final class GroupExperimentMapper
    implements IMapper<List<ExperimentAccessPE>, List<ExperimentAccessPE>> {
        private GroupExperimentMapper() {
        }

        public List<ExperimentAccessPE> map(List<ExperimentAccessPE> list) {
            for (ExperimentAccessPE item : list) {
                item.setGroup(true);
            }
            return list;
        }
    }

    private static final class TechId2LongMapper
    implements IMapper<List<TechId>, List<?>> {
        private TechId2LongMapper() {
        }

        public List<?> map(List<TechId> techIds) {
            return TechId.asLongs(techIds);
        }
    }

    private static final class PermId2StringMapper
    implements IMapper<List<PermId>, List<?>> {
        private PermId2StringMapper() {
        }

        public List<?> map(List<PermId> permIds) {
            return PermId.asStrings(permIds);
        }
    }
}

