/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization;

import ch.systemsx.cisd.common.exceptions.AuthorizationFailureException;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.exceptions.StatusFlag;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.authorization.AuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.DefaultAccessController;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.DataSetCodePredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.ExperimentAugmentedCodePredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.IPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.MetaprojectTechIdPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SampleAugmentedCodePredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SpaceIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class AuthorizationServiceUtils {
    private final IDAOFactory daoFactory;
    private final PersonPE user;
    private final List<RoleWithIdentifier> userRoles;

    public AuthorizationServiceUtils(IDAOFactory daoFactory, String userId) {
        this(daoFactory, AuthorizationServiceUtils.getUserByName(daoFactory, userId));
    }

    public AuthorizationServiceUtils(IDAOFactory daoFactory, PersonPE user) {
        this.daoFactory = daoFactory;
        this.user = user;
        this.userRoles = DefaultAccessController.getUserRoles(user);
    }

    public boolean doesUserHaveRole(String roleCode, String spaceOrNull) {
        RoleWithHierarchy methodRole;
        try {
            RoleWithHierarchy.RoleLevel roleLevel = spaceOrNull == null ? RoleWithHierarchy.RoleLevel.INSTANCE : RoleWithHierarchy.RoleLevel.SPACE;
            methodRole = RoleWithHierarchy.valueOf(roleLevel, RoleWithHierarchy.RoleCode.valueOf(roleCode));
        }
        catch (Exception e) {
            if (spaceOrNull == null) {
                throw new IllegalArgumentException("Incorrect role " + roleCode + " specified. The correct roles for space are ADMIN, USER, POWER_USER, OBSERVER");
            }
            throw new IllegalArgumentException("Incorrect role " + roleCode + " specified. The correct instance roles are ADMIN, OBSERVER");
        }
        if (this.user.getAllPersonRoles().size() == 0) {
            return false;
        }
        List<RoleWithIdentifier> retainedUserRoles = DefaultAccessController.retainMatchingRoleWithIdentifiers(new ArrayList<RoleWithIdentifier>(this.userRoles), methodRole.getRoles());
        if (retainedUserRoles.size() == 0) {
            return false;
        }
        if (spaceOrNull != null) {
            SpaceIdentifierPredicate predicate = new SpaceIdentifierPredicate();
            predicate.init(new AuthorizationDataProvider(this.daoFactory));
            Status status = predicate.evaluate(this.user, retainedUserRoles, new SpaceIdentifier(spaceOrNull));
            return status.getFlag().equals((Object)StatusFlag.OK);
        }
        return true;
    }

    public boolean doesUserHaveRole(RoleWithHierarchy role) {
        if (this.user.getAllPersonRoles().size() == 0) {
            return false;
        }
        List<RoleWithIdentifier> retainedUserRoles = DefaultAccessController.retainMatchingRoleWithIdentifiers(new ArrayList<RoleWithIdentifier>(this.userRoles), role.getRoles());
        return retainedUserRoles.size() != 0;
    }

    private static PersonPE getUserByName(IDAOFactory daoFactory, String userId) {
        PersonPE person = daoFactory.getPersonDAO().tryFindPersonByUserId(userId);
        if (person == null) {
            throw new IllegalArgumentException("The user with id " + userId + " doesn't exist");
        }
        return person;
    }

    public List<String> filterDataSetCodes(List<String> dataSetCodes) {
        LinkedList<String> resultList = new LinkedList<String>();
        for (String dataSetCode : dataSetCodes) {
            if (!this.canAccessDataSet(dataSetCode)) continue;
            resultList.add(dataSetCode);
        }
        return resultList;
    }

    public boolean canAccessDataSet(DataPE dataSet) {
        return this.canAccessDataSet(dataSet.getCode());
    }

    public boolean canAccessDataSet(AbstractExternalData dataSet) {
        return this.canAccessDataSet(dataSet.getCode());
    }

    private boolean canAccessDataSet(String dataSetCode) {
        DataSetCodePredicate predicate = new DataSetCodePredicate();
        predicate.init(new AuthorizationDataProvider(this.daoFactory));
        Status status = predicate.evaluate(this.user, this.userRoles, dataSetCode);
        return status.getFlag().equals((Object)StatusFlag.OK);
    }

    public List<String> filterExperimentIds(List<String> experimentIds) {
        LinkedList<String> resultList = new LinkedList<String>();
        for (String experimentId : experimentIds) {
            if (!this.canAccessExperiment(experimentId)) continue;
            resultList.add(experimentId);
        }
        return resultList;
    }

    public boolean canAccessMetaproject(MetaprojectPE metaprojectPE) {
        MetaprojectTechIdPredicate predicate = new MetaprojectTechIdPredicate();
        predicate.init(new AuthorizationDataProvider(this.daoFactory));
        Status status = predicate.evaluate(this.user, this.userRoles, new TechId(metaprojectPE.getId()));
        return status.getFlag().equals((Object)StatusFlag.OK);
    }

    public void checkAccessMetaproject(MetaprojectPE metaprojectPE) {
        if (!this.canAccessMetaproject(metaprojectPE)) {
            throw new AuthorizationFailureException("User: " + (this.user != null ? this.user.getUserId() : null) + " doesn't have access to metaproject: " + metaprojectPE.getIdentifier());
        }
    }

    private void checkEntityNotNull(Object entity, EntityKind entityKind, TechId entityId) {
        if (entity == null) {
            throw UserFailureException.fromTemplate((String)"There is no %s with id '%s'.", (Object[])new Object[]{entityKind.getDescription(), entityId});
        }
    }

    public void checkAccessEntity(EntityKind entityKind, TechId entityId) {
        boolean canAccess;
        if (EntityKind.EXPERIMENT.equals((Object)entityKind)) {
            ExperimentPE experiment = (ExperimentPE)this.daoFactory.getExperimentDAO().getByTechId(entityId);
            this.checkEntityNotNull((Object)experiment, entityKind, entityId);
            canAccess = this.canAccessExperiment(experiment);
        } else if (EntityKind.SAMPLE.equals((Object)entityKind)) {
            SamplePE sample = (SamplePE)this.daoFactory.getSampleDAO().getByTechId(entityId);
            this.checkEntityNotNull((Object)sample, entityKind, entityId);
            canAccess = this.canAccessSample(sample);
        } else if (EntityKind.DATA_SET.equals((Object)entityKind)) {
            DataPE dataSet = (DataPE)this.daoFactory.getDataDAO().getByTechId(entityId);
            this.checkEntityNotNull((Object)dataSet, entityKind, entityId);
            canAccess = this.canAccessDataSet(dataSet);
        } else if (EntityKind.MATERIAL.equals((Object)entityKind)) {
            canAccess = true;
        } else {
            throw new IllegalArgumentException("Unknown entity kind: " + entityKind);
        }
        if (!canAccess) {
            throw new AuthorizationFailureException("User: " + (this.user != null ? this.user.getUserId() : null) + " doesn't have access to entity: " + entityKind + " with id: " + entityId);
        }
    }

    private void checkEntityNotNull(Object entity, EntityKind entityKind, String entityPermId) {
        if (entity == null) {
            throw UserFailureException.fromTemplate((String)"There is no %s with permId '%s'.", (Object[])new Object[]{entityKind.getDescription(), entityPermId});
        }
    }

    public void checkAccessEntity(EntityKind entityKind, String entityPermId) {
        boolean canAccess;
        if (EntityKind.EXPERIMENT.equals((Object)entityKind)) {
            ExperimentPE experiment = this.daoFactory.getExperimentDAO().tryGetByPermID(entityPermId);
            this.checkEntityNotNull((Object)experiment, entityKind, entityPermId);
            canAccess = this.canAccessExperiment(experiment);
        } else if (EntityKind.SAMPLE.equals((Object)entityKind)) {
            SamplePE sample = this.daoFactory.getSampleDAO().tryToFindByPermID(entityPermId);
            this.checkEntityNotNull((Object)sample, entityKind, entityPermId);
            canAccess = this.canAccessSample(sample);
        } else if (EntityKind.DATA_SET.equals((Object)entityKind)) {
            DataPE dataSet = this.daoFactory.getDataDAO().tryToFindDataSetByCode(entityPermId);
            this.checkEntityNotNull((Object)dataSet, entityKind, entityPermId);
            canAccess = this.canAccessDataSet(dataSet);
        } else if (EntityKind.MATERIAL.equals((Object)entityKind)) {
            canAccess = true;
        } else {
            throw new IllegalArgumentException("Unknown entity kind: " + entityKind);
        }
        if (!canAccess) {
            throw new AuthorizationFailureException("User: " + (this.user != null ? this.user.getUserId() : null) + " doesn't have access to entity: " + entityKind + " with permId: " + entityPermId);
        }
    }

    public boolean canAccessExperiment(Experiment experiment) {
        return this.canAccessExperiment(experiment.getIdentifier());
    }

    public boolean canAccessExperiment(ExperimentPE experimentPE) {
        return this.canAccessExperiment(experimentPE.getIdentifier());
    }

    private boolean canAccessExperiment(String experimentId) {
        ExperimentAugmentedCodePredicate predicate = new ExperimentAugmentedCodePredicate();
        predicate.init(new AuthorizationDataProvider(this.daoFactory));
        Status status = predicate.evaluate(this.user, this.userRoles, experimentId);
        return status.getFlag().equals((Object)StatusFlag.OK);
    }

    public List<String> filterSampleIds(List<String> sampleIds) {
        LinkedList<String> resultList = new LinkedList<String>();
        for (String sampleIdentifier : sampleIds) {
            if (!this.canAccessSample(sampleIdentifier)) continue;
            resultList.add(sampleIdentifier);
        }
        return resultList;
    }

    public boolean canAccessSample(SamplePE sample) {
        return this.canAccessSample(sample.getIdentifier());
    }

    public boolean canAccessSample(Sample sample) {
        return this.canAccessSample(sample.getIdentifier());
    }

    private boolean canAccessSample(String sampleIdentifier) {
        IPredicate<String> predicate = AuthorizationServiceUtils.createSampleIdentifierPredicate(this.daoFactory);
        return this.canAccessSample(predicate, sampleIdentifier);
    }

    private boolean canAccessSample(IPredicate<String> predicate, String sampleIdentifier) {
        Status status = predicate.evaluate(this.user, this.userRoles, sampleIdentifier);
        return Status.OK.equals((Object)status);
    }

    private static IPredicate<String> createSampleIdentifierPredicate(IDAOFactory daoFactory) {
        SampleAugmentedCodePredicate predicate = new SampleAugmentedCodePredicate();
        predicate.init(new AuthorizationDataProvider(daoFactory));
        return predicate;
    }
}

