/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.Capability;
import ch.systemsx.cisd.openbis.generic.shared.authorization.AuthorizationConfigFacade;
import ch.systemsx.cisd.openbis.generic.shared.authorization.IAuthorizationConfig;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

class CapabilityMap {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, CapabilityMap.class);
    private final IAuthorizationConfig authorizationConfig;
    private final Map<String, Collection<RoleWithHierarchy>> capMap = new HashMap<String, Collection<RoleWithHierarchy>>();

    private static final List<String> readLines(File file) {
        if (!file.exists()) {
            if (operationLog.isDebugEnabled()) {
                operationLog.debug((Object)String.format("No file '%s", file.getPath()));
            }
            return Collections.emptyList();
        }
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)("Reading capability role map file " + file));
        }
        try {
            return FileUtils.readLines((File)file);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }

    CapabilityMap(File file, IAuthorizationConfig authorizationConfig) {
        this(CapabilityMap.readLines(file), file.getPath(), authorizationConfig);
    }

    CapabilityMap(List<String> lines, String filePath, IAuthorizationConfig authorizationConfig) {
        this.authorizationConfig = authorizationConfig;
        for (String line : lines) {
            String trimmed = line.trim();
            if (trimmed.length() == 0 || trimmed.startsWith("#")) continue;
            String[] terms = StringUtils.split((String)trimmed, (char)';');
            String firstTerm = terms[0].trim();
            String[] firstTermSplitted = StringUtils.split((String)firstTerm, (String)" \t:", (int)2);
            if (firstTermSplitted.length != 2) {
                this.logWarning(line, filePath, null);
                continue;
            }
            String capabilityName = firstTermSplitted[0].toUpperCase();
            if (firstTermSplitted[1].contains("=")) {
                this.addRolesForParameter(capabilityName, firstTermSplitted[1], trimmed, filePath);
            } else {
                String roleNames = firstTermSplitted[1];
                this.addRoles(capabilityName, roleNames, trimmed, filePath);
            }
            for (int i = 1; i < terms.length; ++i) {
                this.addRolesForParameter(capabilityName, terms[i].trim(), trimmed, filePath);
            }
        }
    }

    private void addRolesForParameter(String capabilityName, String parameterTerm, String line, String filePath) {
        int indexOfEqual = parameterTerm.indexOf(61);
        if (indexOfEqual < 0) {
            this.logWarning(line, filePath, "missing '='");
            return;
        }
        String parameterName = parameterTerm.substring(0, indexOfEqual).trim().toUpperCase();
        if (StringUtils.isBlank((CharSequence)parameterName)) {
            this.logWarning(line, filePath, "parameter name not specified");
            return;
        }
        String roleNames = parameterTerm.substring(indexOfEqual + 1).trim();
        this.addRoles(capabilityName + ":" + parameterName, roleNames, line, filePath);
    }

    private void addRoles(String capabilityName, String roleNames, String line, String filePath) {
        Collection<RoleWithHierarchy> roles = this.capMap.get(capabilityName);
        if (roles == null) {
            roles = new HashSet<RoleWithHierarchy>();
            this.capMap.put(capabilityName, roles);
        }
        AuthorizationConfigFacade configFacade = new AuthorizationConfigFacade(this.authorizationConfig);
        for (String roleName : StringUtils.split((String)roleNames, (String)",")) {
            roleName = roleName.trim().toUpperCase();
            try {
                RoleWithHierarchy role = RoleWithHierarchy.valueOf(roleName);
                if (configFacade.isRoleEnabled(role)) {
                    roles.add(role);
                    if (!operationLog.isDebugEnabled()) continue;
                    operationLog.debug((Object)String.format("Add to map: '%s' -> %s", capabilityName, role));
                    continue;
                }
                this.logWarning(line, filePath, "role '" + roleName + "' doesn't exist");
            }
            catch (IllegalArgumentException ex) {
                this.logWarning(line, filePath, "role '" + roleName + "' doesn't exist");
            }
        }
    }

    private void logWarning(String line, String filePath, String messageOrNull) {
        String msg = String.format("Ignoring mal-formed line '%s' in %s", line, filePath);
        msg = messageOrNull == null ? msg + "." : msg + " [" + messageOrNull + "].";
        operationLog.warn((Object)msg);
    }

    Collection<RoleWithHierarchy> tryGetRoles(Method m, String argumentNameOrNull) {
        Capability cap = m.getAnnotation(Capability.class);
        if (cap == null) {
            return null;
        }
        String capabilityName = cap.value().toUpperCase();
        if (StringUtils.isNotBlank((CharSequence)argumentNameOrNull)) {
            capabilityName = capabilityName + ":" + argumentNameOrNull.toUpperCase();
        }
        Collection<RoleWithHierarchy> rolesOrNull = this.capMap.get(capabilityName);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("Request: '%s' -> %s", capabilityName, rolesOrNull));
        }
        return rolesOrNull;
    }
}

