/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.reflection.MethodUtils;
import ch.systemsx.cisd.openbis.generic.server.authorization.Argument;
import ch.systemsx.cisd.openbis.generic.server.authorization.CapabilityMap;
import ch.systemsx.cisd.openbis.generic.server.authorization.IAccessController;
import ch.systemsx.cisd.openbis.generic.server.authorization.PredicateExecutor;
import ch.systemsx.cisd.openbis.generic.server.authorization.PredicateFactory;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.AuthorizationGuard;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.RolesAllowed;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IAuthorizationDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.authorization.IAuthorizationConfig;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.dto.IAuthSession;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.RoleAssignmentPE;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.log4j.Logger;

public final class DefaultAccessController
implements IAccessController {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, DefaultAccessController.class);
    @Private
    static final String MATCHING_ROLE_NOT_FOUND_TEMPLATE = "None of method roles '%s' could be found in roles of user '%s'.";
    @Private
    static final String USER_ROLE_ASSIGNMENTS_NOT_FOUND_TEMPLATE = "No role assignments could be found for user '%s'.";
    @Private
    static final String METHOD_ROLES_NOT_FOUND_TEMPLATE = "No roles have been found for method '%s'.";
    private final Map<Method, Set<RoleWithHierarchy>> methodRolesCache = new HashMap<Method, Set<RoleWithHierarchy>>();
    private final Map<Method, Map<String, Set<RoleWithHierarchy>>> argumentRolesCache = new HashMap<Method, Map<String, Set<RoleWithHierarchy>>>();
    private final CapabilityMap capabilities;
    private PredicateExecutor predicateExecutor;
    private IAuthorizationDAOFactory daoFactory;

    public DefaultAccessController(IAuthorizationDAOFactory daoFactory) {
        this.capabilities = new CapabilityMap(new File("etc/capabilities"), daoFactory.getAuthorizationConfig());
        this.predicateExecutor = new PredicateExecutor();
        this.predicateExecutor.setPredicateFactory(new PredicateFactory());
        this.predicateExecutor.setDAOFactory(daoFactory);
        this.daoFactory = daoFactory;
    }

    public static final List<RoleWithIdentifier> getUserRoles(PersonPE person) {
        Set<RoleAssignmentPE> roleAssignments = person.getAllPersonRoles();
        return DefaultAccessController.extractRolesWithIdentifiers(roleAssignments);
    }

    private static List<RoleWithIdentifier> extractRolesWithIdentifiers(Set<RoleAssignmentPE> roleAssignments) {
        ArrayList<RoleWithIdentifier> roles = new ArrayList<RoleWithIdentifier>();
        for (RoleAssignmentPE roleAssignment : roleAssignments) {
            roles.add(RoleWithIdentifier.createRole(roleAssignment));
        }
        return roles;
    }

    private static final void logTimeTaken(StopWatch stopWatch, Method method) {
        stopWatch.stop();
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("Controlling access to method '%s' took %s", MethodUtils.describeMethod((Method)method), stopWatch));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Status isAuthorized(IAuthSession session, Method method, Argument<?>[] arguments) throws UserFailureException {
        assert (session != null) : "Unspecified session";
        assert (method != null) : "Unspecified method";
        assert (arguments != null) : "Unspecified method arguments";
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            Set<RoleWithHierarchy> methodRoles = this.getMethodRoles(method);
            if (methodRoles.size() == 0) {
                String msg = String.format(METHOD_ROLES_NOT_FOUND_TEMPLATE, MethodUtils.describeMethod((Method)method));
                Status status = Status.createError((String)msg);
                return status;
            }
            PersonPE person = session.tryGetPerson();
            if (person == null || person.getAllPersonRoles().size() == 0) {
                String msg = String.format(USER_ROLE_ASSIGNMENTS_NOT_FOUND_TEMPLATE, session.getUserName());
                Status status = Status.createError((String)msg);
                return status;
            }
            List<RoleWithIdentifier> userRoles = DefaultAccessController.getUserRoles(person);
            Status status = Status.OK;
            if (((Argument<?>[])arguments).length > 0) {
                for (Argument<?> argument : arguments) {
                    Set<RoleWithHierarchy> argumentRoles = this.getArgumentRoles(method, argument, methodRoles);
                    List<RoleWithIdentifier> relevantRoles = this.getRelevantRoles(userRoles, argumentRoles);
                    relevantRoles = this.retainConfiguredRoles(person.getUserId(), relevantRoles);
                    status = this.checkNotEmpty(relevantRoles, argumentRoles, session);
                    if (!status.isError() && !(status = this.predicateExecutor.evaluate(person, relevantRoles, argument)).isError()) {
                        continue;
                    }
                    break;
                }
            } else {
                List<RoleWithIdentifier> relevantRoles = this.getRelevantRoles(userRoles, methodRoles);
                relevantRoles = this.retainConfiguredRoles(person.getUserId(), relevantRoles);
                status = this.checkNotEmpty(relevantRoles, methodRoles, session);
            }
            Status status2 = status;
            return status2;
        }
        finally {
            DefaultAccessController.logTimeTaken(stopWatch, method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<RoleWithHierarchy> getMethodRoles(Method method) {
        Map<Method, Set<RoleWithHierarchy>> map = this.methodRolesCache;
        synchronized (map) {
            Set<RoleWithHierarchy> roles = this.methodRolesCache.get(method);
            if (roles == null) {
                roles = new LinkedHashSet<RoleWithHierarchy>();
                for (RoleWithHierarchy role : this.getRootRoles(method)) {
                    roles.addAll(role.getRoles());
                }
                this.methodRolesCache.put(method, roles);
            }
            return roles;
        }
    }

    private Collection<RoleWithHierarchy> getRootRoles(Method method) {
        Collection<RoleWithHierarchy> rootRoles = this.capabilities.tryGetRoles(method, null);
        if (rootRoles == null) {
            RolesAllowed rolesAllowed = method.getAnnotation(RolesAllowed.class);
            rootRoles = rolesAllowed != null ? Arrays.asList(rolesAllowed.value()) : Collections.emptyList();
        }
        return rootRoles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<RoleWithHierarchy> getArgumentRoles(Method method, Argument<?> argument, Set<RoleWithHierarchy> defaultRoles) {
        Map<Method, Map<String, Set<RoleWithHierarchy>>> map = this.argumentRolesCache;
        synchronized (map) {
            Set<RoleWithHierarchy> roles;
            AuthorizationGuard predicateCandidate = argument.getPredicateCandidate();
            if (predicateCandidate == null) {
                return defaultRoles;
            }
            String name = predicateCandidate.name();
            Map<String, Set<RoleWithHierarchy>> map2 = this.argumentRolesCache.get(method);
            if (map2 == null) {
                map2 = new HashMap<String, Set<RoleWithHierarchy>>();
                this.argumentRolesCache.put(method, map2);
            }
            if ((roles = map2.get(name)) == null) {
                roles = new LinkedHashSet<RoleWithHierarchy>();
                for (RoleWithHierarchy role : this.getRootRoles(method, predicateCandidate, defaultRoles)) {
                    roles.addAll(role.getRoles());
                }
                map2.put(name, Collections.unmodifiableSet(roles));
            }
            return roles;
        }
    }

    private Collection<RoleWithHierarchy> getRootRoles(Method method, AuthorizationGuard predicateCandidate, Set<RoleWithHierarchy> defaultRoles) {
        Collection<RoleWithHierarchy> roles = this.capabilities.tryGetRoles(method, predicateCandidate.name());
        if (roles == null) {
            RoleWithHierarchy[] rolesAllowed = predicateCandidate.rolesAllowed();
            roles = rolesAllowed.length == 0 ? defaultRoles : Arrays.asList(rolesAllowed);
        }
        return roles;
    }

    private Status checkNotEmpty(List<RoleWithIdentifier> relevantRoles, Set<RoleWithHierarchy> argumentRoles, IAuthSession session) {
        if (!relevantRoles.isEmpty()) {
            return Status.OK;
        }
        String msg = String.format(MATCHING_ROLE_NOT_FOUND_TEMPLATE, argumentRoles, session.getUserName());
        return Status.createError((String)msg);
    }

    private List<RoleWithIdentifier> getRelevantRoles(List<RoleWithIdentifier> userRoles, Set<RoleWithHierarchy> methodOrParameterRoles) {
        ArrayList<RoleWithIdentifier> result = new ArrayList<RoleWithIdentifier>();
        for (RoleWithIdentifier roleWithIdentifier : userRoles) {
            if (!methodOrParameterRoles.contains(roleWithIdentifier.getRole())) continue;
            result.add(roleWithIdentifier);
        }
        return result;
    }

    private List<RoleWithIdentifier> retainConfiguredRoles(String userId, List<RoleWithIdentifier> roles) {
        IAuthorizationConfig config = this.daoFactory.getAuthorizationConfig();
        if (config.isProjectLevelEnabled() && config.isProjectLevelUser(userId)) {
            return roles;
        }
        ArrayList<RoleWithIdentifier> nonProjectRoles = new ArrayList<RoleWithIdentifier>();
        for (RoleWithIdentifier role : roles) {
            if (RoleWithHierarchy.RoleLevel.PROJECT.equals((Object)role.getRoleLevel())) continue;
            nonProjectRoles.add(role);
        }
        return nonProjectRoles;
    }

    public static List<RoleWithIdentifier> retainMatchingRoleWithIdentifiers(List<RoleWithIdentifier> userRoles, Set<RoleWithHierarchy> methodRoles) {
        Iterator<RoleWithIdentifier> it = userRoles.iterator();
        while (it.hasNext()) {
            RoleWithIdentifier roleWithIdentifier = it.next();
            if (methodRoles.contains(roleWithIdentifier.getRole())) continue;
            it.remove();
        }
        return userRoles;
    }
}

