/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.collection.FilteredList;
import ch.systemsx.cisd.common.collection.IModifiable;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.reflection.MethodUtils;
import ch.systemsx.cisd.openbis.generic.server.authorization.AuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.IReturnValueFilter;
import ch.systemsx.cisd.openbis.generic.server.authorization.ValidatorStore;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.ReturnValueFilter;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.ICollectionValidator;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.IValidator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IAuthorizationDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.IAuthSession;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.log4j.Logger;

public final class DefaultReturnValueFilter
implements IReturnValueFilter {
    @Private
    static final String FILTER_APPLIED_ON_VALUE = "Filter applied on method '%s': return value filtered out.";
    @Private
    static final String FILTER_APPLIED_ON_LIST = "Filter applied on method '%s': %d items filtered out.";
    @Private
    static final String FILTER_APPLIED_ON_ARRAY = "Filter applied on method '%s': %d items filtered out.";
    @Private
    static final String NO_ANNOTATION_FOUND_MSG_FORMAT = "No filter applied on method '%s': no annotation '%s' found.";
    @Private
    static final String NULL_RETURN_VALUE_MSG_FORMAT = "No filter applied on method '%s': return value is null.";
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, DefaultReturnValueFilter.class);
    private IAuthorizationDataProvider authorizationDataProvider;

    public DefaultReturnValueFilter(IAuthorizationDAOFactory daoFactory) {
        this.authorizationDataProvider = new AuthorizationDataProvider(daoFactory);
    }

    private final <T> IValidator<T> getValidator(ReturnValueFilter annotation) {
        return ValidatorStore.getValidatorForClass(annotation.validatorClass(), this.authorizationDataProvider);
    }

    private static final <T> T[] castToArray(Object value) {
        return (Object[])value;
    }

    private static final <T> List<T> castToList(Object value) {
        return (List)value;
    }

    private static final <T> Collection<T> castToCollection(Object value) {
        return (Collection)value;
    }

    private static final <T> T cast(Object value) {
        return (T)value;
    }

    private static final <T> List<T> proceedList(PersonPE person, Method method, List<T> returnValue, IValidator<T> validator) {
        if (returnValue.size() == 0) {
            return returnValue;
        }
        List<T> list = returnValue instanceof IModifiable ? returnValue : new ArrayList<T>(returnValue);
        int oldSize = list.size();
        FilteredList.decorate(list, new ValidatorAdapter<T>(validator, person));
        int diff = oldSize - list.size();
        if (diff > 0) {
            operationLog.info((Object)String.format("Filter applied on method '%s': %d items filtered out.", MethodUtils.describeMethod((Method)method), diff));
        }
        return list;
    }

    private static final <T> T[] proceedArray(PersonPE person, Method method, IValidator<T> validator, T[] returnValue) {
        T[] array;
        if (returnValue.length == 0) {
            return returnValue;
        }
        List list = FilteredList.decorate((Object[])returnValue, new ValidatorAdapter<T>(validator, person));
        T[] newValue = DefaultReturnValueFilter.castToArray(list.toArray(array = DefaultReturnValueFilter.castToArray(Array.newInstance(returnValue.getClass().getComponentType(), list.size()))));
        int diff = returnValue.length - newValue.length;
        if (diff > 0) {
            operationLog.info((Object)String.format("Filter applied on method '%s': %d items filtered out.", MethodUtils.describeMethod((Method)method), diff));
        }
        return newValue;
    }

    private static final <T> Object proceedValue(PersonPE person, Method method, Object returnValue, IValidator<T> validator, T value) {
        if (validator.isValid(person, value)) {
            return returnValue;
        }
        operationLog.info((Object)String.format(FILTER_APPLIED_ON_VALUE, MethodUtils.describeMethod((Method)method)));
        return null;
    }

    private static final void logTimeTaken(StopWatch stopWatch, Method method) {
        stopWatch.stop();
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("Return value filtering of method '%s' took %s", MethodUtils.describeMethod((Method)method), stopWatch));
        }
    }

    @Private
    final <T> Object proceed(PersonPE person, Method method, Object returnValue, IValidator<T> validator) {
        String validatorClassName = validator.getClass().getName();
        Class<?> returnValueClass = returnValue.getClass();
        if (returnValue instanceof List) {
            List<T> list = DefaultReturnValueFilter.castToList(returnValue);
            try {
                return DefaultReturnValueFilter.proceedList(person, method, list, validator);
            }
            catch (ClassCastException ex) {
                throw new IllegalArgumentException(String.format("Given validator class '%s' and list type '%s' are not compatible.", validatorClassName, list.get(0).getClass().getName()));
            }
        }
        if (returnValueClass.isArray()) {
            T[] array = DefaultReturnValueFilter.castToArray(returnValue);
            try {
                return DefaultReturnValueFilter.proceedArray(person, method, validator, array);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(String.format("Given validator class '%s' and array type '%s' are not compatible.", validatorClassName, returnValueClass.getComponentType().getName()));
            }
        }
        T value = DefaultReturnValueFilter.cast(returnValue);
        try {
            return DefaultReturnValueFilter.proceedValue(person, method, returnValue, validator, value);
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException(String.format("Given validator class '%s' and return value type '%s' are not compatible.", validatorClassName, returnValueClass.getName()));
        }
    }

    private Object proceedCollection(PersonPE person, Method method, Object returnValue, ICollectionValidator<?> validator) {
        if (returnValue instanceof Collection) {
            return validator.getValid(person, DefaultReturnValueFilter.castToCollection(returnValue));
        }
        throw new IllegalArgumentException(String.format("Returned value '%s' is not a collection and cannot be validated by a collection validator '%s'.", returnValue.getClass(), validator.getClass().getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object applyFilter(IAuthSession session, Method method, Object returnValueOrNull) {
        assert (session != null) : "Unspecified session";
        assert (method != null) : "Unspecified method";
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            if (returnValueOrNull == null) {
                operationLog.debug((Object)String.format(NULL_RETURN_VALUE_MSG_FORMAT, MethodUtils.describeMethod((Method)method)));
                Object object = returnValueOrNull;
                return object;
            }
            ReturnValueFilter annotation = method.getAnnotation(ReturnValueFilter.class);
            if (annotation == null) {
                operationLog.debug((Object)String.format(NO_ANNOTATION_FOUND_MSG_FORMAT, MethodUtils.describeMethod((Method)method), ReturnValueFilter.class.getSimpleName()));
                Object object = returnValueOrNull;
                return object;
            }
            IValidator validator = this.getValidator(annotation);
            if (validator instanceof ICollectionValidator) {
                Object object = this.proceedCollection(session.tryGetPerson(), method, returnValueOrNull, (ICollectionValidator)validator);
                return object;
            }
            Object object = this.proceed(session.tryGetPerson(), method, returnValueOrNull, validator);
            return object;
        }
        finally {
            DefaultReturnValueFilter.logTimeTaken(stopWatch, method);
        }
    }

    private static final class ValidatorAdapter<T>
    implements ch.systemsx.cisd.common.collection.IValidator<T> {
        private final IValidator<T> validator;
        private final PersonPE person;

        ValidatorAdapter(IValidator<T> validator, PersonPE person) {
            this.validator = validator;
            this.person = person;
        }

        public final boolean isValid(T object) {
            return this.validator.isValid(this.person, object);
        }
    }
}

